/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.DynamicFeaturePlugin;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.LibraryPlugin;
import com.android.build.gradle.TestExtension;
import com.android.build.gradle.TestPlugin;
import com.android.build.gradle.api.ApkVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.api.UnitTestVariant;
import com.android.build.gradle.internal.api.TestedVariant;
import com.android.builder.model.SourceProvider;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.PluginCollection;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.sonarqube.gradle.JavaCompilerUtils;
import org.sonarqube.gradle.SonarUtils;

class AndroidUtils {
    private static final Logger LOGGER = Logging.getLogger(AndroidUtils.class);

    private AndroidUtils() {
    }

    static void configureForAndroid(Project project, String userConfiguredBuildVariantName, Map<String, Object> properties) {
        BaseVariant variant = AndroidUtils.findVariant(project, userConfiguredBuildVariantName);
        if (variant != null) {
            AndroidUtils.configureForAndroid(project, variant, properties);
        } else {
            LOGGER.warn("No variant found for '{}'. No android specific configuration will be done", (Object)project.getName());
        }
    }

    private static void configureForAndroid(Project project, BaseVariant variant, Map<String, Object> properties) {
        List<File> bootClassPath = AndroidUtils.getBootClasspath(project);
        if (project.getPlugins().hasPlugin("com.android.test")) {
            AndroidUtils.populateSonarQubeProps(properties, bootClassPath, variant, true);
        } else {
            AndroidUtils.populateSonarQubeProps(properties, bootClassPath, variant, false);
            if (variant instanceof TestedVariant) {
                TestVariant testVariant;
                UnitTestVariant unitTestVariant = ((TestedVariant)variant).getUnitTestVariant();
                if (unitTestVariant != null) {
                    AndroidUtils.populateSonarQubeProps(properties, bootClassPath, (BaseVariant)unitTestVariant, true);
                }
                if ((testVariant = ((TestedVariant)variant).getTestVariant()) != null) {
                    AndroidUtils.populateSonarQubeProps(properties, bootClassPath, (BaseVariant)testVariant, true);
                }
            }
        }
    }

    @Nullable
    private static List<File> getBootClasspath(Project project) {
        PluginCollection appPlugins = project.getPlugins().withType(AppPlugin.class);
        if (!appPlugins.isEmpty()) {
            AppExtension androidExtension = (AppExtension)project.getExtensions().getByType(AppExtension.class);
            return androidExtension.getBootClasspath();
        }
        PluginCollection libPlugins = project.getPlugins().withType(LibraryPlugin.class);
        if (!libPlugins.isEmpty()) {
            LibraryExtension androidExtension = (LibraryExtension)project.getExtensions().getByType(LibraryExtension.class);
            return androidExtension.getBootClasspath();
        }
        PluginCollection testPlugins = project.getPlugins().withType(TestPlugin.class);
        if (!testPlugins.isEmpty()) {
            TestExtension androidExtension = (TestExtension)project.getExtensions().getByType(TestExtension.class);
            return androidExtension.getBootClasspath();
        }
        PluginCollection dynamicFeaturePlugins = project.getPlugins().withType(DynamicFeaturePlugin.class);
        if (!dynamicFeaturePlugins.isEmpty()) {
            AppExtension androidExtension = (AppExtension)project.getExtensions().getByType(AppExtension.class);
            return androidExtension.getBootClasspath();
        }
        return null;
    }

    @Nullable
    private static String getTestBuildType(Project project) {
        PluginCollection appPlugins = project.getPlugins().withType(AppPlugin.class);
        if (!appPlugins.isEmpty()) {
            AppExtension androidExtension = (AppExtension)project.getExtensions().getByType(AppExtension.class);
            return androidExtension.getTestBuildType();
        }
        PluginCollection libPlugins = project.getPlugins().withType(LibraryPlugin.class);
        if (!libPlugins.isEmpty()) {
            LibraryExtension androidExtension = (LibraryExtension)project.getExtensions().getByType(LibraryExtension.class);
            return androidExtension.getTestBuildType();
        }
        PluginCollection dynamicFeaturePlugins = project.getPlugins().withType(DynamicFeaturePlugin.class);
        if (!dynamicFeaturePlugins.isEmpty()) {
            AppExtension androidExtension = (AppExtension)project.getExtensions().getByType(AppExtension.class);
            return androidExtension.getTestBuildType();
        }
        return null;
    }

    @Nullable
    static BaseVariant findVariant(Project project, @Nullable String userConfiguredBuildVariantName) {
        String testBuildType = AndroidUtils.getTestBuildType(project);
        PluginCollection appPlugins = project.getPlugins().withType(AppPlugin.class);
        if (!appPlugins.isEmpty()) {
            AppExtension androidExtension = (AppExtension)project.getExtensions().getByType(AppExtension.class);
            return AndroidUtils.findVariant(new ArrayList<BaseVariant>((Collection<BaseVariant>)androidExtension.getApplicationVariants()), testBuildType, userConfiguredBuildVariantName);
        }
        PluginCollection libPlugins = project.getPlugins().withType(LibraryPlugin.class);
        if (!libPlugins.isEmpty()) {
            LibraryExtension androidExtension = (LibraryExtension)project.getExtensions().getByType(LibraryExtension.class);
            return AndroidUtils.findVariant(new ArrayList<BaseVariant>((Collection<BaseVariant>)androidExtension.getLibraryVariants()), testBuildType, userConfiguredBuildVariantName);
        }
        PluginCollection testPlugins = project.getPlugins().withType(TestPlugin.class);
        if (!testPlugins.isEmpty()) {
            TestExtension androidExtension = (TestExtension)project.getExtensions().getByType(TestExtension.class);
            return AndroidUtils.findVariant(new ArrayList<BaseVariant>((Collection<BaseVariant>)androidExtension.getApplicationVariants()), testBuildType, userConfiguredBuildVariantName);
        }
        PluginCollection dynamicFeaturePlugins = project.getPlugins().withType(DynamicFeaturePlugin.class);
        if (!dynamicFeaturePlugins.isEmpty()) {
            AppExtension androidExtension = (AppExtension)project.getExtensions().getByType(AppExtension.class);
            return AndroidUtils.findVariant(new ArrayList<BaseVariant>((Collection<BaseVariant>)androidExtension.getApplicationVariants()), testBuildType, userConfiguredBuildVariantName);
        }
        return null;
    }

    @Nullable
    private static BaseVariant findVariant(List<BaseVariant> candidates, @Nullable String testBuildType, @Nullable String userConfiguredBuildVariantName) {
        if (candidates.isEmpty()) {
            return null;
        }
        if (userConfiguredBuildVariantName == null) {
            Optional<BaseVariant> firstDebug = candidates.stream().filter(v -> testBuildType != null && testBuildType.equals(v.getBuildType().getName())).findFirst();
            BaseVariant result = firstDebug.orElse(candidates.get(0));
            LOGGER.info("No variant name specified to be used by SonarQube. Default to '{}'", (Object)result.getName());
            return result;
        }
        Optional<BaseVariant> result = candidates.stream().filter(v -> userConfiguredBuildVariantName.equals(v.getName())).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        throw new IllegalArgumentException("Unable to find variant '" + userConfiguredBuildVariantName + "' to use for SonarQube analysis. Candidates are: " + candidates.stream().map(BaseVariant::getName).collect(Collectors.joining(", ")));
    }

    private static void populateSonarQubeProps(Map<String, Object> properties, List<File> bootClassPath, BaseVariant variant, boolean isTest) {
        JavaCompile javaCompile;
        List srcDirs = variant.getSourceSets().stream().map(AndroidUtils::getFilesFromSourceSet).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
        List sourcesOrTests = SonarUtils.nonEmptyOrNull(srcDirs.stream().filter(File::exists).collect(Collectors.toList()));
        if (sourcesOrTests != null) {
            SonarUtils.appendProps(properties, isTest ? "sonar.tests" : "sonar.sources", sourcesOrTests);
        }
        if ((javaCompile = AndroidUtils.getJavaCompiler(variant)) == null) {
            LOGGER.warn("Unable to find Java compiler on variant '{}'. Is Jack toolchain used? SonarQube analysis will be less accurate without bytecode.", (Object)variant.getName());
        } else {
            SonarUtils.populateJdkProperties(properties, JavaCompilerUtils.extractConfiguration(javaCompile));
            JavaCompilerUtils.extractConfiguration(javaCompile);
        }
        LinkedHashSet<File> libraries = new LinkedHashSet<File>(bootClassPath);
        if (variant instanceof ApkVariant) {
            libraries.addAll(AndroidUtils.getLibraries((ApkVariant)variant));
        }
        if (javaCompile != null) {
            libraries.addAll(javaCompile.getClasspath().filter(File::exists).getFiles());
        }
        if (isTest) {
            SonarUtils.setTestClasspathProps(properties, javaCompile != null ? Collections.singleton(javaCompile.getDestinationDir()) : Collections.emptySet(), libraries);
        } else {
            SonarUtils.setMainClasspathProps(properties, false, javaCompile != null ? Collections.singleton(javaCompile.getDestinationDir()) : Collections.emptySet(), libraries);
        }
    }

    @NotNull
    private static Collection<File> getLibraries(ApkVariant variant) {
        try {
            Method methodOnAndroidBefore30 = variant.getClass().getMethod("getCompileLibraries", new Class[0]);
            return (Set)methodOnAndroidBefore30.invoke((Object)variant, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            return variant.getCompileClasspath(null).getFiles();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to call getCompileLibraries", e);
        }
    }

    @Nullable
    private static JavaCompile getJavaCompiler(BaseVariant variant) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.10.1")) >= 0) {
            return (JavaCompile)variant.getJavaCompileProvider().getOrNull();
        }
        return variant.getJavaCompile();
    }

    private static List<File> getFilesFromSourceSet(SourceProvider sourceSet) {
        ArrayList<File> srcDirs = new ArrayList<File>();
        srcDirs.add(sourceSet.getManifestFile());
        srcDirs.addAll(sourceSet.getCDirectories());
        srcDirs.addAll(sourceSet.getAidlDirectories());
        srcDirs.addAll(sourceSet.getAssetsDirectories());
        srcDirs.addAll(sourceSet.getCppDirectories());
        srcDirs.addAll(sourceSet.getJavaDirectories());
        srcDirs.addAll(sourceSet.getRenderscriptDirectories());
        srcDirs.addAll(sourceSet.getResDirectories());
        srcDirs.addAll(sourceSet.getResourcesDirectories());
        return srcDirs;
    }
}

