/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentConfig {
    private static final Logger LOG = LoggerFactory.getLogger(EnvironmentConfig.class);
    private static final String SONAR_SCANNER_JSON_PARAMS = "SONAR_SCANNER_JSON_PARAMS";
    private static final String SONARQUBE_SCANNER_PARAMS = "SONARQUBE_SCANNER_PARAMS";
    private static final String GENERIC_ENV_PREFIX = "SONAR_SCANNER_";
    private static final String SONAR_HOST_URL_ENV_VAR = "SONAR_HOST_URL";
    private static final String SONAR_USER_HOME_ENV_VAR = "SONAR_USER_HOME";
    private static final String TOKEN_ENV_VARIABLE = "SONAR_TOKEN";

    private EnvironmentConfig() {
    }

    public static Map<String, String> load() {
        return EnvironmentConfig.load(System.getenv());
    }

    public static Map<String, String> load(Map<String, String> env) {
        HashMap<String, String> loadedProps = new HashMap<String, String>();
        Optional.ofNullable(env.get(SONAR_HOST_URL_ENV_VAR)).ifPresent(url -> loadedProps.put("sonar.host.url", (String)url));
        Optional.ofNullable(env.get(SONAR_USER_HOME_ENV_VAR)).ifPresent(path -> loadedProps.put("sonar.userHome", (String)path));
        Optional.ofNullable(env.get(TOKEN_ENV_VARIABLE)).ifPresent(path -> loadedProps.put("sonar.token", (String)path));
        env.forEach((key, value) -> {
            if (!key.equals(SONAR_SCANNER_JSON_PARAMS) && key.startsWith(GENERIC_ENV_PREFIX)) {
                EnvironmentConfig.processEnvVariable(key, value, loadedProps);
            }
        });
        String jsonParams = env.get(SONAR_SCANNER_JSON_PARAMS);
        String oldJsonParams = env.get(SONARQUBE_SCANNER_PARAMS);
        if (jsonParams != null) {
            if (oldJsonParams != null && !oldJsonParams.equals(jsonParams)) {
                LOG.warn("Ignoring environment variable '{}' because '{}' is set", (Object)SONARQUBE_SCANNER_PARAMS, (Object)SONAR_SCANNER_JSON_PARAMS);
            }
            EnvironmentConfig.parseJsonPropertiesFromEnv(jsonParams, loadedProps, SONAR_SCANNER_JSON_PARAMS);
        } else if (oldJsonParams != null) {
            EnvironmentConfig.parseJsonPropertiesFromEnv(oldJsonParams, loadedProps, SONARQUBE_SCANNER_PARAMS);
        }
        return loadedProps;
    }

    private static void parseJsonPropertiesFromEnv(String jsonParams, Map<String, String> inputProperties, String envVariableName) {
        try {
            Map jsonProperties = (Map)new Gson().fromJson(jsonParams, Map.class);
            if (jsonProperties != null) {
                jsonProperties.forEach((key, value) -> {
                    if (inputProperties.containsKey(key)) {
                        if (!((String)inputProperties.get(key)).equals(value)) {
                            LOG.warn("Ignoring property '{}' from env variable '{}' because it is already defined", key, (Object)envVariableName);
                        }
                    } else {
                        inputProperties.put((String)key, (String)value);
                    }
                });
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse JSON properties from environment variable '" + envVariableName + "'", e);
        }
    }

    private static void processEnvVariable(String key, String value, Map<String, String> inputProperties) {
        String suffix = key.substring(GENERIC_ENV_PREFIX.length());
        if (suffix.isEmpty()) {
            return;
        }
        String toCamelCase = Stream.of(suffix.split("_")).map(String::toLowerCase).reduce((a, b) -> a + StringUtils.capitalize((String)b)).orElseThrow();
        String propKey = "sonar.scanner." + toCamelCase;
        if (inputProperties.containsKey(propKey)) {
            if (!inputProperties.get(propKey).equals(value)) {
                LOG.warn("Ignoring environment variable '{}' because it is already defined in the properties", (Object)key);
            }
        } else {
            inputProperties.put(propKey, value);
        }
    }
}

