/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import javax.annotation.Nullable;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.Utils;
import org.sonarsource.scanner.lib.internal.http.HttpConfig;
import org.sonarsource.scanner.lib.internal.http.OkHttpClientFactory;

public class ScannerHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(ScannerHttpClient.class);
    private static final String EXCEPTION_MESSAGE_MISSING_SLASH = "URL path must start with slash: %s";
    private OkHttpClient httpClient;
    private HttpConfig httpConfig;

    public void init(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        this.httpClient = OkHttpClientFactory.create(httpConfig);
    }

    public void downloadFromRestApi(String urlPath, Path toFile) throws IOException {
        if (!urlPath.startsWith("/")) {
            throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE_MISSING_SLASH, urlPath));
        }
        String url = this.httpConfig.getRestApiBaseUrl() + urlPath;
        this.downloadFile(url, toFile, true);
    }

    public void downloadFromWebApi(String urlPath, Path toFile) throws IOException {
        if (!urlPath.startsWith("/")) {
            throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE_MISSING_SLASH, urlPath));
        }
        String url = this.httpConfig.getWebApiBaseUrl() + urlPath;
        this.downloadFile(url, toFile, true);
    }

    public void downloadFromExternalUrl(String url, Path toFile) throws IOException {
        this.downloadFile(url, toFile, false);
    }

    private void downloadFile(String url, Path toFile, boolean authentication) throws IOException {
        if (this.httpClient == null) {
            throw new IllegalStateException("ServerConnection must be initialized");
        }
        LOG.debug("Download {} to {}", (Object)url, (Object)toFile.toAbsolutePath());
        try (ResponseBody responseBody = this.callUrl(url, authentication, "application/octet-stream");
             InputStream in = responseBody.byteStream();){
            Files.copy(in, toFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException | RuntimeException e) {
            Utils.deleteQuietly(toFile);
            throw e;
        }
    }

    public String callRestApi(String urlPath) throws IOException {
        if (!urlPath.startsWith("/")) {
            throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE_MISSING_SLASH, urlPath));
        }
        String url = this.httpConfig.getRestApiBaseUrl() + urlPath;
        return this.callApi(url);
    }

    public String callWebApi(String urlPath) throws IOException {
        if (!urlPath.startsWith("/")) {
            throw new IllegalArgumentException(String.format(EXCEPTION_MESSAGE_MISSING_SLASH, urlPath));
        }
        String url = this.httpConfig.getWebApiBaseUrl() + urlPath;
        return this.callApi(url);
    }

    private String callApi(String url) throws IOException {
        if (this.httpClient == null) {
            throw new IllegalStateException("ServerConnection must be initialized");
        }
        try (ResponseBody responseBody = this.callUrl(url, true, null);){
            String string = responseBody.string();
            return string;
        }
    }

    private ResponseBody callUrl(String url, boolean authentication, @Nullable String acceptHeader) {
        Response response;
        Request.Builder requestBuilder = new Request.Builder().get().url(url).addHeader("User-Agent", this.httpConfig.getUserAgent());
        if (authentication) {
            if (this.httpConfig.getToken() != null) {
                requestBuilder.header("Authorization", "Bearer " + this.httpConfig.getToken());
            } else if (this.httpConfig.getLogin() != null) {
                requestBuilder.header("Authorization", Credentials.basic((String)this.httpConfig.getLogin(), (String)(this.httpConfig.getPassword() != null ? this.httpConfig.getPassword() : "")));
            }
        }
        if (acceptHeader != null) {
            requestBuilder.header("Accept", acceptHeader);
        }
        Request request = requestBuilder.build();
        try {
            response = this.httpClient.newCall(request).execute();
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Call to URL [%s] failed", url), e);
        }
        if (!response.isSuccessful()) {
            response.close();
            throw new IllegalStateException(String.format("Error status returned by url [%s]: %s", response.request().url(), response.code()));
        }
        return response.body();
    }
}

