/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.facade.inprocess;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.downloadcache.CachedFile;
import org.sonarsource.scanner.downloadcache.DownloadCache;
import org.sonarsource.scanner.downloadcache.Downloader;
import org.sonarsource.scanner.downloadcache.HashMismatchException;
import org.sonarsource.scanner.lib.internal.facade.inprocess.BootstrapIndexDownloader;
import org.sonarsource.scanner.lib.internal.facade.inprocess.JarExtractor;
import org.sonarsource.scanner.lib.internal.http.ScannerHttpClient;

class LegacyScannerEngineDownloader {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyScannerEngineDownloader.class);
    private final DownloadCache downloadCache;
    private final JarExtractor jarExtractor;
    private final ScannerFileDownloader scannerFileDownloader;
    private final BootstrapIndexDownloader bootstrapIndexDownloader;

    LegacyScannerEngineDownloader(ScannerFileDownloader scannerFileDownloader, BootstrapIndexDownloader bootstrapIndexDownloader, DownloadCache downloadCache, JarExtractor jarExtractor) {
        this.scannerFileDownloader = scannerFileDownloader;
        this.bootstrapIndexDownloader = bootstrapIndexDownloader;
        this.downloadCache = downloadCache;
        this.jarExtractor = jarExtractor;
    }

    List<CachedFile> getOrDownload() {
        ArrayList<CachedFile> files = new ArrayList<CachedFile>();
        LOG.debug("Extract sonar-scanner-java-library-batch in temp...");
        files.add(new CachedFile(this.jarExtractor.extractToTemp("sonar-scanner-java-library-batch"), true));
        files.addAll(this.getOrDownloadScannerEngineFiles());
        return files;
    }

    private List<CachedFile> getOrDownloadScannerEngineFiles() {
        Collection<BootstrapIndexDownloader.JarEntry> index = this.bootstrapIndexDownloader.getIndex();
        return index.stream().map(jar -> {
            try {
                return this.downloadCache.getOrDownload(jar.getFilename(), jar.getHash(), "MD5", (Downloader)this.scannerFileDownloader);
            }
            catch (HashMismatchException e) {
                throw new IllegalStateException("Unable to provision the Scanner Engine", e);
            }
        }).collect(Collectors.toList());
    }

    static class ScannerFileDownloader
    implements Downloader {
        private final ScannerHttpClient connection;

        ScannerFileDownloader(ScannerHttpClient conn) {
            this.connection = conn;
        }

        public void download(String filename, Path toFile) throws IOException {
            this.connection.downloadFromWebApi(String.format("/batch/file?name=%s", filename), toFile);
        }
    }
}

