/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.inputlocation;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import sootup.core.frontend.SootClassSource;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.model.SourceType;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;
import sootup.core.views.View;
import sootup.java.bytecode.inputlocation.PathBasedAnalysisInputLocation;
import sootup.java.core.interceptors.BytecodeBodyInterceptors;

public class OTFCompileAnalysisInputLocation
implements AnalysisInputLocation {
    private final AnalysisInputLocation inputLocation;

    public OTFCompileAnalysisInputLocation(String fileName, String compilationUnitsContent) {
        this(fileName, compilationUnitsContent, SourceType.Application, BytecodeBodyInterceptors.Default.getBodyInterceptors());
    }

    public OTFCompileAnalysisInputLocation(String fileName, String compilationUnitsContent, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        Path compile = OTFCompileAnalysisInputLocation.compile(fileName, compilationUnitsContent);
        this.inputLocation = PathBasedAnalysisInputLocation.create(compile, srcType, bodyInterceptors);
    }

    public OTFCompileAnalysisInputLocation(Path dotJavaFile) {
        this(Collections.singletonList(dotJavaFile));
    }

    public OTFCompileAnalysisInputLocation(List<Path> dotJavaFile) {
        this(dotJavaFile, SourceType.Application, BytecodeBodyInterceptors.Default.getBodyInterceptors());
    }

    public OTFCompileAnalysisInputLocation(@Nonnull List<Path> dotJavaFiles, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        Path compile = OTFCompileAnalysisInputLocation.compile(dotJavaFiles);
        this.inputLocation = PathBasedAnalysisInputLocation.create(compile, srcType, bodyInterceptors);
    }

    @Nonnull
    public Optional<? extends SootClassSource> getClassSource(@Nonnull ClassType type, @Nonnull View view) {
        return this.inputLocation.getClassSource(type, view);
    }

    @Nonnull
    public Collection<? extends SootClassSource> getClassSources(@Nonnull View view) {
        return this.inputLocation.getClassSources(view);
    }

    @Nonnull
    public SourceType getSourceType() {
        return this.inputLocation.getSourceType();
    }

    @Nonnull
    public List<BodyInterceptor> getBodyInterceptors() {
        return this.inputLocation.getBodyInterceptors();
    }

    private static Path getTempDirectory(String fileName) throws IOException {
        return Files.createTempDirectory("sootup-otfcompile-" + fileName.hashCode(), new FileAttribute[0]);
    }

    static Path compile(String fileName, String fileContent) {
        try {
            Path tmp = OTFCompileAnalysisInputLocation.getTempDirectory(fileName);
            Path path = tmp.resolve(fileName.hashCode() + "/");
            boolean dirWasCreated = path.toFile().mkdirs();
            Path srcFile = tmp.resolve(fileName);
            if (dirWasCreated) {
                Files.write(srcFile, fileContent.getBytes(), new OpenOption[0]);
            } else {
                byte[] bytes = Files.readAllBytes(srcFile);
                if (!new String(bytes).equals(fileContent)) {
                    Files.write(srcFile, fileContent.getBytes(), new OpenOption[0]);
                }
            }
            return OTFCompileAnalysisInputLocation.compile(Collections.singletonList(srcFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    static Path compile(List<Path> srcFiles) {
        StringBuilder sb = new StringBuilder();
        for (Path srcFile : srcFiles) {
            sb.append(srcFile);
        }
        String concatenatedFileNames = sb.toString();
        try {
            Path binDirpath = OTFCompileAnalysisInputLocation.getTempDirectory(concatenatedFileNames).resolve("bin/");
            File binDir = binDirpath.toFile();
            boolean binDirCreated = binDir.mkdirs();
            if (!binDirCreated) {
                FileTime binDirLastModifiedTime = Files.getLastModifiedTime(binDirpath, new LinkOption[0]);
                boolean cacheDirty = false;
                for (Path srcFile : srcFiles) {
                    if (Files.getLastModifiedTime(srcFile, new LinkOption[0]).compareTo(binDirLastModifiedTime) <= 0) continue;
                    cacheDirty = true;
                }
                if (!cacheDirty) {
                    return binDirpath;
                }
            }
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(binDir));
            File[] files = new File[srcFiles.size()];
            srcFiles.stream().map(Path::toFile).collect(Collectors.toList()).toArray(files);
            Iterable<? extends JavaFileObject> javaFileObjects = fileManager.getJavaFileObjects(files);
            try (StringWriter writer = new StringWriter();){
                JavaCompiler.CompilationTask task = compiler.getTask(writer, fileManager, null, null, null, javaFileObjects);
                if (task.call().booleanValue()) {
                    if (!binDirCreated) {
                        Files.setLastModifiedTime(binDirpath, FileTime.fromMillis(System.currentTimeMillis()));
                    }
                    Path path = binDir.toPath();
                    return path;
                }
                throw new IllegalArgumentException("Could not compile the given input.\n " + writer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

