/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.sourcecode.inputlocation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sootup.core.frontend.ResolveException;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.model.SourceType;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;
import sootup.core.views.View;
import sootup.java.core.JavaSootClassSource;
import sootup.java.sourcecode.frontend.WalaJavaClassProvider;

public class JavaSourcePathAnalysisInputLocation
implements AnalysisInputLocation {
    private static final Logger log = LoggerFactory.getLogger(JavaSourcePathAnalysisInputLocation.class);
    @Nonnull
    private final Set<String> sourcePaths;
    @Nonnull
    private final WalaJavaClassProvider classProvider;
    @Nullable
    private final String exclusionFilePath;
    private SourceType srcType = null;
    @Nonnull
    private final List<BodyInterceptor> bodyInterceptors;

    public JavaSourcePathAnalysisInputLocation(@Nonnull Set<String> sourcePaths) {
        this(sourcePaths, null);
    }

    public JavaSourcePathAnalysisInputLocation(@Nonnull String sourcePath) {
        this(Collections.singleton(sourcePath), null);
    }

    public JavaSourcePathAnalysisInputLocation(@Nonnull Set<String> sourcePaths, @Nullable String exclusionFilePath) {
        this(null, sourcePaths, exclusionFilePath, Collections.emptyList());
        Optional<String> any = sourcePaths.stream().filter(path -> !Files.exists(Paths.get(path, new String[0]), new LinkOption[0])).findAny();
        any.ifPresent(s -> {
            throw new IllegalArgumentException("The provided path " + (String)any.get() + " does not exist.");
        });
    }

    public JavaSourcePathAnalysisInputLocation(@Nullable SourceType srcType, @Nonnull Set<String> sourcePaths) {
        this(srcType, sourcePaths, null, Collections.emptyList());
    }

    public JavaSourcePathAnalysisInputLocation(@Nonnull SourceType srcType, @Nonnull String sourcePath) {
        this(srcType, Collections.singleton(sourcePath), null, Collections.emptyList());
    }

    public JavaSourcePathAnalysisInputLocation(@Nullable SourceType srcType, @Nonnull Set<String> sourcePaths, @Nullable String exclusionFilePath, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        this.sourcePaths = sourcePaths;
        this.exclusionFilePath = exclusionFilePath;
        this.classProvider = new WalaJavaClassProvider(sourcePaths, exclusionFilePath);
        this.bodyInterceptors = bodyInterceptors;
        this.setSpecifiedAsBuiltInByUser(srcType);
    }

    public void setSpecifiedAsBuiltInByUser(@Nullable SourceType srcType) {
        this.srcType = srcType;
    }

    @Nonnull
    public SourceType getSourceType() {
        return this.srcType;
    }

    @Nonnull
    public List<BodyInterceptor> getBodyInterceptors() {
        return this.bodyInterceptors;
    }

    @Nonnull
    public Collection<JavaSootClassSource> getClassSources(@Nonnull View view) {
        return this.classProvider.getClassSources(this.srcType);
    }

    @Nonnull
    public Optional<JavaSootClassSource> getClassSource(@Nonnull ClassType type, @Nonnull View view) {
        for (String path : this.sourcePaths) {
            try {
                return this.classProvider.createClassSource(this, Paths.get(path, new String[0]), type);
            }
            catch (ResolveException e) {
                log.debug(type + " not found in sourcePath " + path, (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public String getExclusionFilePath() {
        return this.exclusionFilePath;
    }

    public int hashCode() {
        return Objects.hash(this.sourcePaths, this.exclusionFilePath);
    }

    public boolean equals(Object o) {
        if (!(o instanceof JavaSourcePathAnalysisInputLocation)) {
            return false;
        }
        return this.sourcePaths.equals(((JavaSourcePathAnalysisInputLocation)o).sourcePaths) && this.exclusionFilePath.equals(((JavaSourcePathAnalysisInputLocation)o).exclusionFilePath);
    }
}

