/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class ConstantVectorExpression
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int outputColumn;
    protected long longValue = 0L;
    private double doubleValue = 0.0;
    private byte[] bytesValue = null;
    private HiveDecimal decimalValue = null;
    private boolean isNullValue = false;
    private Type type;
    private int bytesValueLength = 0;

    public ConstantVectorExpression() {
    }

    ConstantVectorExpression(int outputColumn, String typeString) {
        this();
        this.outputColumn = outputColumn;
        this.setTypeString(typeString);
    }

    public ConstantVectorExpression(int outputColumn, long value) {
        this(outputColumn, "long");
        this.longValue = value;
    }

    public ConstantVectorExpression(int outputColumn, double value) {
        this(outputColumn, "double");
        this.doubleValue = value;
    }

    public ConstantVectorExpression(int outputColumn, byte[] value) {
        this(outputColumn, "string");
        this.setBytesValue(value);
    }

    public ConstantVectorExpression(int outputColumn, HiveChar value) {
        this(outputColumn, "char");
        this.setBytesValue(value.getStrippedValue().getBytes());
    }

    public ConstantVectorExpression(int outputColumn, HiveVarchar value) {
        this(outputColumn, "varchar");
        this.setBytesValue(value.getValue().getBytes());
    }

    public ConstantVectorExpression(int outputColumn, HiveDecimal value) {
        this(outputColumn, "decimal");
        this.setDecimalValue(value);
    }

    public ConstantVectorExpression(int outputColumn, String typeString, boolean isNull) {
        this(outputColumn, typeString);
        this.isNullValue = isNull;
    }

    private void evaluateLong(VectorizedRowBatch vrg) {
        LongColumnVector cv = (LongColumnVector)vrg.cols[this.outputColumn];
        cv.isRepeating = true;
        boolean bl = cv.noNulls = !this.isNullValue;
        if (!this.isNullValue) {
            cv.vector[0] = this.longValue;
        } else {
            cv.isNull[0] = true;
        }
    }

    private void evaluateDouble(VectorizedRowBatch vrg) {
        DoubleColumnVector cv = (DoubleColumnVector)vrg.cols[this.outputColumn];
        cv.isRepeating = true;
        boolean bl = cv.noNulls = !this.isNullValue;
        if (!this.isNullValue) {
            cv.vector[0] = this.doubleValue;
        } else {
            cv.isNull[0] = true;
        }
    }

    private void evaluateBytes(VectorizedRowBatch vrg) {
        BytesColumnVector cv = (BytesColumnVector)vrg.cols[this.outputColumn];
        cv.isRepeating = true;
        cv.noNulls = !this.isNullValue;
        cv.initBuffer();
        if (!this.isNullValue) {
            cv.setVal(0, this.bytesValue, 0, this.bytesValueLength);
        } else {
            cv.isNull[0] = true;
        }
    }

    private void evaluateDecimal(VectorizedRowBatch vrg) {
        DecimalColumnVector dcv = (DecimalColumnVector)vrg.cols[this.outputColumn];
        dcv.isRepeating = true;
        boolean bl = dcv.noNulls = !this.isNullValue;
        if (!this.isNullValue) {
            dcv.vector[0].set(this.decimalValue);
        } else {
            dcv.isNull[0] = true;
        }
    }

    @Override
    public void evaluate(VectorizedRowBatch vrg) {
        switch (this.type) {
            case LONG: {
                this.evaluateLong(vrg);
                break;
            }
            case DOUBLE: {
                this.evaluateDouble(vrg);
                break;
            }
            case BYTES: {
                this.evaluateBytes(vrg);
                break;
            }
            case DECIMAL: {
                this.evaluateDecimal(vrg);
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public byte[] getBytesValue() {
        return this.bytesValue;
    }

    public void setBytesValue(byte[] bytesValue) {
        this.bytesValue = (byte[])bytesValue.clone();
        this.bytesValueLength = bytesValue.length;
    }

    public void setDecimalValue(HiveDecimal decimalValue) {
        this.decimalValue = decimalValue;
    }

    public String getTypeString() {
        return this.getOutputType();
    }

    public void setTypeString(String typeString) {
        this.outputType = typeString;
        this.type = VectorizationContext.isStringFamily(typeString) ? Type.BYTES : (VectorizationContext.isFloatFamily(typeString) ? Type.DOUBLE : (VectorizationContext.isDecimalFamily(typeString) ? Type.DECIMAL : Type.LONG));
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public void setOutputType(String type) {
        this.setTypeString(type);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().build();
    }

    private static enum Type {
        LONG,
        DOUBLE,
        BYTES,
        DECIMAL;

    }
}

