/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pickle;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import net.razorvine.pickle.PickleException;

public abstract class PickleUtils {
    public static String readline(InputStream inputStream) throws IOException {
        return PickleUtils.readline(inputStream, false);
    }

    public static String readline(InputStream inputStream, boolean bl) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        do {
            if ((n = inputStream.read()) == -1) {
                if (stringBuilder.length() == 0) {
                    throw new IOException("premature end of file");
                }
                break;
            }
            if (n == 10 && !bl) continue;
            stringBuilder.append((char)n);
        } while (n != 10);
        return stringBuilder.toString();
    }

    public static short readbyte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        return (short)n;
    }

    public static byte[] readbytes(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        PickleUtils.readbytes_into(inputStream, byArray, 0, n);
        return byArray;
    }

    public static void readbytes_into(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                throw new IOException("expected more bytes in input stream");
            }
            n += n3;
            n2 -= n3;
        }
    }

    public static int bytes_to_integer(byte[] byArray) {
        return PickleUtils.bytes_to_integer(byArray, 0, byArray.length);
    }

    public static int bytes_to_integer(byte[] byArray, int n, int n2) {
        if (n2 == 2) {
            int n3 = byArray[1 + n] & 0xFF;
            n3 <<= 8;
            return n3 |= byArray[0 + n] & 0xFF;
        }
        if (n2 == 4) {
            int n4 = byArray[3 + n];
            n4 <<= 8;
            n4 |= byArray[2 + n] & 0xFF;
            n4 <<= 8;
            n4 |= byArray[1 + n] & 0xFF;
            n4 <<= 8;
            return n4 |= byArray[0 + n] & 0xFF;
        }
        throw new PickleException("invalid amount of bytes to convert to int: " + n2);
    }

    public static long bytes_to_long(byte[] byArray, int n) {
        if (byArray.length - n < 8) {
            throw new PickleException("too few bytes to convert to long");
        }
        long l = byArray[7 + n] & 0xFF;
        l <<= 8;
        l |= (long)(byArray[6 + n] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[5 + n] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[4 + n] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[3 + n] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[2 + n] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[1 + n] & 0xFF);
        l <<= 8;
        return l |= (long)(byArray[n] & 0xFF);
    }

    public static long bytes_to_uint(byte[] byArray, int n) {
        if (byArray.length - n < 4) {
            throw new PickleException("too few bytes to convert to long");
        }
        long l = byArray[3 + n] & 0xFF;
        l <<= 8;
        l |= (long)(byArray[2 + n] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[1 + n] & 0xFF);
        l <<= 8;
        return l |= (long)(byArray[0 + n] & 0xFF);
    }

    public static byte[] integer_to_bytes(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)((n >>= 8) & 0xFF), (byte)((n >>= 8) & 0xFF), (byte)((n >>= 8) & 0xFF)};
        return byArray;
    }

    public static byte[] double_to_bytes(double d) {
        long l = Double.doubleToRawLongBits(d);
        byte[] byArray = new byte[8];
        byArray[7] = (byte)(l & 0xFFL);
        byArray[6] = (byte)((l >>= 8) & 0xFFL);
        byArray[5] = (byte)((l >>= 8) & 0xFFL);
        byArray[4] = (byte)((l >>= 8) & 0xFFL);
        byArray[3] = (byte)((l >>= 8) & 0xFFL);
        byArray[2] = (byte)((l >>= 8) & 0xFFL);
        byArray[1] = (byte)((l >>= 8) & 0xFFL);
        byArray[0] = (byte)((l >>= 8) & 0xFFL);
        return byArray;
    }

    public static double bytes_to_double(byte[] byArray, int n) {
        try {
            long l = byArray[0 + n] & 0xFF;
            l <<= 8;
            l |= (long)(byArray[1 + n] & 0xFF);
            l <<= 8;
            l |= (long)(byArray[2 + n] & 0xFF);
            l <<= 8;
            l |= (long)(byArray[3 + n] & 0xFF);
            l <<= 8;
            l |= (long)(byArray[4 + n] & 0xFF);
            l <<= 8;
            l |= (long)(byArray[5 + n] & 0xFF);
            l <<= 8;
            l |= (long)(byArray[6 + n] & 0xFF);
            l <<= 8;
            return Double.longBitsToDouble(l |= (long)(byArray[7 + n] & 0xFF));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new PickleException("decoding double: too few bytes");
        }
    }

    public static float bytes_to_float(byte[] byArray, int n) {
        try {
            int n2 = byArray[0 + n] & 0xFF;
            n2 <<= 8;
            n2 |= byArray[1 + n] & 0xFF;
            n2 <<= 8;
            n2 |= byArray[2 + n] & 0xFF;
            n2 <<= 8;
            return Float.intBitsToFloat(n2 |= byArray[3 + n] & 0xFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new PickleException("decoding float: too few bytes");
        }
    }

    public static Number decode_long(byte[] byArray) {
        if (byArray.length == 0) {
            return 0L;
        }
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[byArray.length - i - 1] = byArray[i];
        }
        BigInteger bigInteger = new BigInteger(byArray2);
        return PickleUtils.optimizeBigint(bigInteger);
    }

    public static byte[] encode_long(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[byArray.length - i - 1] = byArray[i];
        }
        return byArray2;
    }

    public static Number optimizeBigint(BigInteger bigInteger) {
        BigInteger bigInteger2 = BigInteger.valueOf(Long.MAX_VALUE);
        BigInteger bigInteger3 = BigInteger.valueOf(Long.MIN_VALUE);
        switch (bigInteger.signum()) {
            case 0: {
                return 0L;
            }
            case 1: {
                if (bigInteger.compareTo(bigInteger2) > 0) break;
                return bigInteger.longValue();
            }
            case -1: {
                if (bigInteger.compareTo(bigInteger3) < 0) break;
                return bigInteger.longValue();
            }
        }
        return bigInteger;
    }

    public static String rawStringFromBytes(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length);
        for (byte by : byArray) {
            stringBuilder.append((char)(by & 0xFF));
        }
        return stringBuilder.toString();
    }

    public static byte[] str2bytes(String string) throws IOException {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u00ff') {
                throw new UnsupportedEncodingException("string contained a char > 255, cannot convert to bytes");
            }
            byArray[i] = (byte)c;
        }
        return byArray;
    }

    public static String decode_escaped(String string) {
        if (string.indexOf(92) == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                char c2 = string.charAt(++i);
                switch (c2) {
                    case '\\': {
                        stringBuilder.append(c);
                        break;
                    }
                    case 'x': {
                        char c3 = string.charAt(++i);
                        char c4 = string.charAt(++i);
                        c2 = (char)Integer.parseInt("" + c3 + c4, 16);
                        stringBuilder.append(c2);
                        break;
                    }
                    default: {
                        throw new PickleException("invalid escape sequence in string");
                    }
                }
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    public static String decode_unicode_escaped(String string) {
        if (string.indexOf(92) == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                char c2 = string.charAt(++i);
                switch (c2) {
                    case '\\': {
                        stringBuilder.append(c);
                        break;
                    }
                    case 'u': {
                        char c3 = string.charAt(++i);
                        char c4 = string.charAt(++i);
                        char c5 = string.charAt(++i);
                        char c6 = string.charAt(++i);
                        c2 = (char)Integer.parseInt("" + c3 + c4 + c5 + c6, 16);
                        stringBuilder.append(c2);
                        break;
                    }
                    default: {
                        throw new PickleException("invalid escape sequence in string");
                    }
                }
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }
}

