/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pickle.objects;

import java.util.Calendar;
import java.util.GregorianCalendar;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.PickleException;
import net.razorvine.pickle.objects.Time;
import net.razorvine.pickle.objects.TimeDelta;

public class DateTimeConstructor
implements IObjectConstructor {
    public static int DATETIME = 1;
    public static int DATE = 2;
    public static int TIME = 3;
    public static int TIMEDELTA = 4;
    private int pythontype;

    public DateTimeConstructor(int n) {
        this.pythontype = n;
    }

    @Override
    public Object construct(Object[] objectArray) {
        if (this.pythontype == DATE) {
            return this.createDate(objectArray);
        }
        if (this.pythontype == TIME) {
            return this.createTime(objectArray);
        }
        if (this.pythontype == DATETIME) {
            return this.createDateTime(objectArray);
        }
        if (this.pythontype == TIMEDELTA) {
            return this.createTimedelta(objectArray);
        }
        throw new PickleException("invalid object type");
    }

    private TimeDelta createTimedelta(Object[] objectArray) {
        if (objectArray.length != 3) {
            throw new PickleException("invalid pickle data for timedelta; expected 3 args, got " + objectArray.length);
        }
        int n = ((Number)objectArray[0]).intValue();
        int n2 = ((Number)objectArray[1]).intValue();
        int n3 = ((Number)objectArray[2]).intValue();
        return new TimeDelta(n, n2, n3);
    }

    private Calendar createDateTime(Object[] objectArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Object object;
        if (objectArray.length == 7) {
            int n9 = (Integer)objectArray[0];
            int n10 = (Integer)objectArray[1] - 1;
            int n11 = (Integer)objectArray[2];
            int n12 = (Integer)objectArray[3];
            int n13 = (Integer)objectArray[4];
            int n14 = (Integer)objectArray[5];
            int n15 = (Integer)objectArray[6];
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n9, n10, n11, n12, n13, n14);
            gregorianCalendar.set(14, n15 / 1000);
            return gregorianCalendar;
        }
        if (objectArray.length != 1) {
            throw new PickleException("invalid pickle data for datetime; expected 1 or 7 args, got " + objectArray.length);
        }
        if (objectArray[0] instanceof String) {
            object = (String)objectArray[0];
            if (((String)object).length() != 10) {
                throw new PickleException("invalid pickle data for datetime; expected arg of length 10, got length " + ((String)object).length());
            }
            n8 = ((String)object).charAt(0);
            n7 = ((String)object).charAt(1);
            n6 = ((String)object).charAt(2) - '\u0001';
            n5 = ((String)object).charAt(3);
            n4 = ((String)object).charAt(4);
            n3 = ((String)object).charAt(5);
            n2 = ((String)object).charAt(6);
            char c = ((String)object).charAt(7);
            char c2 = ((String)object).charAt(8);
            char c3 = ((String)object).charAt(9);
            n = (c << 8 | c2) << 8 | c3;
        } else {
            object = (byte[])objectArray[0];
            if (((Object)object).length != 10) {
                throw new PickleException("invalid pickle data for datetime; expected arg of length 10, got length " + ((Object)object).length);
            }
            n8 = object[0] & 0xFF;
            n7 = object[1] & 0xFF;
            n6 = (object[2] & 0xFF) - 1;
            n5 = object[3] & 0xFF;
            n4 = object[4] & 0xFF;
            n3 = object[5] & 0xFF;
            n2 = object[6] & 0xFF;
            int n16 = object[7] & 0xFF;
            int n17 = object[8] & 0xFF;
            int n18 = object[9] & 0xFF;
            n = (n16 << 8 | n17) << 8 | n18;
        }
        object = new GregorianCalendar(n8 * 256 + n7, n6, n5, n4, n3, n2);
        ((Calendar)object).set(14, n / 1000);
        return object;
    }

    private Time createTime(Object[] objectArray) {
        int n;
        int n2;
        int n3;
        int n4;
        if (objectArray.length == 4) {
            int n5 = (Integer)objectArray[0];
            int n6 = (Integer)objectArray[1];
            int n7 = (Integer)objectArray[2];
            int n8 = (Integer)objectArray[3];
            return new Time(n5, n6, n7, n8);
        }
        if (objectArray.length != 1) {
            throw new PickleException("invalid pickle data for time; expected 1 or 4 args, got " + objectArray.length);
        }
        if (objectArray[0] instanceof String) {
            String string = (String)objectArray[0];
            if (string.length() != 6) {
                throw new PickleException("invalid pickle data for time; expected arg of length 6, got length " + string.length());
            }
            n4 = string.charAt(0);
            n3 = string.charAt(1);
            n2 = string.charAt(2);
            char c = string.charAt(3);
            char c2 = string.charAt(4);
            char c3 = string.charAt(5);
            n = (c << 8 | c2) << 8 | c3;
        } else {
            byte[] byArray = (byte[])objectArray[0];
            if (byArray.length != 6) {
                throw new PickleException("invalid pickle data for datetime; expected arg of length 6, got length " + byArray.length);
            }
            n4 = byArray[0] & 0xFF;
            n3 = byArray[1] & 0xFF;
            n2 = byArray[2] & 0xFF;
            int n9 = byArray[3] & 0xFF;
            int n10 = byArray[4] & 0xFF;
            int n11 = byArray[5] & 0xFF;
            n = (n9 << 8 | n10) << 8 | n11;
        }
        return new Time(n4, n3, n2, n);
    }

    private Calendar createDate(Object[] objectArray) {
        int n;
        int n2;
        int n3;
        int n4;
        if (objectArray.length != 1) {
            throw new PickleException("invalid pickle data for date; expected 1 arg, got " + objectArray.length);
        }
        if (objectArray[0] instanceof String) {
            String string = (String)objectArray[0];
            if (string.length() != 4) {
                throw new PickleException("invalid pickle data for date; expected arg of length 4, got length " + string.length());
            }
            n4 = string.charAt(0);
            n3 = string.charAt(1);
            n2 = string.charAt(2) - '\u0001';
            n = string.charAt(3);
        } else {
            byte[] byArray = (byte[])objectArray[0];
            if (byArray.length != 4) {
                throw new PickleException("invalid pickle data for date; expected arg of length 4, got length " + byArray.length);
            }
            n4 = byArray[0] & 0xFF;
            n3 = byArray[1] & 0xFF;
            n2 = (byArray[2] & 0xFF) - 1;
            n = byArray[3] & 0xFF;
        }
        return new GregorianCalendar(n4 * 256 + n3, n2, n);
    }
}

