/*
 * Decompiled with CFR 0.152.
 */
package org.spdx;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Configuration {
    private static final Logger logger = LoggerFactory.getLogger((String)Configuration.class.getName());
    private static final String PROPERTIES_DIR = "resources";
    private static final String CONFIGURATION_PROPERTIES_FILENAME = "resources/spdx-java-library.properties";
    private static final String DEPRECATED_CONFIGURATION_PROPERTIES_FILENAME = "resources/licenses.properties";
    private static Configuration singleton;
    private final Properties properties;

    private Configuration() {
        Properties tmpProperties = Configuration.loadProperties(CONFIGURATION_PROPERTIES_FILENAME);
        if (tmpProperties == null && (tmpProperties = Configuration.loadProperties(DEPRECATED_CONFIGURATION_PROPERTIES_FILENAME)) != null) {
            logger.warn("You are using a deprecated configuration properties filename ('resources/licenses.properties'). Please consider migrating to the new name ('resources/spdx-java-library.properties').");
        }
        this.properties = tmpProperties;
    }

    public static Configuration getInstance() {
        if (singleton == null) {
            singleton = new Configuration();
        }
        return singleton;
    }

    public String getProperty(String propertyName) {
        return this.getProperty(propertyName, null);
    }

    public String getProperty(String propertyName, String defaultValue) {
        return System.getProperty(propertyName, this.properties == null ? defaultValue : this.properties.getProperty(propertyName, defaultValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties loadProperties(String propertiesFileName) {
        Properties result = null;
        if (propertiesFileName == null) return result;
        InputStream in = null;
        in = Configuration.class.getResourceAsStream("/" + propertiesFileName);
        if (in != null) {
            result = new Properties();
            result.load(in);
        }
        if (in == null) return result;
        try {
            in.close();
            return result;
        }
        catch (IOException e) {
            logger.warn("Unable to close configuration properties file '{}': {}", new Object[]{propertiesFileName, e.getMessage(), e});
        }
        return result;
        catch (IOException e) {
            try {
                logger.warn("IO Exception reading configuration properties file '{}': {}", new Object[]{propertiesFileName, e.getMessage(), e});
                result = null;
                if (in == null) return result;
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    logger.warn("Unable to close configuration properties file '{}': {}", new Object[]{propertiesFileName, e2.getMessage(), e2});
                }
                throw throwable;
            }
            try {
                in.close();
                return result;
            }
            catch (IOException e3) {
                logger.warn("Unable to close configuration properties file '{}': {}", new Object[]{propertiesFileName, e3.getMessage(), e3});
            }
            return result;
        }
    }
}

