/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.SimpleUriValue;
import org.spdx.core.TypedValue;
import org.spdx.library.conversion.ISpdxConverter;
import org.spdx.library.conversion.Spdx2to3Converter;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.PropertyDescriptor;

public class ModelCopyManager
implements IModelCopyManager {
    static final Logger logger = LoggerFactory.getLogger(ModelCopyManager.class);
    private final ConcurrentHashMap<IModelStore, ConcurrentHashMap<IModelStore, ConcurrentHashMap<String, String>>> copiedIds = new ConcurrentHashMap();
    private final ConcurrentHashMap<IModelStore, ConcurrentHashMap<IModelStore, ConcurrentHashMap<SpdxConstantsV3.SpdxMajorVersion, ConcurrentHashMap<SpdxConstantsV3.SpdxMajorVersion, ISpdxConverter>>>> spdxConverters = new ConcurrentHashMap();

    public boolean versionsCompatible(String fromSpecVersion, String toSpecVersion) {
        Objects.requireNonNull(fromSpecVersion);
        Objects.requireNonNull(toSpecVersion);
        return fromSpecVersion.startsWith("SPDX-2") && toSpecVersion.startsWith("SPDX-2") || fromSpecVersion.startsWith("3.0.") && toSpecVersion.startsWith("3.0.");
    }

    public boolean canConvert(String fromSpecVersion, String toSpecVersion) {
        Objects.requireNonNull(fromSpecVersion);
        Objects.requireNonNull(toSpecVersion);
        return fromSpecVersion.startsWith("SPDX-2") && toSpecVersion.startsWith("3.0.");
    }

    @Nullable
    public String getCopiedObjectUri(IModelStore fromStore, String fromObjectUri, IModelStore toStore) {
        ConcurrentHashMap<IModelStore, ConcurrentHashMap<String, String>> fromStoreMap = this.copiedIds.get(fromStore);
        if (Objects.isNull(fromStoreMap)) {
            return null;
        }
        ConcurrentHashMap<String, String> toStoreMap = fromStoreMap.get(toStore);
        if (Objects.isNull(toStoreMap)) {
            return null;
        }
        return toStoreMap.get(fromObjectUri);
    }

    @Nullable
    public ISpdxConverter getSpecConverter(IModelStore fromStore, IModelStore toStore, String fromSpecVersion, String toSpecVersion, boolean create) throws InvalidSPDXAnalysisException {
        ISpdxConverter retval;
        ConcurrentHashMap<Object, ISpdxConverter> toVersionMap;
        ConcurrentHashMap<Object, ConcurrentHashMap<Object, ISpdxConverter>> fromVersionMap;
        SpdxConstantsV3.SpdxMajorVersion toMajorVersion;
        SpdxConstantsV3.SpdxMajorVersion fromMajorVersion;
        Objects.requireNonNull(fromStore, "From store can not be null");
        Objects.requireNonNull(toStore, "To store can not be null");
        Objects.requireNonNull(fromSpecVersion, "From spec version can not be null");
        Objects.requireNonNull(toSpecVersion, "To spec version can not be null");
        if (fromSpecVersion.startsWith("SPDX-2")) {
            fromMajorVersion = SpdxConstantsV3.SpdxMajorVersion.VERSION_2;
        } else if (fromSpecVersion.startsWith("3.")) {
            fromMajorVersion = SpdxConstantsV3.SpdxMajorVersion.VERSION_3;
        } else {
            throw new InvalidSPDXAnalysisException("Invalid from spec version: " + fromSpecVersion);
        }
        if (toSpecVersion.startsWith("SPDX-2")) {
            toMajorVersion = SpdxConstantsV3.SpdxMajorVersion.VERSION_2;
        } else if (toSpecVersion.startsWith("3.")) {
            toMajorVersion = SpdxConstantsV3.SpdxMajorVersion.VERSION_3;
        } else {
            throw new InvalidSPDXAnalysisException("Invalid from spec version: " + fromSpecVersion);
        }
        ConcurrentHashMap<Object, ConcurrentHashMap<Object, ConcurrentHashMap<Object, ISpdxConverter>>> modelStoreMap = this.spdxConverters.get(fromStore);
        if (Objects.isNull(modelStoreMap)) {
            if (!create) {
                return null;
            }
            modelStoreMap = new ConcurrentHashMap();
            ConcurrentHashMap<IModelStore, ConcurrentHashMap<SpdxConstantsV3.SpdxMajorVersion, ConcurrentHashMap<SpdxConstantsV3.SpdxMajorVersion, ISpdxConverter>>> previousMap = this.spdxConverters.putIfAbsent(fromStore, modelStoreMap);
            if (Objects.nonNull(previousMap)) {
                modelStoreMap = previousMap;
            }
        }
        if (Objects.isNull(fromVersionMap = modelStoreMap.get(toStore))) {
            if (!create) {
                return null;
            }
            fromVersionMap = new ConcurrentHashMap();
            ConcurrentHashMap<SpdxConstantsV3.SpdxMajorVersion, ConcurrentHashMap<SpdxConstantsV3.SpdxMajorVersion, ISpdxConverter>> previousMap = modelStoreMap.put(toStore, fromVersionMap);
            if (Objects.nonNull(previousMap)) {
                fromVersionMap = previousMap;
            }
        }
        if (Objects.isNull(toVersionMap = fromVersionMap.get(fromMajorVersion))) {
            if (!create) {
                return null;
            }
            toVersionMap = new ConcurrentHashMap();
            ConcurrentHashMap<SpdxConstantsV3.SpdxMajorVersion, ISpdxConverter> previous = fromVersionMap.put(fromMajorVersion, toVersionMap);
            if (Objects.nonNull(previous)) {
                toVersionMap = previous;
            }
        }
        if (Objects.isNull(retval = toVersionMap.get(toMajorVersion))) {
            if (!create) {
                return null;
            }
            if (SpdxConstantsV3.SpdxMajorVersion.VERSION_2.equals((Object)fromMajorVersion) && SpdxConstantsV3.SpdxMajorVersion.VERSION_3.equals((Object)toMajorVersion)) {
                retval = new Spdx2to3Converter(toStore, this, null, toSpecVersion, null, true);
                ISpdxConverter previous = toVersionMap.putIfAbsent(toMajorVersion, retval);
                if (Objects.nonNull(previous)) {
                    retval = previous;
                }
                throw new InvalidSPDXAnalysisException("Not completely implemented - need to add creation info");
            }
            throw new InvalidSPDXAnalysisException("No SPDX conversion code is available from spec version " + fromSpecVersion + " to " + toSpecVersion);
        }
        return retval;
    }

    public String putCopiedId(IModelStore fromStore, String fromObjectUri, IModelStore toStore, String toObjectUri) {
        ConcurrentHashMap<Object, ConcurrentHashMap<String, String>> fromStoreMap = this.copiedIds.get(fromStore);
        while (Objects.isNull(fromStoreMap)) {
            fromStoreMap = this.copiedIds.putIfAbsent(fromStore, new ConcurrentHashMap());
        }
        ConcurrentHashMap<String, String> toStoreMap = fromStoreMap.get(toStore);
        while (Objects.isNull(toStoreMap)) {
            toStoreMap = fromStoreMap.putIfAbsent(toStore, new ConcurrentHashMap());
        }
        if (toStoreMap.containsKey(fromObjectUri)) {
            logger.warn("Object URI already exists for the originating {}", (Object)fromObjectUri);
        }
        return toStoreMap.put(fromObjectUri, toObjectUri);
    }

    public void copy(IModelStore toStore, String toObjectUri, IModelStore fromStore, String fromObjectUri, String toSpecVersion, @Nullable String toNamespace) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(toStore, "ToStore can not be null");
        Objects.requireNonNull(toObjectUri, "To Object URI can not be null");
        Objects.requireNonNull(fromStore, "FromStore can not be null");
        Objects.requireNonNull(fromObjectUri, "From ObjectUri can not be null");
        Objects.requireNonNull(toSpecVersion, "To spec version can not be null");
        if (fromStore.equals((Object)toStore) && fromObjectUri.equals(toObjectUri)) {
            return;
        }
        Optional fromTv = fromStore.getTypedValue(fromObjectUri);
        if (!fromTv.isPresent()) {
            throw new InvalidSPDXAnalysisException("Missing from object URI " + fromObjectUri);
        }
        if (this.versionsCompatible(((TypedValue)fromTv.get()).getSpecVersion(), toSpecVersion)) {
            this.copyCompatible(toStore, toObjectUri, fromStore, (TypedValue)fromTv.get(), toSpecVersion, toNamespace);
        } else if (this.canConvert(((TypedValue)fromTv.get()).getSpecVersion(), toSpecVersion)) {
            this.copyConverted(toStore, toObjectUri, fromStore, (TypedValue)fromTv.get(), toSpecVersion, toNamespace);
        } else {
            throw new InvalidSPDXAnalysisException("Incompatible versions - can not convert from " + ((TypedValue)fromTv.get()).getSpecVersion() + " to version " + toSpecVersion);
        }
    }

    private void copyConverted(IModelStore toStore, String toObjectUri, IModelStore fromStore, TypedValue fromTv, String toSpecVersion, @Nullable String toNamespace) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Unimplemented");
    }

    private void copyCompatible(IModelStore toStore, String toObjectUri, IModelStore fromStore, TypedValue fromTv, String toSpecVersion, @Nullable String toNamespace) throws InvalidSPDXAnalysisException {
        if (!toStore.exists(toObjectUri)) {
            toStore.create(new TypedValue(toObjectUri, fromTv.getType(), toSpecVersion));
        }
        this.putCopiedId(fromStore, fromTv.getObjectUri(), toStore, toObjectUri);
        List propertyDescriptors = fromStore.getPropertyValueDescriptors(fromTv.getObjectUri());
        for (PropertyDescriptor propDesc : propertyDescriptors) {
            if (fromStore.isCollectionProperty(fromTv.getObjectUri(), propDesc)) {
                this.copyCollectionProperty(toStore, toObjectUri, fromStore, fromTv.getObjectUri(), propDesc, toSpecVersion, toNamespace);
                continue;
            }
            this.copyIndividualProperty(toStore, toObjectUri, fromStore, fromTv.getObjectUri(), propDesc, toSpecVersion, toNamespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyIndividualProperty(IModelStore toStore, String toObjectUri, IModelStore fromStore, String fromObjectUri, PropertyDescriptor propDescriptor, String toSpecVersion, @Nullable String toNamespace) throws InvalidSPDXAnalysisException {
        Optional result;
        IModelStore.IModelStoreLock fromStoreLock = fromStore.enterCriticalSection(false);
        try {
            if (fromStore.isCollectionProperty(fromObjectUri, propDescriptor)) {
                throw new InvalidSPDXAnalysisException("Property " + propDescriptor + " is a collection type");
            }
            result = fromStore.getValue(fromObjectUri, propDescriptor);
        }
        finally {
            fromStoreLock.unlock();
        }
        if (result.isPresent()) {
            if (result.get() instanceof IndividualUriValue) {
                toStore.setValue(toObjectUri, propDescriptor, (Object)new SimpleUriValue((IndividualUriValue)result.get()));
            } else if (result.get() instanceof TypedValue) {
                TypedValue tv = (TypedValue)result.get();
                if (fromStore.equals((Object)toStore)) {
                    toStore.setValue(toObjectUri, propDescriptor, (Object)tv);
                } else {
                    toStore.setValue(toObjectUri, propDescriptor, (Object)this.copy(toStore, fromStore, tv.getObjectUri(), toSpecVersion, toNamespace));
                }
            } else {
                toStore.setValue(toObjectUri, propDescriptor, result.get());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCollectionProperty(IModelStore toStore, String toObjectUri, IModelStore fromStore, String fromObjectUri, PropertyDescriptor propDescriptor, String toSpecVersion, @Nullable String toNamespace) throws InvalidSPDXAnalysisException {
        Iterator fromListIter;
        IModelStore.IModelStoreLock fromStoreLock = fromStore.enterCriticalSection(false);
        try {
            if (!fromStore.isCollectionProperty(fromObjectUri, propDescriptor)) {
                throw new InvalidSPDXAnalysisException("Property " + propDescriptor + " is not a collection type");
            }
            fromListIter = fromStore.listValues(fromObjectUri, propDescriptor);
        }
        finally {
            fromStoreLock.unlock();
        }
        while (fromListIter.hasNext()) {
            Object toStoreItem;
            Object listItem = fromListIter.next();
            if (listItem instanceof IndividualUriValue) {
                toStoreItem = new SimpleUriValue((IndividualUriValue)listItem);
            } else if (listItem instanceof TypedValue) {
                TypedValue listItemTv = (TypedValue)listItem;
                toStoreItem = toStore.equals((Object)fromStore) ? listItemTv : this.copy(toStore, fromStore, listItemTv.getObjectUri(), toSpecVersion, toNamespace);
            } else {
                toStoreItem = listItem;
            }
            toStore.addValueToCollection(toObjectUri, propDescriptor, toStoreItem);
        }
    }

    public TypedValue copy(IModelStore toStore, IModelStore fromStore, String sourceUri, String toSpecVersion, @Nullable String toNamespace) throws InvalidSPDXAnalysisException {
        Optional retval;
        Objects.requireNonNull(toStore, "To Store can not be null");
        Objects.requireNonNull(fromStore, "From Store can not be null");
        Objects.requireNonNull(sourceUri, "Source URI can not be null");
        Objects.requireNonNull(toSpecVersion, "To specVersion can not be null");
        String toObjectUri = this.getCopiedObjectUri(fromStore, sourceUri, toStore);
        if (Objects.isNull(toObjectUri)) {
            Optional fromTv = fromStore.getTypedValue(sourceUri);
            if (!fromTv.isPresent()) {
                throw new InvalidSPDXAnalysisException(sourceUri + " does not exist in the from Store");
            }
            toObjectUri = toSpecVersion.startsWith("SPDX-2") ? this.sourceUriToObjectUriV2Compat(sourceUri, fromStore.getIdType(sourceUri), toStore, toNamespace, "ExternalDocumentRef".equals(((TypedValue)fromTv.get()).getType())) : this.sourceUriToObjectUri(sourceUri, fromStore.getIdType(sourceUri), toStore, toNamespace);
            this.copy(toStore, toObjectUri, fromStore, sourceUri, toSpecVersion, toNamespace);
        }
        if ((retval = toStore.getTypedValue(toObjectUri)).isPresent()) {
            return (TypedValue)retval.get();
        }
        throw new InvalidSPDXAnalysisException("Unable to retrieve typed value from toStore");
    }

    private String sourceUriToObjectUri(String sourceUri, IModelStore.IdType idType, IModelStore toStore, String toNamespace) throws InvalidSPDXAnalysisException {
        if (IModelStore.IdType.Anonymous.equals((Object)idType)) {
            return toStore.getNextId(IModelStore.IdType.Anonymous);
        }
        if (!toStore.exists(sourceUri)) {
            return sourceUri;
        }
        if (Objects.isNull(toNamespace) || toNamespace.isEmpty() || sourceUri.startsWith(toNamespace)) {
            if (!sourceUri.startsWith("https://spdx.org")) {
                logger.warn("{} already exists - possibly overwriting properties due to a copy from a different model store.", (Object)sourceUri);
            }
            return sourceUri;
        }
        switch (idType) {
            case LicenseRef: {
                return toNamespace + toStore.getNextId(IModelStore.IdType.LicenseRef);
            }
            case DocumentRef: {
                return toNamespace + toStore.getNextId(IModelStore.IdType.DocumentRef);
            }
            case SpdxId: {
                return toNamespace + toStore.getNextId(IModelStore.IdType.SpdxId);
            }
            case ListedLicense: {
                return sourceUri;
            }
        }
        return toStore.getNextId(IModelStore.IdType.Anonymous);
    }

    private String sourceUriToObjectUriV2Compat(String sourceUri, IModelStore.IdType idType, IModelStore toStore, String toNamespace, boolean isExternalDocRef) throws InvalidSPDXAnalysisException {
        boolean notNullAndNotExists;
        if (!(!isExternalDocRef && (IModelStore.IdType.Anonymous.equals((Object)idType) || IModelStore.IdType.ListedLicense.equals((Object)idType) || IModelStore.IdType.Unknown.equals((Object)idType) || IModelStore.IdType.Unkown.equals((Object)idType)) || !Objects.isNull(toNamespace) && !toNamespace.isEmpty())) {
            throw new InvalidSPDXAnalysisException("A to namespace or document URI must be provided to copy SPDX element for SPDX spec version 2");
        }
        if (sourceUri.startsWith(toNamespace) && !toStore.exists(sourceUri)) {
            return sourceUri;
        }
        if (IModelStore.IdType.ListedLicense.equals((Object)idType)) {
            return sourceUri;
        }
        String toUri = null;
        int poundIndex = sourceUri.lastIndexOf(35);
        if (poundIndex > 0) {
            toUri = toNamespace + sourceUri.substring(poundIndex + 1);
        }
        boolean bl = notNullAndNotExists = Objects.nonNull(toUri) && !toStore.exists(toUri);
        if (isExternalDocRef) {
            if (!toStore.exists(toUri) && IModelStore.IdType.DocumentRef.equals((Object)toStore.getIdType(toUri))) {
                return toUri;
            }
            return toNamespace + toStore.getNextId(IModelStore.IdType.DocumentRef);
        }
        switch (idType) {
            case LicenseRef: {
                return notNullAndNotExists && IModelStore.IdType.LicenseRef.equals((Object)toStore.getIdType(toUri)) ? toUri : toNamespace + toStore.getNextId(IModelStore.IdType.LicenseRef);
            }
            case DocumentRef: {
                return notNullAndNotExists && IModelStore.IdType.DocumentRef.equals((Object)toStore.getIdType(toUri)) ? toUri : toNamespace + toStore.getNextId(IModelStore.IdType.DocumentRef);
            }
            case SpdxId: {
                return notNullAndNotExists && IModelStore.IdType.SpdxId.equals((Object)toStore.getIdType(toUri)) ? toUri : toNamespace + toStore.getNextId(IModelStore.IdType.SpdxId);
            }
            case ListedLicense: {
                return sourceUri;
            }
        }
        return toStore.getNextId(IModelStore.IdType.Anonymous);
    }
}

