/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.ISpdxModelInfo;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.ModelRegistry;
import org.spdx.core.ModelRegistryException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.v2.SpdxModelInfoV2_X;
import org.spdx.library.model.v3_0_1.SpdxModelInfoV3_0;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.InMemSpdxStore;

public class SpdxModelFactory {
    static final Logger logger = LoggerFactory.getLogger((String)SpdxModelFactory.class.getName());
    public static final String IMPLEMENTATION_VERSION = "2.0.0";
    static final String DEFAULT_DOCUMENT_URI = "https://default/spdx/document";
    private static final Object INIT_LOCK;

    private SpdxModelFactory() {
    }

    static String verifyVersion(String version) {
        if (Objects.isNull(version)) {
            return "Null version";
        }
        if (!ModelRegistry.getModelRegistry().containsSpecVersion(version)) {
            return "Spec version is not supported";
        }
        return null;
    }

    public static String getLatestSpecVersion() {
        List allVersions = ModelRegistry.getModelRegistry().getSupportedVersions();
        ArrayList<String> preVersion2Versions = new ArrayList<String>();
        ArrayList<String> post2Versions = new ArrayList<String>();
        for (String version : allVersions) {
            if (version.startsWith("SPDX-")) {
                preVersion2Versions.add(version);
                continue;
            }
            post2Versions.add(version);
        }
        if (!post2Versions.isEmpty()) {
            Collections.sort(post2Versions);
            return (String)post2Versions.get(post2Versions.size() - 1);
        }
        if (!preVersion2Versions.isEmpty()) {
            return (String)preVersion2Versions.get(preVersion2Versions.size() - 1);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        Object object = INIT_LOCK;
        synchronized (object) {
            if (!DefaultModelStore.isInitialized()) {
                DefaultModelStore.initialize((IModelStore)new InMemSpdxStore(), (String)DEFAULT_DOCUMENT_URI, (IModelCopyManager)new ModelCopyManager());
            }
        }
    }

    public static CoreModelObject inflateModelObject(IModelStore modelStore, String objectUri, String type, IModelCopyManager copyManager, String specVersion, boolean create, @Nullable String idPrefix) throws InvalidSPDXAnalysisException {
        return ModelRegistry.getModelRegistry().inflateModelObject(modelStore, objectUri, type, copyManager, specVersion, create, idPrefix);
    }

    public static CoreModelObject inflateModelObject(IModelStore modelStore, String objectUri, String type, IModelCopyManager copyManager, boolean create, @Nullable String idPrefix) throws InvalidSPDXAnalysisException {
        return SpdxModelFactory.inflateModelObject(modelStore, objectUri, type, copyManager, SpdxModelFactory.getLatestSpecVersion(), create, idPrefix);
    }

    public static Object getExternalElement(IModelStore store, String uri, @Nullable IModelCopyManager copyManager, Class<?> type, String specVersion) throws InvalidSPDXAnalysisException {
        return ModelRegistry.getModelRegistry().getExternalElement(store, uri, copyManager, type, specVersion);
    }

    public static Object getExternalElement(IModelStore store, String uri, @Nullable IModelCopyManager copyManager, Class<?> type) throws InvalidSPDXAnalysisException {
        return SpdxModelFactory.getExternalElement(store, uri, copyManager, type, SpdxModelFactory.getLatestSpecVersion());
    }

    @Nullable
    public static Enum<?> uriToEnum(String uri, String specVersion) throws ModelRegistryException {
        return ModelRegistry.getModelRegistry().uriToEnum(uri, specVersion);
    }

    @Nullable
    public static Enum<?> uriToEnum(String uri) throws ModelRegistryException {
        return SpdxModelFactory.uriToEnum(uri, SpdxModelFactory.getLatestSpecVersion());
    }

    public static Stream<?> getSpdxObjects(IModelStore store, @Nullable IModelCopyManager copyManager, @Nullable String typeFilter, @Nullable String objectUriPrefixFilter, @Nullable String idPrefix) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(store, "Store must not be null");
        return store.getAllItems(objectUriPrefixFilter, typeFilter).map(tv -> {
            try {
                return SpdxModelFactory.inflateModelObject(store, tv.getObjectUri(), tv.getType(), copyManager, tv.getSpecVersion(), false, idPrefix);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new RuntimeException(e);
            }
        });
    }

    static {
        ModelRegistry.getModelRegistry().registerModel((ISpdxModelInfo)new SpdxModelInfoV2_X());
        ModelRegistry.getModelRegistry().registerModel((ISpdxModelInfo)new SpdxModelInfoV3_0());
        INIT_LOCK = new Object();
    }
}

