/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.listedlicense;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.spdx.core.ModelRegistryException;
import org.spdx.core.SpdxInvalidIdException;
import org.spdx.core.SpdxInvalidTypeException;
import org.spdx.core.TypedValue;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.Tool;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.storage.PropertyDescriptor;
import org.spdx.storage.listedlicense.LicenseCreatorAgent;

public class LicenseCreationInfo {
    static final String CREATION_INFO_URI = "__creation_info";
    public static final List<PropertyDescriptor> ALL_PROPERTY_DESCRIPTORS;
    public static final Map<PropertyDescriptor, Object> PROPERTY_TO_STATIC_VALUE;
    private static final List<String> EMPTY;
    private final String created;
    private final List<TypedValue> creators;
    TypedValue typedValue;

    public LicenseCreationInfo(LicenseCreatorAgent licenseListCreator, String licenseListReleaseDate) throws SpdxInvalidIdException, SpdxInvalidTypeException, ModelRegistryException {
        this.created = Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", licenseListReleaseDate) ? licenseListReleaseDate : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date());
        this.creators = Collections.singletonList(licenseListCreator.getTypedValue());
        this.typedValue = new TypedValue(CREATION_INFO_URI, "Core.CreationInfo", "3.0.1");
    }

    public TypedValue getTypedValue() {
        return this.typedValue;
    }

    public boolean isCollectionProperty(PropertyDescriptor propertyDescriptor) {
        return SpdxConstantsV3.PROP_CREATED_BY.equals((Object)propertyDescriptor);
    }

    public List<?> getValueList(PropertyDescriptor propertyDescriptor) {
        if (SpdxConstantsV3.PROP_CREATED_BY.equals((Object)propertyDescriptor)) {
            return this.creators;
        }
        return EMPTY;
    }

    public Object getValue(PropertyDescriptor propertyDescriptor) {
        if (SpdxConstantsV3.PROP_CREATED_BY.equals((Object)propertyDescriptor)) {
            return this.creators;
        }
        if (SpdxConstantsV3.PROP_CREATED.equals((Object)propertyDescriptor)) {
            return this.created;
        }
        return PROPERTY_TO_STATIC_VALUE.get(propertyDescriptor);
    }

    public boolean isCollectionMembersAssignableTo(PropertyDescriptor propertyDescriptor, Class<?> clazz) {
        if (SpdxConstantsV3.PROP_EXTERNAL_REF.equals((Object)propertyDescriptor)) {
            return ExternalRef.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_VERIFIED_USING.equals((Object)propertyDescriptor)) {
            return IntegrityMethod.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_EXTENSION.equals((Object)propertyDescriptor)) {
            return Extension.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_EXTERNAL_IDENTIFIER.equals((Object)propertyDescriptor)) {
            return ExternalIdentifier.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_CREATED_USING.equals((Object)propertyDescriptor)) {
            return Tool.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_CREATED_BY.equals((Object)propertyDescriptor)) {
            return Agent.class.equals(clazz) || LicenseCreatorAgent.class.equals(clazz);
        }
        return false;
    }

    public boolean isPropertyValueAssignableTo(PropertyDescriptor propertyDescriptor, Class<?> clazz) {
        return String.class.equals(clazz) && (SpdxConstantsV3.PROP_COMMENT.equals((Object)propertyDescriptor) || SpdxConstantsV3.PROP_SPEC_VERSION.equals((Object)propertyDescriptor) || SpdxConstantsV3.PROP_CREATED.equals((Object)propertyDescriptor));
    }

    static {
        HashMap<PropertyDescriptor, String> ptosv = new HashMap<PropertyDescriptor, String>();
        ptosv.put(SpdxConstantsV3.PROP_COMMENT, "This is a generated SPDX License object from the SPDX license list");
        ptosv.put(SpdxConstantsV3.PROP_CREATED, null);
        ptosv.put(SpdxConstantsV3.PROP_CREATED_BY, null);
        ptosv.put(SpdxConstantsV3.PROP_SPEC_VERSION, "3.0.1");
        PROPERTY_TO_STATIC_VALUE = Collections.unmodifiableMap(ptosv);
        ALL_PROPERTY_DESCRIPTORS = Collections.unmodifiableList(new ArrayList(ptosv.keySet()));
        EMPTY = Collections.unmodifiableList(new ArrayList());
    }
}

