/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.listedlicense;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.ModelRegistryException;
import org.spdx.core.SpdxInvalidIdException;
import org.spdx.core.SpdxInvalidTypeException;
import org.spdx.core.TypedValue;
import org.spdx.library.SpdxModelFactory;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.Tool;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.storage.PropertyDescriptor;
import org.spdx.storage.listedlicense.LicenseCreationInfo;

public class LicenseCreatorAgent {
    static final String OBJECT_URI_PREFIX = "https://spdx.org/licenses/creatoragent/";
    public static final List<PropertyDescriptor> ALL_PROPERTY_DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(SpdxConstantsV3.PROP_CREATION_INFO, SpdxConstantsV3.PROP_NAME, SpdxConstantsV3.PROP_DESCRIPTION));
    static final List<String> EMPTY = Collections.unmodifiableList(new ArrayList());
    static final String NAME = "SPDX Legal Team";
    static final String DESCRIPTION = "This object is created and maintained by the SPDX legal team (https://spdx.dev/engage/participate/legal-team/)";
    private final String objectUri;
    private final TypedValue typedValue;
    private final TypedValue creationInfoTV;

    public LicenseCreatorAgent(String licenseListVersion) throws SpdxInvalidIdException, SpdxInvalidTypeException, ModelRegistryException {
        SpdxModelFactory.init();
        this.objectUri = OBJECT_URI_PREFIX + licenseListVersion.replace('.', '_');
        this.typedValue = new TypedValue(this.objectUri, "Core.Agent", "3.0.1");
        this.creationInfoTV = new TypedValue("__creation_info", "Core.CreationInfo", "3.0.1");
    }

    public String getObjectUri() {
        return this.objectUri;
    }

    public TypedValue getTypedValue() {
        return this.typedValue;
    }

    public List<?> getValueList(PropertyDescriptor propertyDescriptor) {
        return EMPTY;
    }

    public Object getValue(PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        if (SpdxConstantsV3.PROP_CREATION_INFO.equals((Object)propertyDescriptor)) {
            return this.creationInfoTV;
        }
        if (SpdxConstantsV3.PROP_NAME.equals((Object)propertyDescriptor)) {
            return NAME;
        }
        if (SpdxConstantsV3.PROP_DESCRIPTION.equals((Object)propertyDescriptor)) {
            return DESCRIPTION;
        }
        return null;
    }

    public boolean isCollectionMembersAssignableTo(PropertyDescriptor propertyDescriptor, Class<?> clazz) {
        if (SpdxConstantsV3.PROP_EXTERNAL_REF.equals((Object)propertyDescriptor)) {
            return ExternalRef.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_VERIFIED_USING.equals((Object)propertyDescriptor)) {
            return IntegrityMethod.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_EXTENSION.equals((Object)propertyDescriptor)) {
            return Extension.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_EXTERNAL_IDENTIFIER.equals((Object)propertyDescriptor)) {
            return ExternalIdentifier.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_CREATED_USING.equals((Object)propertyDescriptor)) {
            return Tool.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_CREATED_BY.equals((Object)propertyDescriptor)) {
            return Agent.class.equals(clazz) || LicenseCreatorAgent.class.equals(clazz);
        }
        return false;
    }

    public boolean isPropertyValueAssignableTo(PropertyDescriptor propertyDescriptor, Class<?> clazz) {
        return String.class.equals(clazz) && (SpdxConstantsV3.PROP_NAME.equals((Object)propertyDescriptor) || SpdxConstantsV3.PROP_DESCRIPTION.equals((Object)propertyDescriptor)) || (CreationInfo.class.equals(clazz) || LicenseCreationInfo.class.equals(clazz)) && SpdxConstantsV3.PROP_CREATION_INFO.equals((Object)propertyDescriptor);
    }

    public boolean isCollectionProperty(PropertyDescriptor propertyDescriptor) {
        return false;
    }
}

