/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.compare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.Annotation;
import org.spdx.library.model.v2.Checksum;
import org.spdx.library.model.v2.Relationship;
import org.spdx.library.model.v2.SpdxFile;
import org.spdx.library.model.v2.SpdxItem;
import org.spdx.library.model.v2.enumerations.FileType;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;
import org.spdx.utility.compare.SpdxItemDifference;

public class SpdxFileDifference
extends SpdxItemDifference {
    private final List<FileType> fileTypeA;
    private final List<FileType> fileTypeB;
    private final List<String> contributorsA;
    private final String noticeA;
    private final List<String> contributorsB;
    private final String noticeB;
    private final List<String> dependantFileNamesA;
    private final List<String> dependantFileNamesB;
    private final boolean checksumsEquals;
    private final List<Checksum> uniqueChecksumsA;
    private final List<Checksum> uniqueChecksumsB;
    private final String spdxIdA;
    private final String spdxIdB;

    public SpdxFileDifference(SpdxFile fileA, SpdxFile fileB, boolean concludedLicensesEqual, boolean seenLicensesEqual, List<AnyLicenseInfo> uniqueSeenLicensesA, List<AnyLicenseInfo> uniqueSeenLicensesB, boolean checksumsEquals, List<Checksum> uniqueChecksumsA, List<Checksum> uniqueChecksumsB, boolean relationshipsEquals, List<Relationship> uniqueRelationshipA, List<Relationship> uniqueRelationshipB, boolean annotationsEquals, List<Annotation> uniqueAnnotationsA, List<Annotation> uniqueAnnotationsB) throws InvalidSPDXAnalysisException, SpdxCompareException {
        super((SpdxItem)fileA, (SpdxItem)fileB, concludedLicensesEqual, seenLicensesEqual, uniqueSeenLicensesA, uniqueSeenLicensesB, relationshipsEquals, uniqueRelationshipA, uniqueRelationshipB, annotationsEquals, uniqueAnnotationsA, uniqueAnnotationsB);
        Optional dependantFileName;
        this.fileTypeA = Arrays.asList(fileA.getFileTypes().toArray(new FileType[0]));
        this.fileTypeB = Arrays.asList(fileB.getFileTypes().toArray(new FileType[0]));
        this.contributorsA = Arrays.asList(fileA.getFileContributors().toArray(new String[0]));
        this.contributorsB = Arrays.asList(fileB.getFileContributors().toArray(new String[0]));
        this.dependantFileNamesA = new ArrayList<String>();
        for (SpdxFile dependantFile : fileA.getFileDependency()) {
            dependantFileName = dependantFile.getName();
            dependantFileName.ifPresent(this.dependantFileNamesA::add);
        }
        this.dependantFileNamesB = new ArrayList<String>();
        for (SpdxFile dependantFile : fileB.getFileDependency()) {
            dependantFileName = dependantFile.getName();
            dependantFileName.ifPresent(this.dependantFileNamesB::add);
        }
        Optional noticeTextA = fileA.getNoticeText();
        this.noticeA = noticeTextA.orElse("");
        Optional noticeTextB = fileB.getNoticeText();
        this.noticeB = noticeTextB.orElse("");
        this.checksumsEquals = checksumsEquals;
        this.uniqueChecksumsA = uniqueChecksumsA;
        this.uniqueChecksumsB = uniqueChecksumsB;
        this.spdxIdA = fileA.getId();
        this.spdxIdB = fileB.getId();
    }

    public String getFileName() {
        return this.getName();
    }

    public List<FileType> getFileTypeA() {
        return this.fileTypeA;
    }

    public List<FileType> getFileTypeB() {
        return this.fileTypeB;
    }

    public boolean isContributorsEqual() {
        return SpdxComparer.stringListsEqual(this.contributorsA, this.contributorsB);
    }

    public boolean isNoticeTextsEqual() {
        return SpdxComparer.stringsEqual(this.noticeA, this.noticeB);
    }

    public boolean isFileDependenciesEqual() {
        return SpdxComparer.stringListsEqual(this.dependantFileNamesA, this.dependantFileNamesB);
    }

    public boolean isTypeEqual() {
        return SpdxComparer.listsEquals(this.fileTypeA, this.fileTypeB);
    }

    public boolean isChecksumsEquals() {
        return this.checksumsEquals;
    }

    public String getContributorsAAsString() {
        return SpdxFileDifference.stringListToString(this.contributorsA);
    }

    public String getContributorsBAsString() {
        return SpdxFileDifference.stringListToString(this.contributorsB);
    }

    static String stringListToString(List<String> s) {
        StringBuilder sb = new StringBuilder();
        if (s != null && !s.isEmpty()) {
            sb.append(s.get(0));
            for (int i = 1; i < s.size(); ++i) {
                if (!Objects.nonNull(s.get(i)) || s.get(i).isEmpty()) continue;
                sb.append(", ");
                sb.append(s.get(i));
            }
        }
        return sb.toString();
    }

    public String getFileDependenciesAAsString() {
        return SpdxFileDifference.stringListToString(this.dependantFileNamesA);
    }

    public String getFileDependenciesBAsString() {
        return SpdxFileDifference.stringListToString(this.dependantFileNamesB);
    }

    public List<String> getContributorsA() {
        return this.contributorsA;
    }

    public String getNoticeA() {
        return this.noticeA;
    }

    public List<String> getContributorsB() {
        return this.contributorsB;
    }

    public String getNoticeB() {
        return this.noticeB;
    }

    public List<String> getDependantFileNamesA() {
        return this.dependantFileNamesA;
    }

    public List<String> getDependantFileNamesB() {
        return this.dependantFileNamesB;
    }

    public List<Checksum> getUniqueChecksumsA() {
        return this.uniqueChecksumsA;
    }

    public List<Checksum> getUniqueChecksumsB() {
        return this.uniqueChecksumsB;
    }

    public String getSpdxIdA() {
        return this.spdxIdA;
    }

    public String getSpdxIdB() {
        return this.spdxIdB;
    }
}

