/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.jacksonstore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;

public class PropertyComparator
implements Comparator<String> {
    static final List<String> DOCUMENT_PROPERTY_ORDER = Arrays.asList(SpdxConstantsCompatV2.PROP_DOCUMENT_NAMESPACE.getName(), SpdxConstantsCompatV2.PROP_SPDX_SPEC_VERSION.getName(), SpdxConstantsCompatV2.PROP_SPDX_CREATION_INFO.getName(), SpdxConstantsCompatV2.PROP_NAME.getName(), SpdxConstantsCompatV2.PROP_SPDX_DATA_LICENSE.getName(), SpdxConstantsCompatV2.RDFS_PROP_COMMENT.getName(), SpdxConstantsCompatV2.PROP_SPDX_EXTERNAL_DOC_REF.getName(), SpdxConstantsCompatV2.PROP_DOCUMENT_DESCRIBES.getName(), SpdxConstantsCompatV2.PROP_DOCUMENT_PACKAGES.getName(), SpdxConstantsCompatV2.PROP_DOCUMENT_FILES.getName(), SpdxConstantsCompatV2.PROP_DOCUMENT_SNIPPETS.getName(), SpdxConstantsCompatV2.PROP_SPDX_EXTRACTED_LICENSES.getName(), SpdxConstantsCompatV2.PROP_ANNOTATION.getName(), SpdxConstantsCompatV2.PROP_DOCUMENT_RELATIONSHIPS.getName());
    static final Map<String, List<String>> propertyOrderMap;
    private List<String> propertyOrder;

    public PropertyComparator(String type) {
        this.propertyOrder = propertyOrderMap.get(type);
        if (Objects.isNull(this.propertyOrder)) {
            this.propertyOrder = new ArrayList<String>();
        }
    }

    @Override
    public int compare(String o1, String o2) {
        int retval;
        int i2;
        int i1 = this.propertyOrder.indexOf(o1);
        if (i1 < 0) {
            i1 = 999;
        }
        if ((i2 = this.propertyOrder.indexOf(o2)) < 0) {
            i2 = 999;
        }
        if ((retval = Integer.compare(i1, i2)) == 0) {
            retval = o1.compareTo(o2);
        }
        return retval;
    }

    static {
        HashMap<String, List<String>> hm = new HashMap<String, List<String>>();
        hm.put("SpdxDocument", DOCUMENT_PROPERTY_ORDER);
        propertyOrderMap = Collections.unmodifiableMap(hm);
    }
}

