/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IExternalElementInfo;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.ModelCollection;
import org.spdx.core.ModelObjectHelper;
import org.spdx.core.SimpleUriValue;
import org.spdx.core.SpdxInvalidTypeException;
import org.spdx.library.model.v2.Checksum;
import org.spdx.library.model.v2.ModelObjectV2;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.library.model.v2.SpdxModelFactoryCompatV2;
import org.spdx.library.model.v2.SpdxVerificationHelper;
import org.spdx.library.model.v2.enumerations.ChecksumAlgorithm;
import org.spdx.storage.IModelStore;
import org.spdx.storage.PropertyDescriptor;
import org.spdx.storage.compatv2.CompatibleModelStoreWrapper;

public class ExternalDocumentRef
extends ModelObjectV2
implements Comparable<ExternalDocumentRef>,
IExternalElementInfo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<ExternalDocumentRef> getExternalDocRefByDocNamespace(IModelStore stModelStore, String stDocumentUri, String externalDocUri, @Nullable IModelCopyManager copyManager, String specVersion) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(stModelStore, "Model store can not be null");
        Objects.requireNonNull(stDocumentUri, "Document URI can not be null");
        Objects.requireNonNull(externalDocUri, "External document URI can not be null");
        IModelStore.IModelStoreLock lock = stModelStore.enterCriticalSection(false);
        try {
            ModelCollection existingExternalRefs = new ModelCollection(stModelStore, CompatibleModelStoreWrapper.documentUriIdToUri(stDocumentUri, "SPDXRef-DOCUMENT", false), SpdxConstantsCompatV2.PROP_SPDX_EXTERNAL_DOC_REF, copyManager, ExternalDocumentRef.class, specVersion, null);
            for (Object externalRef : existingExternalRefs) {
                if (!(externalRef instanceof ExternalDocumentRef)) {
                    logger.warn("Incorrect type for an external document ref: " + externalRef.getClass().toString());
                    continue;
                }
                String externalRefNamespace = ((ExternalDocumentRef)externalRef).getSpdxDocumentNamespace();
                if (externalRefNamespace.isEmpty()) {
                    logger.warn("Namespace missing for external doc ref " + ((ExternalDocumentRef)externalRef).getId());
                }
                if (!externalDocUri.equals(externalRefNamespace)) continue;
                Optional<ExternalDocumentRef> optional = Optional.of((ExternalDocumentRef)externalRef);
                return optional;
            }
            if (Objects.nonNull(copyManager)) {
                ExternalDocumentRef retval = new ExternalDocumentRef(stModelStore, stDocumentUri, stModelStore.getNextId(IModelStore.IdType.DocumentRef), copyManager, true);
                retval.setSpdxDocumentNamespace(externalDocUri);
                ModelObjectHelper.addValueToCollection((IModelStore)stModelStore, (String)CompatibleModelStoreWrapper.documentUriIdToUri(stDocumentUri, "SPDXRef-DOCUMENT", false), (PropertyDescriptor)SpdxConstantsCompatV2.PROP_SPDX_EXTERNAL_DOC_REF, (Object)retval, (IModelCopyManager)copyManager, null);
                Optional<ExternalDocumentRef> optional = Optional.of(retval);
                return optional;
            }
            Optional optional = Optional.empty();
            return optional;
        }
        finally {
            stModelStore.leaveCriticalSection(lock);
        }
    }

    public ExternalDocumentRef() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.DocumentRef));
    }

    public ExternalDocumentRef(String id) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), DefaultModelStore.getDefaultDocumentUri(), id, DefaultModelStore.getDefaultCopyManager(), true);
    }

    public ExternalDocumentRef(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
        if (!SpdxVerificationHelper.isValidExternalDocRef(id)) {
            logger.warn("Invalid external document reference ID " + id + ".  Must be of the format " + SpdxConstantsCompatV2.EXTERNAL_DOC_REF_PATTERN.pattern());
        }
    }

    public String getType() {
        return "ExternalDocumentRef";
    }

    private String documentToDocumentUri(SpdxDocument document) {
        Objects.requireNonNull(document, "Document can not be null");
        String retval = document.getDocumentUri();
        if (retval.endsWith("#")) {
            retval = retval.substring(0, retval.length() - 1);
        }
        return retval;
    }

    public Optional<Checksum> getChecksum() throws InvalidSPDXAnalysisException {
        return this.getObjectPropertyValue(SpdxConstantsCompatV2.PROP_EXTERNAL_DOC_CHECKSUM);
    }

    public ExternalDocumentRef setChecksum(Checksum checksum) throws InvalidSPDXAnalysisException {
        if (this.strict) {
            if (Objects.isNull(checksum)) {
                throw new InvalidSPDXAnalysisException("Null value for a required checksum");
            }
            List<String> verify = checksum.verify(new HashSet<String>(), this.specVersion);
            if (verify.size() > 0) {
                throw new InvalidSPDXAnalysisException("Invalid checksum: " + verify.get(0));
            }
        }
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_EXTERNAL_DOC_CHECKSUM, checksum);
        return this;
    }

    public String getSpdxDocumentNamespace() throws InvalidSPDXAnalysisException {
        Optional docNamespace = this.getModelStore().getValue(CompatibleModelStoreWrapper.documentUriIdToUri(this.getDocumentUri(), this.getId(), this.getModelStore().isAnon(this.getId())), SpdxConstantsCompatV2.PROP_EXTERNAL_SPDX_DOCUMENT);
        if (!docNamespace.isPresent()) {
            logger.warn("SPDX document namespace not found");
            return "";
        }
        if (docNamespace.get() instanceof IndividualUriValue) {
            String docUri = ((IndividualUriValue)docNamespace.get()).getIndividualURI();
            if (Objects.isNull(docUri)) {
                logger.warn("Missing individual URI in doc namespace");
                return "";
            }
            return docUri;
        }
        if (docNamespace.get() instanceof String) {
            logger.warn("Spdx Document Namespace is of type literal string.  Recommended type is IndividualValue");
            return (String)docNamespace.get();
        }
        logger.error("SPDX document namespace is not of type IndividualValue or String.  Type=" + docNamespace.get().getClass().toString());
        throw new SpdxInvalidTypeException("SPDX document namespace is not of type IndividualValue or String");
    }

    public ExternalDocumentRef setSpdxDocumentNamespace(final String documentNamespace) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(documentNamespace)) {
            if (this.strict) {
                throw new InvalidSPDXAnalysisException("Null value for a required document namespace");
            }
            this.setPropertyValue(SpdxConstantsCompatV2.PROP_EXTERNAL_SPDX_DOCUMENT, null);
        } else {
            if (this.strict && !SpdxVerificationHelper.isValidUri(documentNamespace)) {
                throw new InvalidSPDXAnalysisException("Invalid document namespace.  Must be a valid URI.");
            }
            this.setPropertyValue(SpdxConstantsCompatV2.PROP_EXTERNAL_SPDX_DOCUMENT, new IndividualUriValue(){
                final /* synthetic */ ExternalDocumentRef this$0;
                {
                    this.this$0 = this$0;
                }

                public String getIndividualURI() {
                    return documentNamespace;
                }

                public boolean equals(Object comp) {
                    return SimpleUriValue.isIndividualUriValueEquals((IndividualUriValue)this, (Object)comp);
                }

                public int hashCode() {
                    return SimpleUriValue.getIndividualUriValueHash((IndividualUriValue)this);
                }
            });
        }
        return this;
    }

    public Optional<SpdxDocument> getSpdxDocument() throws InvalidSPDXAnalysisException {
        String docNamespace = this.getSpdxDocumentNamespace();
        if (docNamespace.isEmpty()) {
            return Optional.empty();
        }
        if (this.getModelStore().exists(CompatibleModelStoreWrapper.documentUriIdToUri(docNamespace, "SPDXRef-DOCUMENT", false))) {
            return Optional.of(SpdxModelFactoryCompatV2.createModelObjectV2(this.getModelStore(), docNamespace, "SPDXRef-DOCUMENT", "SpdxDocument", this.getCopyManager()));
        }
        return Optional.empty();
    }

    public ExternalDocumentRef setSpdxDocument(SpdxDocument spdxDocument) throws InvalidSPDXAnalysisException {
        this.setSpdxDocumentNamespace(this.documentToDocumentUri(spdxDocument));
        return this;
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        if (!this.getId().startsWith(SpdxConstantsCompatV2.EXTERNAL_DOC_REF_PRENUM)) {
            retval.add("Invalid external ref ID: " + this.getId() + ".  Must start with " + SpdxConstantsCompatV2.EXTERNAL_DOC_REF_PRENUM + ".");
        }
        String spdxDocumentNamespace = "UNKNOWN";
        try {
            spdxDocumentNamespace = this.getSpdxDocumentNamespace();
            if (spdxDocumentNamespace.isEmpty()) {
                retval.add("Missing required external document URI");
            } else if (!SpdxVerificationHelper.isValidUri(spdxDocumentNamespace)) {
                retval.add("Invalid URI for external Spdx Document URI: " + spdxDocumentNamespace);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("error getting document namespace", (Throwable)e);
            retval.add("Error getting document namespace");
        }
        try {
            Optional<Checksum> checksum = this.getChecksum();
            if (!checksum.isPresent()) {
                retval.add("Missing checksum for external document " + this.getId());
            } else {
                retval.addAll(checksum.get().verify(verifiedIds, specVersion));
                if (checksum.get().getAlgorithm() != ChecksumAlgorithm.SHA1) {
                    retval.add("Checksum algorithm is not SHA1 for external reference " + this.getId());
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("error getting checksum", (Throwable)e);
            retval.add("Error getting checksum for " + this.getId());
        }
        return retval;
    }

    @Override
    public int compareTo(ExternalDocumentRef o) {
        Optional<Checksum> compareChecksum;
        Optional<Checksum> myChecksum;
        String compareDocumentNamespace;
        String myDocumentNamespace;
        try {
            myDocumentNamespace = this.getSpdxDocumentNamespace();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting document namespace", (Throwable)e);
            myDocumentNamespace = "";
        }
        try {
            compareDocumentNamespace = o.getSpdxDocumentNamespace();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting compare document namespace", (Throwable)e);
            compareDocumentNamespace = "";
        }
        int retval = myDocumentNamespace.compareTo(compareDocumentNamespace);
        if (retval != 0) {
            return retval;
        }
        try {
            myChecksum = this.getChecksum();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting checksum", (Throwable)e);
            myChecksum = Optional.empty();
        }
        try {
            compareChecksum = o.getChecksum();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting compare checksum", (Throwable)e);
            compareChecksum = Optional.empty();
        }
        if (!compareChecksum.isPresent()) {
            if (myChecksum.isPresent()) {
                return 1;
            }
        } else {
            if (!myChecksum.isPresent()) {
                return -1;
            }
            retval = myChecksum.get().compareTo(compareChecksum.get());
        }
        return retval;
    }
}

