/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.ModelObjectV2;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxVerificationHelper;
import org.spdx.storage.IModelStore;

public class SpdxCreatorInformation
extends ModelObjectV2 {
    public SpdxCreatorInformation() throws InvalidSPDXAnalysisException {
    }

    public SpdxCreatorInformation(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public SpdxCreatorInformation(IModelStore modelStore, String documentUri, String id, IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public Collection<String> getCreators() throws InvalidSPDXAnalysisException {
        return this.getStringCollection(SpdxConstantsCompatV2.PROP_CREATION_CREATOR);
    }

    public Optional<String> getLicenseListVersion() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_LIST_VERSION);
    }

    public SpdxCreatorInformation setLicenseListVersion(String licenseListVersion) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_LIST_VERSION, licenseListVersion);
        return this;
    }

    public Optional<String> getComment() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsCompatV2.RDFS_PROP_COMMENT);
    }

    public SpdxCreatorInformation setComment(String comment) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.RDFS_PROP_COMMENT, comment);
        return this;
    }

    public String getCreated() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_CREATION_CREATED);
        if (retval.isPresent()) {
            return (String)retval.get();
        }
        logger.warn("Missing created date");
        return "";
    }

    public SpdxCreatorInformation setCreated(String created) throws InvalidSPDXAnalysisException {
        if (this.strict) {
            if (Objects.isNull(created)) {
                throw new InvalidSPDXAnalysisException("Can not set required created date to null");
            }
            String verify = SpdxVerificationHelper.verifyDate(created);
            if (Objects.nonNull(verify) && !verify.isEmpty()) {
                throw new InvalidSPDXAnalysisException(verify);
            }
        }
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_CREATION_CREATED, created);
        return this;
    }

    public String getType() {
        return "CreationInfo";
    }

    @Override
    public String toString() {
        Optional<String> comment;
        Optional<String> licenseListVersion;
        String created;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        try {
            for (String creator : this.getCreators()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(creator);
                first = false;
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting creators", (Throwable)e);
        }
        try {
            created = this.getCreated();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting created", (Throwable)e);
            created = "";
        }
        sb.append("; Created on ");
        sb.append(created);
        try {
            licenseListVersion = this.getLicenseListVersion();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting licenseListVersion", (Throwable)e);
            licenseListVersion = Optional.empty();
        }
        if (licenseListVersion.isPresent()) {
            sb.append("; License List Version=");
            sb.append(licenseListVersion.get());
        }
        try {
            comment = this.getComment();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting comment", (Throwable)e);
            comment = Optional.empty();
        }
        if (comment.isPresent()) {
            sb.append("; Comment: ");
            sb.append(comment.get());
        }
        return sb.toString();
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        String verify;
        ArrayList<String> retval = new ArrayList<String>();
        try {
            int numCreators = 0;
            for (String creator : this.getCreators()) {
                String verify2 = SpdxVerificationHelper.verifyCreator(creator);
                if (verify2 != null) {
                    retval.add(verify2);
                }
                ++numCreators;
            }
            if (numCreators == 0) {
                retval.add("Missing required creators");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting creators: " + e.getMessage());
        }
        try {
            String creationDate = this.getCreated();
            if (creationDate.isEmpty()) {
                retval.add("Missing required created date");
            } else {
                verify = SpdxVerificationHelper.verifyDate(creationDate);
                if (verify != null) {
                    retval.add(verify);
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting creation date: " + e.getMessage());
        }
        try {
            Optional<String> licenseListVersion = this.getLicenseListVersion();
            if (licenseListVersion.isPresent() && (verify = this.verifyLicenseListVersion(licenseListVersion.get())) != null) {
                retval.add(verify);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting license list version: " + e.getMessage());
        }
        return retval;
    }

    @Nullable
    private String verifyLicenseListVersion(String version) {
        if (Objects.isNull(version)) {
            return null;
        }
        if (SpdxConstantsCompatV2.LICENSE_LIST_VERSION_PATTERN.matcher(version).matches()) {
            return null;
        }
        return "License list version does not match the pattern M.N or M.N.P";
    }
}

