/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2.license;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.SimpleUriValue;
import org.spdx.library.model.v2.ExternalDocumentRef;
import org.spdx.library.model.v2.ExternalSpdxElement;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.library.model.v2.license.AbstractExtractedLicenseInfo;
import org.spdx.storage.IModelStore;
import org.spdx.storage.compatv2.CompatibleModelStoreWrapper;

public class ExternalExtractedLicenseInfo
extends AbstractExtractedLicenseInfo
implements IndividualUriValue {
    public ExternalExtractedLicenseInfo(String documentUri, String id) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), ExternalExtractedLicenseInfo.checkConvertDocumentUri(documentUri, id, DefaultModelStore.getDefaultModelStore()), ExternalExtractedLicenseInfo.checkConvertId(id), DefaultModelStore.getDefaultCopyManager());
    }

    public ExternalExtractedLicenseInfo(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, ExternalExtractedLicenseInfo.checkConvertDocumentUri(documentUri, id, modelStore), ExternalExtractedLicenseInfo.checkConvertId(id), copyManager, true);
    }

    public ExternalExtractedLicenseInfo(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        super(modelStore, ExternalExtractedLicenseInfo.checkConvertDocumentUri(documentUri, id, modelStore), ExternalExtractedLicenseInfo.checkConvertId(id), copyManager, true);
    }

    private static String checkConvertDocumentUri(String documentUri, String id, IModelStore modelStore) throws InvalidSPDXAnalysisException {
        if (id.contains(":")) {
            String externalUri = ExternalExtractedLicenseInfo.externalExtractedLicenseIdToURI(id, modelStore, documentUri, null);
            return externalUri.substring(0, externalUri.indexOf(35));
        }
        return documentUri;
    }

    private static String checkConvertId(String id) {
        if (id.contains(":")) {
            return id.substring(id.lastIndexOf(58) + 1);
        }
        return id;
    }

    public boolean isExternal() {
        return true;
    }

    public String getExternalDocumentId() throws InvalidSPDXAnalysisException {
        return this.getDocumentUri();
    }

    public String getExternalLicenseRef() throws InvalidSPDXAnalysisException {
        return this.getId();
    }

    public String getType() {
        return "ExternalExtractedLicenseInfo";
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        Matcher matcher = SpdxConstantsCompatV2.EXTERNAL_EXTRACTED_LICENSE_URI_PATTERN.matcher(this.getObjectUri());
        if (!matcher.matches()) {
            retval.add("Invalid objectUri format for an external document reference.  Must be of the form " + SpdxConstantsCompatV2.EXTERNAL_EXTRACTED_LICENSE_URI_PATTERN.pattern());
        }
        return retval;
    }

    public String getExternalExtractedLicenseURI() throws InvalidSPDXAnalysisException {
        return this.getObjectUri();
    }

    public static String externalExtractedLicenseIdToURI(String externalExtractedLicenseId, IModelStore stModelStore, String stDocumentUri, IModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        Matcher matcher = SpdxConstantsCompatV2.EXTERNAL_EXTRACTED_LICENSE_PATTERN.matcher(externalExtractedLicenseId);
        if (!matcher.matches()) {
            logger.error("Invalid objectUri format for an external document reference.  Must be of the form ExternalSPDXRef:LicenseRef-XXX");
            throw new InvalidSPDXAnalysisException("Invalid objectUri format for an external document reference.  Must be of the form ExternalSPDXRef:LicenseRef-XXX");
        }
        String externalDocumentUri = ExternalSpdxElement.externalDocumentIdToNamespace(matcher.group(1), stModelStore, stDocumentUri, copyManager);
        if (externalDocumentUri.endsWith("#")) {
            return externalDocumentUri + matcher.group(2);
        }
        return externalDocumentUri + "#" + matcher.group(2);
    }

    public static String uriToExternalExtractedLicenseRef(String uri, IModelStore stModelStore, String stDocumentUri, IModelCopyManager copyManager, String specVersion) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(uri, "URI can not be null");
        Matcher matcher = SpdxConstantsCompatV2.EXTERNAL_EXTRACTED_LICENSE_URI_PATTERN.matcher(uri);
        if (!matcher.matches()) {
            throw new InvalidSPDXAnalysisException("Invalid URI format: " + uri + ".  Expects namespace#LicenseRef-XXXX");
        }
        Optional<ExternalDocumentRef> externalDocRef = ExternalDocumentRef.getExternalDocRefByDocNamespace(stModelStore, stDocumentUri, matcher.group(1), copyManager, specVersion);
        if (!externalDocRef.isPresent()) {
            logger.error("Could not find or create the external document reference for document namespace " + matcher.group(1));
            throw new InvalidSPDXAnalysisException("Could not find or create the external document reference for document namespace " + matcher.group(1));
        }
        return externalDocRef.get().getId() + ":" + matcher.group(2);
    }

    public String referenceElementId(SpdxDocument documentReferencingExternal) throws InvalidSPDXAnalysisException {
        Matcher matcher = SpdxConstantsCompatV2.EXTERNAL_EXTRACTED_LICENSE_URI_PATTERN.matcher(this.getObjectUri());
        if (!matcher.matches()) {
            throw new InvalidSPDXAnalysisException("Invalid URI format: " + this.getObjectUri() + ".  Expects namespace#LicenseRef-XXXX");
        }
        Optional<ExternalDocumentRef> externalDocRef = ExternalDocumentRef.getExternalDocRefByDocNamespace(documentReferencingExternal.getModelStore(), documentReferencingExternal.getDocumentUri(), matcher.group(1), documentReferencingExternal.getCopyManager(), documentReferencingExternal.getSpecVersion());
        if (!externalDocRef.isPresent()) {
            logger.error("Could not find or create the external document reference for document namespace " + matcher.group(1));
            throw new InvalidSPDXAnalysisException("Could not find or create the external document reference for document namespace " + matcher.group(1));
        }
        return externalDocRef.get().getId() + ":" + matcher.group(2);
    }

    public boolean equivalent(CoreModelObject compare) {
        if (!(compare instanceof ExternalExtractedLicenseInfo)) {
            return false;
        }
        return this.getObjectUri().equals(((ExternalExtractedLicenseInfo)compare).getObjectUri());
    }

    public boolean equivalent(CoreModelObject compare, boolean ignoreRelatedElements) throws InvalidSPDXAnalysisException {
        return this.equivalent(compare);
    }

    public String getIndividualURI() {
        try {
            return this.getExternalExtractedLicenseURI();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting external LicenseRef URI", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getExtractedText() throws InvalidSPDXAnalysisException {
        return "The text for this license can be found in the external document " + this.getExternalDocumentId() + " license Ref " + this.getExternalLicenseRef() + ".";
    }

    @Override
    public String getComment() throws InvalidSPDXAnalysisException {
        return "This is an external LicenseRef - see the document containing the license for any comments";
    }

    @Override
    public void setComment(String comment) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can not set comment for an external LicenseRef.  Changes to the license need to be made within the document containing the license.");
    }

    @Override
    public Collection<String> getSeeAlso() throws InvalidSPDXAnalysisException {
        return new ArrayList<String>();
    }

    @Override
    public void setSeeAlso(Collection<String> seeAlsoUrl) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can not set seeAlso for an external LicenseRef.  Changes to the license need to be made within the document containing the license.");
    }

    @Override
    public String getName() throws InvalidSPDXAnalysisException {
        return "";
    }

    @Override
    public void setName(String name) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can not set name for an external LicenseRef.  Changes to the license need to be made within the document containing the license.");
    }

    @Override
    public boolean equals(Object comp) {
        return SimpleUriValue.isIndividualUriValueEquals((IndividualUriValue)this, (Object)comp);
    }

    @Override
    public int hashCode() {
        return SimpleUriValue.getIndividualUriValueHash((IndividualUriValue)this);
    }

    @Override
    public String toString() {
        ArrayList matchingDocRefs = new ArrayList();
        try {
            this.modelStore.getAllItems(null, "SpdxDocument").forEach(docTv -> {
                try {
                    String docUriForMatch = docTv.getObjectUri().substring(0, docTv.getObjectUri().indexOf(35));
                    this.modelStore.getAllItems(docUriForMatch, "ExternalDocumentRef").forEach(docRefTv -> {
                        try {
                            ExternalDocumentRef docRef = new ExternalDocumentRef(this.modelStore, docUriForMatch, CompatibleModelStoreWrapper.objectUriToId(false, docRefTv.getObjectUri(), docUriForMatch), this.copyManager, false);
                            if (this.getDocumentUri().equals(docRef.getSpdxDocumentNamespace())) {
                                matchingDocRefs.add(docRef);
                            }
                        }
                        catch (InvalidSPDXAnalysisException e) {
                            logger.error("Error getting external document ref", (Throwable)e);
                        }
                    });
                }
                catch (InvalidSPDXAnalysisException e) {
                    logger.error("Error getting external document ref", (Throwable)e);
                }
            });
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting SPDX documents for toString", (Throwable)e);
        }
        if (matchingDocRefs.size() == 1) {
            return ((ExternalDocumentRef)matchingDocRefs.get(0)).getId() + ":" + this.getId();
        }
        return this.getObjectUri();
    }
}

