/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2.license;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringEscapeUtils;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.license.SimpleLicensingInfo;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.storage.IModelStore;

public abstract class License
extends SimpleLicensingInfo {
    static final String XML_LITERAL = "^^http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
    private boolean templateInHtml = false;

    public License(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    License(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public String getLicenseText() throws InvalidSPDXAnalysisException {
        Optional o = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_TEXT);
        if (o.isPresent()) {
            return (String)o.get();
        }
        return "";
    }

    public void setLicenseText(String text) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_TEXT, text);
    }

    public String getStandardLicenseHeader() throws InvalidSPDXAnalysisException {
        Optional standardLicenseHeader = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_STD_LICENSE_NOTICE);
        if (standardLicenseHeader.isPresent()) {
            return StringEscapeUtils.unescapeHtml4((String)((String)standardLicenseHeader.get()));
        }
        return "";
    }

    public String getStandardLicenseHeaderTemplate() throws InvalidSPDXAnalysisException {
        Optional standardLicenseHeaderTemplate = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_STD_LICENSE_HEADER_TEMPLATE);
        if (standardLicenseHeaderTemplate.isPresent()) {
            return StringEscapeUtils.unescapeHtml4((String)((String)standardLicenseHeaderTemplate.get()));
        }
        return "";
    }

    public void setStandardLicenseHeaderTemplate(String standardLicenseHeaderTemplate) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_STD_LICENSE_HEADER_TEMPLATE, standardLicenseHeaderTemplate);
    }

    public void setStandardLicenseHeader(String standardLicenseHeader) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_STD_LICENSE_NOTICE, standardLicenseHeader);
    }

    public String getStandardLicenseTemplate() throws InvalidSPDXAnalysisException {
        Optional o = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_STD_LICENSE_TEMPLATE);
        if (!o.isPresent()) {
            return "";
        }
        String standardLicenseTemplate = (String)o.get();
        if (standardLicenseTemplate != null && standardLicenseTemplate.endsWith(XML_LITERAL)) {
            standardLicenseTemplate = standardLicenseTemplate.substring(0, standardLicenseTemplate.length() - XML_LITERAL.length());
        }
        if (standardLicenseTemplate != null && this.templateInHtml) {
            standardLicenseTemplate = SpdxLicenseTemplateHelper.htmlToText((String)standardLicenseTemplate);
        }
        return standardLicenseTemplate;
    }

    public void setStandardLicenseTemplate(String template) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_STD_LICENSE_TEMPLATE, template);
    }

    @Override
    public String toString() {
        if (this.getId() == null) {
            return "NULL LICENSE";
        }
        return this.getId();
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        String id = this.getLicenseId();
        if (id == null || id.isEmpty()) {
            retval.add("Missing required license ID");
        }
        try {
            String name = this.getName();
            if (name == null || name.isEmpty()) {
                retval.add("Missing required license name");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for name");
        }
        try {
            this.getComment();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for comment");
        }
        try {
            this.getSeeAlso();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for seeAlso");
        }
        try {
            this.getStandardLicenseHeader();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for standard license header");
        }
        try {
            this.getStandardLicenseTemplate();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for standard license template");
        }
        try {
            this.getStandardLicenseHeaderTemplate();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for standard license header template");
        }
        try {
            String licenseText = this.getLicenseText();
            if (licenseText == null || licenseText.isEmpty()) {
                retval.add("Missing required license text for " + id);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for license text");
        }
        return retval;
    }

    public boolean isFsfLibre() throws InvalidSPDXAnalysisException {
        Optional libre = this.getBooleanPropertyValue(SpdxConstantsCompatV2.PROP_STD_LICENSE_FSF_LIBRE);
        if (!libre.isPresent()) {
            return false;
        }
        return (Boolean)libre.get();
    }

    public boolean isNotFsfLibre() throws InvalidSPDXAnalysisException {
        Optional fsfLibre = this.getBooleanPropertyValue(SpdxConstantsCompatV2.PROP_STD_LICENSE_FSF_LIBRE);
        return fsfLibre.isPresent() && (Boolean)fsfLibre.get() == false;
    }

    public Boolean getFsfLibre() throws InvalidSPDXAnalysisException {
        Optional libre = this.getBooleanPropertyValue(SpdxConstantsCompatV2.PROP_STD_LICENSE_FSF_LIBRE);
        if (libre.isPresent()) {
            return (Boolean)libre.get();
        }
        return null;
    }

    public boolean isOsiApproved() throws InvalidSPDXAnalysisException {
        Optional osiApproved = this.getBooleanPropertyValue(SpdxConstantsCompatV2.PROP_STD_LICENSE_OSI_APPROVED);
        return osiApproved.isPresent() && (Boolean)osiApproved.get() != false;
    }

    public boolean isDeprecated() throws InvalidSPDXAnalysisException {
        Optional deprecated = this.getBooleanPropertyValue(SpdxConstantsCompatV2.PROP_LIC_ID_DEPRECATED);
        return deprecated.isPresent() && (Boolean)deprecated.get() != false;
    }

    public void setOsiApproved(Boolean osiApproved) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_STD_LICENSE_OSI_APPROVED, osiApproved);
    }

    public void setFsfLibre(Boolean fsfLibre) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_STD_LICENSE_FSF_LIBRE, fsfLibre);
    }

    public void setDeprecated(Boolean deprecated) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_LIC_ID_DEPRECATED, deprecated);
    }

    public IModelStore.ModelUpdate updateSetDeprecated(Boolean deprecated) throws InvalidSPDXAnalysisException {
        return this.updatePropertyValue(SpdxConstantsCompatV2.PROP_LIC_ID_DEPRECATED, deprecated);
    }
}

