/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2.license;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.ModelObjectV2;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.license.ListedLicenseException;
import org.spdx.storage.IModelStore;

public abstract class LicenseException
extends ModelObjectV2 {
    public LicenseException(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, "http://spdx.org/licenses/", id, copyManager, create);
        if (!(this instanceof IndividualUriValue) && !(this instanceof ListedLicenseException)) {
            this.setPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_EXCEPTION_ID, id);
        }
    }

    public LicenseException(String id, String name, String text, Collection<String> seeAlso, String comment) throws InvalidSPDXAnalysisException {
        this(id, name, text);
        this.setSeeAlso(seeAlso);
        this.setComment(comment);
    }

    public LicenseException(String id, String name, String text, String template, Collection<String> seeAlso, String comment) throws InvalidSPDXAnalysisException {
        this(id, name, text, seeAlso, comment);
        this.setLicenseExceptionTemplate(template);
    }

    public LicenseException(String id, String name, String text) throws InvalidSPDXAnalysisException {
        super(DefaultModelStore.getDefaultModelStore(), "http://spdx.org/licenses/", id, DefaultModelStore.getDefaultCopyManager(), true);
        this.setName(name);
        this.setLicenseExceptionText(text);
        if (!(this instanceof IndividualUriValue) && !(this instanceof ListedLicenseException)) {
            this.setPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_EXCEPTION_ID, id);
        }
    }

    public String getComment() throws InvalidSPDXAnalysisException {
        Optional o = this.getStringPropertyValue(SpdxConstantsCompatV2.RDFS_PROP_COMMENT);
        if (o.isPresent()) {
            return (String)o.get();
        }
        return "";
    }

    public void setComment(String comment) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.RDFS_PROP_COMMENT, comment);
    }

    @Deprecated
    public String getExample() throws InvalidSPDXAnalysisException {
        Optional o = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_EXAMPLE);
        if (o.isPresent()) {
            return (String)o.get();
        }
        return "";
    }

    @Deprecated
    public void setExample(String example) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_EXAMPLE, example);
    }

    public String getLicenseExceptionId() {
        return this.getId();
    }

    public String getLicenseExceptionTemplate() throws InvalidSPDXAnalysisException {
        Optional o = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_EXCEPTION_TEMPLATE);
        if (o.isPresent()) {
            return (String)o.get();
        }
        return "";
    }

    public void setLicenseExceptionTemplate(String template) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_EXCEPTION_TEMPLATE, template);
    }

    public String getLicenseExceptionText() throws InvalidSPDXAnalysisException {
        Optional o = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_EXCEPTION_TEXT);
        if (o.isPresent()) {
            return (String)o.get();
        }
        return "";
    }

    public void setLicenseExceptionText(String text) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_EXCEPTION_TEXT, text);
    }

    public String getName() throws InvalidSPDXAnalysisException {
        Optional o = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_STD_LICENSE_NAME);
        if (o.isPresent()) {
            return (String)o.get();
        }
        return "";
    }

    public void setName(String name) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_STD_LICENSE_NAME, name);
    }

    public Collection<String> getSeeAlso() throws InvalidSPDXAnalysisException {
        return this.getStringCollection(SpdxConstantsCompatV2.RDFS_PROP_SEE_ALSO);
    }

    public void setSeeAlso(Collection<String> seeAlso) throws InvalidSPDXAnalysisException {
        if (seeAlso == null) {
            this.clearValueCollection(SpdxConstantsCompatV2.RDFS_PROP_SEE_ALSO);
        } else {
            this.setPropertyValue(SpdxConstantsCompatV2.RDFS_PROP_SEE_ALSO, seeAlso);
        }
    }

    public boolean isDeprecated() throws InvalidSPDXAnalysisException {
        Optional deprecated = this.getBooleanPropertyValue(SpdxConstantsCompatV2.PROP_LIC_ID_DEPRECATED);
        return deprecated.isPresent() && (Boolean)deprecated.get() != false;
    }

    public void setDeprecated(Boolean deprecated) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_LIC_ID_DEPRECATED, deprecated);
    }

    public String getDeprecatedVersion() throws InvalidSPDXAnalysisException {
        Optional o = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_LIC_DEPRECATED_VERSION);
        if (o.isPresent()) {
            return (String)o.get();
        }
        return "";
    }

    public void setDeprecatedVersion(String deprecatedVersion) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_LIC_DEPRECATED_VERSION, deprecatedVersion);
    }

    public String getType() {
        return "LicenseException";
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        String id = this.getLicenseExceptionId();
        if (id == null || id.isEmpty()) {
            retval.add("Missing required exception ID");
        }
        try {
            String name = this.getName();
            if (name == null || name.isEmpty()) {
                retval.add("Missing required exception name");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for name");
        }
        try {
            this.getComment();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for comment");
        }
        try {
            this.getSeeAlso();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for seeAlso");
        }
        try {
            this.getLicenseExceptionTemplate();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for exception template");
        }
        try {
            String exceptionText = this.getLicenseExceptionText();
            if (exceptionText == null || exceptionText.trim().isEmpty()) {
                retval.add("Missing required exception text for " + id);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for exception text");
        }
        return retval;
    }

    @Override
    public String toString() {
        return this.getId();
    }
}

