/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2.pointer;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.SpdxInvalidTypeException;
import org.spdx.library.model.v2.ModelObjectV2;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxElement;
import org.spdx.storage.IModelStore;

public abstract class SinglePointer
extends ModelObjectV2
implements Comparable<SinglePointer> {
    static final Logger logger = LoggerFactory.getLogger(SinglePointer.class);

    public SinglePointer() throws InvalidSPDXAnalysisException {
    }

    public SinglePointer(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public SinglePointer(IModelStore modelStore, String documentUri, String id, IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    @Nullable
    public SpdxElement getReference() throws InvalidSPDXAnalysisException {
        Optional retval = this.getObjectPropertyValue(SpdxConstantsCompatV2.PROP_POINTER_REFERENCE);
        if (!retval.isPresent()) {
            return null;
        }
        if (!(retval.get() instanceof SpdxElement)) {
            throw new SpdxInvalidTypeException("Invalid type for reference.  Expect SpdxElement, found " + retval.get().getClass().toString());
        }
        return (SpdxElement)((Object)retval.get());
    }

    public void setReference(SpdxElement reference) throws InvalidSPDXAnalysisException {
        if (this.strict && Objects.isNull((Object)reference)) {
            throw new InvalidSPDXAnalysisException("Can not set required reference to null");
        }
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_POINTER_REFERENCE, (Object)reference);
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            SpdxElement reference = this.getReference();
            if (Objects.isNull((Object)reference)) {
                retval.add("Missing required reference field");
            } else {
                retval.addAll(reference.verify(verifiedIds, specVersion));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting reference: " + e.getMessage());
        }
        return retval;
    }

    protected int compareReferences(SinglePointer o) {
        if (o == null) {
            return 1;
        }
        SpdxElement compRef = null;
        try {
            compRef = o.getReference();
            SpdxElement reference = this.getReference();
            if (reference == null) {
                if (compRef == null) {
                    return 0;
                }
                return -1;
            }
            if (compRef == null) {
                return 1;
            }
            String myName = "";
            try {
                Optional<String> name = reference.getName();
                if (name.isPresent()) {
                    myName = name.get();
                }
            }
            catch (InvalidSPDXAnalysisException ex) {
                logger.warn("Error getting reference name", (Throwable)ex);
            }
            String compName = "";
            try {
                Optional<String> cName = compRef.getName();
                if (cName.isPresent()) {
                    compName = cName.get();
                }
            }
            catch (InvalidSPDXAnalysisException ex) {
                logger.warn("Error getting compare name", (Throwable)ex);
            }
            return myName.compareTo(compName);
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting comparison reference element", (Throwable)e);
            return -1;
        }
    }
}

