/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.spdx.core.CoreModelObject;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.ISpdxModelInfo;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.SpdxEnumFactory;
import org.spdx.library.model.v3_0_1.SpdxIndividualFactory;
import org.spdx.library.model.v3_0_1.SpdxModelClassFactoryV3;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalElement;
import org.spdx.storage.IModelStore;

public class SpdxModelInfoV3_0
implements ISpdxModelInfo {
    public Map<String, Enum<?>> getUriToEnumMap() {
        return SpdxEnumFactory.uriToEnum;
    }

    public List<String> getSpecVersions() {
        return Arrays.asList("SPDX-3.0", "3.0.1");
    }

    public CoreModelObject createExternalElement(IModelStore store, String uri, IModelCopyManager copyManager, Class<?> typeClass, String specVersion) throws InvalidSPDXAnalysisException {
        if (Objects.nonNull(typeClass)) {
            if (!this.canBeExternal(typeClass)) {
                throw new InvalidSPDXAnalysisException(typeClass.toString() + "Can not be an external type");
            }
            String[] typeParts = SpdxModelClassFactoryV3.SPDX_CLASS_TO_TYPE.get(typeClass).split("\\.");
            String type = typeParts[0] + ".External" + typeParts[1];
            return SpdxModelClassFactoryV3.getModelObject(store, uri, type, copyManager, true, "");
        }
        return new ExternalElement(uri);
    }

    @Nullable
    public Object uriToIndividual(String uri, @Nullable Class<?> type) {
        return SpdxIndividualFactory.uriToIndividual.get(uri);
    }

    public CoreModelObject createModelObject(IModelStore modelStore, String objectUri, String type, IModelCopyManager copyManager, String specVersion, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        return SpdxModelClassFactoryV3.getModelObject(modelStore, objectUri, type, copyManager, create, idPrefix);
    }

    public Map<String, Class<?>> getTypeToClassMap() {
        return SpdxModelClassFactoryV3.SPDX_TYPE_TO_CLASS_V3;
    }

    public boolean canBeExternal(Class<?> clazz) {
        return Element.class.isAssignableFrom(clazz);
    }
}

