/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.storage.IModelStore;

public abstract class Element
extends ModelObjectV3 {
    Collection<ExternalRef> externalRefs = Collections.emptyList();
    Collection<Extension> extensions = Collections.emptyList();
    Collection<IntegrityMethod> verifiedUsings = Collections.emptyList();
    Collection<ExternalIdentifier> externalIdentifiers = Collections.emptyList();

    public Element() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public Element(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public Element(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.externalRefs = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_EXTERNAL_REF, ExternalRef.class);
        }
        if (!this.isExternal()) {
            this.extensions = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_EXTENSION, Extension.class);
        }
        if (!this.isExternal()) {
            this.verifiedUsings = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_VERIFIED_USING, IntegrityMethod.class);
        }
        if (!this.isExternal()) {
            this.externalIdentifiers = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_EXTERNAL_IDENTIFIER, ExternalIdentifier.class);
        }
    }

    protected Element(ElementBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.externalRefs = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_EXTERNAL_REF, ExternalRef.class);
        this.extensions = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_EXTENSION, Extension.class);
        this.verifiedUsings = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_VERIFIED_USING, IntegrityMethod.class);
        this.externalIdentifiers = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_EXTERNAL_IDENTIFIER, ExternalIdentifier.class);
        this.getExternalRefs().addAll(builder.externalRefs);
        this.getExtensions().addAll(builder.extensions);
        this.getVerifiedUsings().addAll(builder.verifiedUsings);
        this.getExternalIdentifiers().addAll(builder.externalIdentifiers);
        if (Objects.nonNull((Object)builder.creationInfo)) {
            this.setCreationInfo(builder.creationInfo);
        }
        this.setSummary(builder.summary);
        this.setComment(builder.comment);
        this.setName(builder.name);
        this.setDescription(builder.description);
    }

    public String getType() {
        return "Core.Element";
    }

    public Collection<ExternalRef> getExternalRefs() {
        return this.externalRefs;
    }

    public Collection<Extension> getExtensions() {
        return this.extensions;
    }

    public Collection<IntegrityMethod> getVerifiedUsings() {
        return this.verifiedUsings;
    }

    public Collection<ExternalIdentifier> getExternalIdentifiers() {
        return this.externalIdentifiers;
    }

    @Nullable
    public CreationInfo getCreationInfo() throws InvalidSPDXAnalysisException {
        Optional retval = this.getObjectPropertyValue(SpdxConstantsV3.PROP_CREATION_INFO);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof CreationInfo)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for creationInfo");
            }
            return (CreationInfo)((Object)retval.get());
        }
        return null;
    }

    public Element setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull((Object)creationInfo)) {
            throw new InvalidSPDXAnalysisException("creationInfo is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_CREATION_INFO, (Object)creationInfo);
        return this;
    }

    public Optional<String> getSummary() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_SUMMARY);
    }

    public Element setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_SUMMARY, summary);
        return this;
    }

    public Optional<String> getComment() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_COMMENT);
    }

    public Element setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_COMMENT, comment);
        return this;
    }

    public Optional<String> getName() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_NAME);
    }

    public Element setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_NAME, name);
        return this;
    }

    public Optional<String> getDescription() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_DESCRIPTION);
    }

    public Element setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_DESCRIPTION, description);
        return this;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            Optional<String> name = this.getName();
            if (name.isPresent()) {
                sb.append(name.get());
            } else {
                sb.append("[Name Missing]");
            }
            sb.append(":");
            sb.append(this.getType());
            sb.append('(');
            sb.append(this.getObjectUri());
            sb.append(')');
            return sb.toString();
        }
        catch (InvalidSPDXAnalysisException e) {
            return "Error: " + e.getMessage();
        }
    }

    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        Optional<String> e2;
        ArrayList<String> retval = new ArrayList<String>();
        try {
            CreationInfo creationInfo = this.getCreationInfo();
            if (Objects.nonNull((Object)creationInfo)) {
                retval.addAll(creationInfo.verify(verifiedIds, specVersionForVerify, profiles));
            } else if (!Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.CORE))) {
                retval.add("Missing creationInfo in Element");
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval.add("Error getting creationInfo for Element: " + e2.getMessage());
        }
        try {
            e2 = this.getSummary();
        }
        catch (InvalidSPDXAnalysisException e3) {
            retval.add("Error getting summary for Element: " + e3.getMessage());
        }
        try {
            e2 = this.getComment();
        }
        catch (InvalidSPDXAnalysisException e4) {
            retval.add("Error getting comment for Element: " + e4.getMessage());
        }
        try {
            e2 = this.getName();
        }
        catch (InvalidSPDXAnalysisException e5) {
            retval.add("Error getting name for Element: " + e5.getMessage());
        }
        try {
            e2 = this.getDescription();
        }
        catch (InvalidSPDXAnalysisException e6) {
            retval.add("Error getting description for Element: " + e6.getMessage());
        }
        for (ExternalRef externalRef : this.externalRefs) {
            retval.addAll(externalRef.verify(verifiedIds, specVersionForVerify, profiles));
        }
        for (Extension extension : this.extensions) {
            retval.addAll(extension.verify(verifiedIds, specVersionForVerify, profiles));
        }
        for (IntegrityMethod verifiedUsing : this.verifiedUsings) {
            retval.addAll(verifiedUsing.verify(verifiedIds, specVersionForVerify, profiles));
        }
        for (ExternalIdentifier externalIdentifier : this.externalIdentifiers) {
            retval.addAll(externalIdentifier.verify(verifiedIds, specVersionForVerify, profiles));
        }
        return retval;
    }

    public static abstract class ElementBuilder
    extends ModelObjectV3.ModelObjectV3Builder {
        protected Collection<ExternalRef> externalRefs = new ArrayList<ExternalRef>();
        protected Collection<Extension> extensions = new ArrayList<Extension>();
        protected Collection<IntegrityMethod> verifiedUsings = new ArrayList<IntegrityMethod>();
        protected Collection<ExternalIdentifier> externalIdentifiers = new ArrayList<ExternalIdentifier>();
        protected CreationInfo creationInfo = null;
        protected String summary = null;
        protected String comment = null;
        protected String name = null;
        protected String description = null;

        public ElementBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public ElementBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public ElementBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        public ElementBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        public ElementBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        public ElementBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        public ElementBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        public ElementBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        public ElementBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        public ElementBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        public ElementBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        public ElementBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        public ElementBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public ElementBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public ElementBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public ElementBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public abstract Element build() throws InvalidSPDXAnalysisException;
    }
}

