/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifierType;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.storage.IModelStore;

public class ExternalIdentifier
extends ModelObjectV3 {
    Collection<String> identifierLocators = Collections.emptyList();

    public ExternalIdentifier() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public ExternalIdentifier(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public ExternalIdentifier(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.identifierLocators = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_IDENTIFIER_LOCATOR, String.class);
        }
    }

    protected ExternalIdentifier(ExternalIdentifierBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.identifierLocators = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_IDENTIFIER_LOCATOR, String.class);
        this.getIdentifierLocators().addAll(builder.identifierLocators);
        if (Objects.nonNull((Object)builder.externalIdentifierType)) {
            this.setExternalIdentifierType(builder.externalIdentifierType);
        }
        if (Objects.nonNull(builder.identifier)) {
            this.setIdentifier(builder.identifier);
        }
        this.setComment(builder.comment);
        this.setIssuingAuthority(builder.issuingAuthority);
    }

    public String getType() {
        return "Core.ExternalIdentifier";
    }

    public Collection<String> getIdentifierLocators() {
        return this.identifierLocators;
    }

    @Nullable
    public ExternalIdentifierType getExternalIdentifierType() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_EXTERNAL_IDENTIFIER_TYPE);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof ExternalIdentifierType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for externalIdentifierType");
            }
            return (ExternalIdentifierType)((Object)retval.get());
        }
        return null;
    }

    public ExternalIdentifier setExternalIdentifierType(@Nullable ExternalIdentifierType externalIdentifierType) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull((Object)externalIdentifierType)) {
            throw new InvalidSPDXAnalysisException("externalIdentifierType is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_EXTERNAL_IDENTIFIER_TYPE, (Object)externalIdentifierType);
        return this;
    }

    @Nullable
    public String getIdentifier() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_IDENTIFIER);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public ExternalIdentifier setIdentifier(@Nullable String identifier) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(identifier)) {
            throw new InvalidSPDXAnalysisException("identifier is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_IDENTIFIER, identifier);
        return this;
    }

    public Optional<String> getComment() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_COMMENT);
    }

    public ExternalIdentifier setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_COMMENT, comment);
        return this;
    }

    public Optional<String> getIssuingAuthority() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_ISSUING_AUTHORITY);
    }

    public ExternalIdentifier setIssuingAuthority(@Nullable String issuingAuthority) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_ISSUING_AUTHORITY, issuingAuthority);
        return this;
    }

    public String toString() {
        return "ExternalIdentifier: " + this.getObjectUri();
    }

    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        Optional<String> e3;
        ArrayList<String> retval = new ArrayList<String>();
        try {
            ExternalIdentifierType externalIdentifierType = this.getExternalIdentifierType();
            if (Objects.isNull((Object)externalIdentifierType) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.CORE))) {
                retval.add("Missing externalIdentifierType in ExternalIdentifier");
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval.add("Error getting externalIdentifierType for ExternalIdentifier: " + e2.getMessage());
        }
        try {
            String identifier = this.getIdentifier();
            if (Objects.isNull(identifier) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.CORE))) {
                retval.add("Missing identifier in ExternalIdentifier");
            }
        }
        catch (InvalidSPDXAnalysisException e3) {
            retval.add("Error getting identifier for ExternalIdentifier: " + e3.getMessage());
        }
        try {
            e3 = this.getComment();
        }
        catch (InvalidSPDXAnalysisException e4) {
            retval.add("Error getting comment for ExternalIdentifier: " + e4.getMessage());
        }
        try {
            e3 = this.getIssuingAuthority();
        }
        catch (InvalidSPDXAnalysisException e5) {
            retval.add("Error getting issuingAuthority for ExternalIdentifier: " + e5.getMessage());
        }
        return retval;
    }

    public static class ExternalIdentifierBuilder
    extends ModelObjectV3.ModelObjectV3Builder {
        protected Collection<String> identifierLocators = new ArrayList<String>();
        protected ExternalIdentifierType externalIdentifierType = null;
        protected String identifier = null;
        protected String comment = null;
        protected String issuingAuthority = null;

        public ExternalIdentifierBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public ExternalIdentifierBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
        }

        public ExternalIdentifierBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        public ExternalIdentifierBuilder addIdentifierLocator(String identifierLocator) {
            if (Objects.nonNull(identifierLocator)) {
                this.identifierLocators.add(identifierLocator);
            }
            return this;
        }

        public ExternalIdentifierBuilder addAllIdentifierLocator(Collection<String> identifierLocatorCollection) {
            if (Objects.nonNull(identifierLocatorCollection)) {
                this.identifierLocators.addAll(identifierLocatorCollection);
            }
            return this;
        }

        public ExternalIdentifierBuilder setExternalIdentifierType(ExternalIdentifierType externalIdentifierType) {
            this.externalIdentifierType = externalIdentifierType;
            return this;
        }

        public ExternalIdentifierBuilder setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public ExternalIdentifierBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public ExternalIdentifierBuilder setIssuingAuthority(String issuingAuthority) {
            this.issuingAuthority = issuingAuthority;
            return this;
        }

        public ExternalIdentifier build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                ExternalIdentifier externalIdentifier = new ExternalIdentifier(this);
                return externalIdentifier;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

