/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.storage.IModelStore;

public abstract class IntegrityMethod
extends ModelObjectV3 {
    public IntegrityMethod() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public IntegrityMethod(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public IntegrityMethod(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected IntegrityMethod(IntegrityMethodBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.setComment(builder.comment);
    }

    public String getType() {
        return "Core.IntegrityMethod";
    }

    public Optional<String> getComment() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_COMMENT);
    }

    public IntegrityMethod setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_COMMENT, comment);
        return this;
    }

    public String toString() {
        return "IntegrityMethod: " + this.getObjectUri();
    }

    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            Optional<String> optional = this.getComment();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting comment for IntegrityMethod: " + e.getMessage());
        }
        return retval;
    }

    public static abstract class IntegrityMethodBuilder
    extends ModelObjectV3.ModelObjectV3Builder {
        protected String comment = null;

        public IntegrityMethodBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public IntegrityMethodBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
        }

        public IntegrityMethodBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        public IntegrityMethodBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public abstract IntegrityMethod build() throws InvalidSPDXAnalysisException;
    }
}

