/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.LifecycleScopeType;
import org.spdx.library.model.v3_0_1.core.Relationship;
import org.spdx.library.model.v3_0_1.core.RelationshipCompleteness;
import org.spdx.library.model.v3_0_1.core.RelationshipType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.storage.IModelStore;

public class LifecycleScopedRelationship
extends Relationship {
    public LifecycleScopedRelationship() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public LifecycleScopedRelationship(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public LifecycleScopedRelationship(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected LifecycleScopedRelationship(LifecycleScopedRelationshipBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.setScope(builder.scope);
    }

    @Override
    public String getType() {
        return "Core.LifecycleScopedRelationship";
    }

    @Override
    public LifecycleScopedRelationship setFrom(@Nullable Element from) throws InvalidSPDXAnalysisException {
        super.setFrom(from);
        return this;
    }

    @Override
    public LifecycleScopedRelationship setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public LifecycleScopedRelationship setCompleteness(@Nullable RelationshipCompleteness completeness) throws InvalidSPDXAnalysisException {
        super.setCompleteness(completeness);
        return this;
    }

    public Optional<LifecycleScopeType> getScope() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_SCOPE);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof LifecycleScopeType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for scope");
            }
            return retval;
        }
        return Optional.empty();
    }

    public LifecycleScopedRelationship setScope(@Nullable LifecycleScopeType scope) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_SCOPE, (Object)scope);
        return this;
    }

    @Override
    public LifecycleScopedRelationship setRelationshipType(@Nullable RelationshipType relationshipType) throws InvalidSPDXAnalysisException {
        super.setRelationshipType(relationshipType);
        return this;
    }

    @Override
    public LifecycleScopedRelationship setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public LifecycleScopedRelationship setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public LifecycleScopedRelationship setEndTime(@Nullable String endTime) throws InvalidSPDXAnalysisException {
        super.setEndTime(endTime);
        return this;
    }

    @Override
    public LifecycleScopedRelationship setStartTime(@Nullable String startTime) throws InvalidSPDXAnalysisException {
        super.setStartTime(startTime);
        return this;
    }

    @Override
    public LifecycleScopedRelationship setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public LifecycleScopedRelationship setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Optional<LifecycleScopeType> optional = this.getScope();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting scope for LifecycleScopedRelationship: " + e.getMessage());
        }
        return retval;
    }

    public static class LifecycleScopedRelationshipBuilder
    extends Relationship.RelationshipBuilder {
        protected LifecycleScopeType scope = null;

        public LifecycleScopedRelationshipBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public LifecycleScopedRelationshipBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public LifecycleScopedRelationshipBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public LifecycleScopedRelationshipBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder addTo(Element to) {
            if (Objects.nonNull((Object)to)) {
                this.tos.add(to);
            }
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder addAllTo(Collection<Element> toCollection) {
            if (Objects.nonNull(toCollection)) {
                this.tos.addAll(toCollection);
            }
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder setFrom(Element from) {
            this.from = from;
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder setCompleteness(RelationshipCompleteness completeness) {
            this.completeness = completeness;
            return this;
        }

        public LifecycleScopedRelationshipBuilder setScope(LifecycleScopeType scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder setRelationshipType(RelationshipType relationshipType) {
            this.relationshipType = relationshipType;
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder setEndTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder setStartTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public LifecycleScopedRelationshipBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public LifecycleScopedRelationship build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                LifecycleScopedRelationship lifecycleScopedRelationship = new LifecycleScopedRelationship(this);
                return lifecycleScopedRelationship;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

