/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ElementCollection;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalMap;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.NamespaceMap;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo;
import org.spdx.storage.IModelStore;

public class SpdxDocument
extends ElementCollection {
    Collection<ExternalMap> spdxImports = Collections.emptyList();
    Collection<NamespaceMap> namespaceMaps = Collections.emptyList();

    public SpdxDocument() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public SpdxDocument(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public SpdxDocument(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.spdxImports = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_SPDX_IMPORT, ExternalMap.class);
        }
        if (!this.isExternal()) {
            this.namespaceMaps = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_NAMESPACE_MAP, NamespaceMap.class);
        }
    }

    protected SpdxDocument(SpdxDocumentBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.spdxImports = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_SPDX_IMPORT, ExternalMap.class);
        this.namespaceMaps = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_NAMESPACE_MAP, NamespaceMap.class);
        this.getSpdxImports().addAll(builder.spdxImports);
        this.getNamespaceMaps().addAll(builder.namespaceMaps);
        this.setDataLicense(builder.dataLicense);
    }

    @Override
    public String getType() {
        return "Core.SpdxDocument";
    }

    public Collection<ExternalMap> getSpdxImports() {
        return this.spdxImports;
    }

    public Collection<NamespaceMap> getNamespaceMaps() {
        return this.namespaceMaps;
    }

    @Override
    public SpdxDocument setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    public Optional<AnyLicenseInfo> getDataLicense() throws InvalidSPDXAnalysisException {
        Optional retval = this.getObjectPropertyValue(SpdxConstantsV3.PROP_DATA_LICENSE);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof AnyLicenseInfo)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for dataLicense");
            }
            return retval;
        }
        return Optional.empty();
    }

    public SpdxDocument setDataLicense(@Nullable AnyLicenseInfo dataLicense) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_DATA_LICENSE, (Object)dataLicense);
        return this;
    }

    @Override
    public SpdxDocument setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public SpdxDocument setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public SpdxDocument setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public SpdxDocument setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Optional<AnyLicenseInfo> dataLicense = this.getDataLicense();
            if (dataLicense.isPresent()) {
                retval.addAll(dataLicense.get().verify(verifiedIds, specVersionForVerify, profiles));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting dataLicense for SpdxDocument: " + e.getMessage());
        }
        for (ExternalMap spdxImport : this.spdxImports) {
            retval.addAll(spdxImport.verify(verifiedIds, specVersionForVerify, profiles));
        }
        for (NamespaceMap namespaceMap : this.namespaceMaps) {
            retval.addAll(namespaceMap.verify(verifiedIds, specVersionForVerify, profiles));
        }
        return retval;
    }

    public static class SpdxDocumentBuilder
    extends ElementCollection.ElementCollectionBuilder {
        protected Collection<ExternalMap> spdxImports = new ArrayList<ExternalMap>();
        protected Collection<NamespaceMap> namespaceMaps = new ArrayList<NamespaceMap>();
        protected AnyLicenseInfo dataLicense = null;

        public SpdxDocumentBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public SpdxDocumentBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public SpdxDocumentBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public SpdxDocumentBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public SpdxDocumentBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public SpdxDocumentBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public SpdxDocumentBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public SpdxDocumentBuilder addRootElement(Element rootElement) {
            if (Objects.nonNull((Object)rootElement)) {
                this.rootElements.add(rootElement);
            }
            return this;
        }

        @Override
        public SpdxDocumentBuilder addAllRootElement(Collection<Element> rootElementCollection) {
            if (Objects.nonNull(rootElementCollection)) {
                this.rootElements.addAll(rootElementCollection);
            }
            return this;
        }

        @Override
        public SpdxDocumentBuilder addElement(Element element) {
            if (Objects.nonNull((Object)element)) {
                this.elements.add(element);
            }
            return this;
        }

        @Override
        public SpdxDocumentBuilder addAllElement(Collection<Element> elementCollection) {
            if (Objects.nonNull(elementCollection)) {
                this.elements.addAll(elementCollection);
            }
            return this;
        }

        @Override
        public SpdxDocumentBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public SpdxDocumentBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        public SpdxDocumentBuilder addSpdxImport(ExternalMap spdxImport) {
            if (Objects.nonNull((Object)spdxImport)) {
                this.spdxImports.add(spdxImport);
            }
            return this;
        }

        public SpdxDocumentBuilder addAllSpdxImport(Collection<ExternalMap> spdxImportCollection) {
            if (Objects.nonNull(spdxImportCollection)) {
                this.spdxImports.addAll(spdxImportCollection);
            }
            return this;
        }

        public SpdxDocumentBuilder addNamespaceMap(NamespaceMap namespaceMap) {
            if (Objects.nonNull((Object)namespaceMap)) {
                this.namespaceMaps.add(namespaceMap);
            }
            return this;
        }

        public SpdxDocumentBuilder addAllNamespaceMap(Collection<NamespaceMap> namespaceMapCollection) {
            if (Objects.nonNull(namespaceMapCollection)) {
                this.namespaceMaps.addAll(namespaceMapCollection);
            }
            return this;
        }

        @Override
        public SpdxDocumentBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public SpdxDocumentBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public SpdxDocumentBuilder addProfileConformance(ProfileIdentifierType profileConformance) {
            if (Objects.nonNull((Object)profileConformance)) {
                this.profileConformances.add(profileConformance);
            }
            return this;
        }

        @Override
        public SpdxDocumentBuilder addAllProfileConformance(Collection<ProfileIdentifierType> profileConformanceCollection) {
            if (Objects.nonNull(profileConformanceCollection)) {
                this.profileConformances.addAll(profileConformanceCollection);
            }
            return this;
        }

        @Override
        public SpdxDocumentBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        public SpdxDocumentBuilder setDataLicense(AnyLicenseInfo dataLicense) {
            this.dataLicense = dataLicense;
            return this;
        }

        @Override
        public SpdxDocumentBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public SpdxDocumentBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public SpdxDocumentBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public SpdxDocumentBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public SpdxDocument build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                SpdxDocument spdxDocument = new SpdxDocument(this);
                return spdxDocument;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

