/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.DictionaryEntry;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.PresenceType;
import org.spdx.library.model.v3_0_1.core.SupportType;
import org.spdx.library.model.v3_0_1.dataset.ConfidentialityLevelType;
import org.spdx.library.model.v3_0_1.dataset.DatasetAvailabilityType;
import org.spdx.library.model.v3_0_1.dataset.DatasetType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.software.ContentIdentifier;
import org.spdx.library.model.v3_0_1.software.SoftwarePurpose;
import org.spdx.library.model.v3_0_1.software.SpdxPackage;
import org.spdx.storage.IModelStore;

public class DatasetPackage
extends SpdxPackage {
    Collection<DictionaryEntry> sensors = Collections.emptyList();
    Collection<String> anonymizationMethodUseds = Collections.emptyList();
    Collection<String> knownBiass = Collections.emptyList();
    Collection<String> dataPreprocessings = Collections.emptyList();
    Collection<DatasetType> datasetTypes = Collections.emptyList();

    public DatasetPackage() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public DatasetPackage(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public DatasetPackage(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.sensors = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_SENSOR, DictionaryEntry.class);
        }
        if (!this.isExternal()) {
            this.datasetTypes = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_DATASET_TYPE, DatasetType.class);
        }
        if (!this.isExternal()) {
            this.anonymizationMethodUseds = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ANONYMIZATION_METHOD_USED, String.class);
        }
        if (!this.isExternal()) {
            this.knownBiass = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_KNOWN_BIAS, String.class);
        }
        if (!this.isExternal()) {
            this.dataPreprocessings = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_DATA_PREPROCESSING, String.class);
        }
    }

    protected DatasetPackage(DatasetPackageBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.sensors = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_SENSOR, DictionaryEntry.class);
        this.datasetTypes = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_DATASET_TYPE, DatasetType.class);
        this.anonymizationMethodUseds = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ANONYMIZATION_METHOD_USED, String.class);
        this.knownBiass = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_KNOWN_BIAS, String.class);
        this.dataPreprocessings = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_DATA_PREPROCESSING, String.class);
        this.getSensors().addAll(builder.sensors);
        this.getDatasetTypes().addAll(builder.datasetTypes);
        this.getAnonymizationMethodUseds().addAll(builder.anonymizationMethodUseds);
        this.getKnownBiass().addAll(builder.knownBiass);
        this.getDataPreprocessings().addAll(builder.dataPreprocessings);
        this.setDatasetAvailability(builder.datasetAvailability);
        this.setConfidentialityLevel(builder.confidentialityLevel);
        this.setHasSensitivePersonalInformation(builder.hasSensitivePersonalInformation);
        this.setDatasetSize(builder.datasetSize);
        this.setDatasetNoise(builder.datasetNoise);
        this.setIntendedUse(builder.intendedUse);
        this.setDataCollectionProcess(builder.dataCollectionProcess);
        this.setDatasetUpdateMechanism(builder.datasetUpdateMechanism);
    }

    @Override
    public String getType() {
        return "Dataset.DatasetPackage";
    }

    public Collection<DictionaryEntry> getSensors() {
        return this.sensors;
    }

    public Collection<DatasetType> getDatasetTypes() {
        return this.datasetTypes;
    }

    public Collection<String> getAnonymizationMethodUseds() {
        return this.anonymizationMethodUseds;
    }

    public Collection<String> getKnownBiass() {
        return this.knownBiass;
    }

    public Collection<String> getDataPreprocessings() {
        return this.dataPreprocessings;
    }

    @Override
    public DatasetPackage setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public DatasetPackage setSuppliedBy(@Nullable Agent suppliedBy) throws InvalidSPDXAnalysisException {
        super.setSuppliedBy(suppliedBy);
        return this;
    }

    public Optional<DatasetAvailabilityType> getDatasetAvailability() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_DATASET_AVAILABILITY);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof DatasetAvailabilityType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for datasetAvailability");
            }
            return retval;
        }
        return Optional.empty();
    }

    public DatasetPackage setDatasetAvailability(@Nullable DatasetAvailabilityType datasetAvailability) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_DATASET_AVAILABILITY, (Object)datasetAvailability);
        return this;
    }

    public Optional<ConfidentialityLevelType> getConfidentialityLevel() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_CONFIDENTIALITY_LEVEL);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof ConfidentialityLevelType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for confidentialityLevel");
            }
            return retval;
        }
        return Optional.empty();
    }

    public DatasetPackage setConfidentialityLevel(@Nullable ConfidentialityLevelType confidentialityLevel) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_CONFIDENTIALITY_LEVEL, (Object)confidentialityLevel);
        return this;
    }

    public Optional<PresenceType> getHasSensitivePersonalInformation() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_HAS_SENSITIVE_PERSONAL_INFORMATION);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof PresenceType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for hasSensitivePersonalInformation");
            }
            return retval;
        }
        return Optional.empty();
    }

    public DatasetPackage setHasSensitivePersonalInformation(@Nullable PresenceType hasSensitivePersonalInformation) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_HAS_SENSITIVE_PERSONAL_INFORMATION, (Object)hasSensitivePersonalInformation);
        return this;
    }

    @Override
    public DatasetPackage setPrimaryPurpose(@Nullable SoftwarePurpose primaryPurpose) throws InvalidSPDXAnalysisException {
        super.setPrimaryPurpose(primaryPurpose);
        return this;
    }

    public Optional<Integer> getDatasetSize() throws InvalidSPDXAnalysisException {
        return this.getIntegerPropertyValue(SpdxConstantsV3.PROP_DATASET_SIZE);
    }

    public DatasetPackage setDatasetSize(@Nullable Integer datasetSize) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.nonNull(datasetSize) && datasetSize < 0) {
            throw new InvalidSPDXAnalysisException("datasetSize value " + datasetSize + " is less than the minimum 0 in DatasetPackage");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_DATASET_SIZE, datasetSize);
        return this;
    }

    @Override
    public DatasetPackage setValidUntilTime(@Nullable String validUntilTime) throws InvalidSPDXAnalysisException {
        super.setValidUntilTime(validUntilTime);
        return this;
    }

    @Override
    public DatasetPackage setDownloadLocation(@Nullable String downloadLocation) throws InvalidSPDXAnalysisException {
        super.setDownloadLocation(downloadLocation);
        return this;
    }

    @Override
    public DatasetPackage setBuiltTime(@Nullable String builtTime) throws InvalidSPDXAnalysisException {
        super.setBuiltTime(builtTime);
        return this;
    }

    public Optional<String> getDatasetNoise() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_DATASET_NOISE);
    }

    public DatasetPackage setDatasetNoise(@Nullable String datasetNoise) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_DATASET_NOISE, datasetNoise);
        return this;
    }

    @Override
    public DatasetPackage setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public DatasetPackage setPackageVersion(@Nullable String packageVersion) throws InvalidSPDXAnalysisException {
        super.setPackageVersion(packageVersion);
        return this;
    }

    @Override
    public DatasetPackage setReleaseTime(@Nullable String releaseTime) throws InvalidSPDXAnalysisException {
        super.setReleaseTime(releaseTime);
        return this;
    }

    @Override
    public DatasetPackage setCopyrightText(@Nullable String copyrightText) throws InvalidSPDXAnalysisException {
        super.setCopyrightText(copyrightText);
        return this;
    }

    @Override
    public DatasetPackage setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public DatasetPackage setHomePage(@Nullable String homePage) throws InvalidSPDXAnalysisException {
        super.setHomePage(homePage);
        return this;
    }

    @Override
    public DatasetPackage setSourceInfo(@Nullable String sourceInfo) throws InvalidSPDXAnalysisException {
        super.setSourceInfo(sourceInfo);
        return this;
    }

    public Optional<String> getIntendedUse() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_INTENDED_USE);
    }

    public DatasetPackage setIntendedUse(@Nullable String intendedUse) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_INTENDED_USE, intendedUse);
        return this;
    }

    @Override
    public DatasetPackage setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    public Optional<String> getDataCollectionProcess() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_DATA_COLLECTION_PROCESS);
    }

    public DatasetPackage setDataCollectionProcess(@Nullable String dataCollectionProcess) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_DATA_COLLECTION_PROCESS, dataCollectionProcess);
        return this;
    }

    public Optional<String> getDatasetUpdateMechanism() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_DATASET_UPDATE_MECHANISM);
    }

    public DatasetPackage setDatasetUpdateMechanism(@Nullable String datasetUpdateMechanism) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_DATASET_UPDATE_MECHANISM, datasetUpdateMechanism);
        return this;
    }

    @Override
    public DatasetPackage setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public DatasetPackage setPackageUrl(@Nullable String packageUrl) throws InvalidSPDXAnalysisException {
        super.setPackageUrl(packageUrl);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        Optional<Object> e2;
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Optional<DatasetAvailabilityType> optional = this.getDatasetAvailability();
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval.add("Error getting datasetAvailability for DatasetPackage: " + e2.getMessage());
        }
        try {
            e2 = this.getConfidentialityLevel();
        }
        catch (InvalidSPDXAnalysisException e3) {
            retval.add("Error getting confidentialityLevel for DatasetPackage: " + e3.getMessage());
        }
        try {
            e2 = this.getHasSensitivePersonalInformation();
        }
        catch (InvalidSPDXAnalysisException e4) {
            retval.add("Error getting hasSensitivePersonalInformation for DatasetPackage: " + e4.getMessage());
        }
        try {
            Optional<Integer> datasetSize = this.getDatasetSize();
            if (datasetSize.isPresent() && datasetSize.get() < 0) {
                retval.add("datasetSize value " + datasetSize.get() + " is less than the minimum 0 in DatasetPackage");
            }
        }
        catch (InvalidSPDXAnalysisException e5) {
            retval.add("Error getting datasetSize for DatasetPackage: " + e5.getMessage());
        }
        try {
            e2 = this.getDatasetNoise();
        }
        catch (InvalidSPDXAnalysisException e6) {
            retval.add("Error getting datasetNoise for DatasetPackage: " + e6.getMessage());
        }
        try {
            e2 = this.getIntendedUse();
        }
        catch (InvalidSPDXAnalysisException e7) {
            retval.add("Error getting intendedUse for DatasetPackage: " + e7.getMessage());
        }
        try {
            e2 = this.getDataCollectionProcess();
        }
        catch (InvalidSPDXAnalysisException e8) {
            retval.add("Error getting dataCollectionProcess for DatasetPackage: " + e8.getMessage());
        }
        try {
            e2 = this.getDatasetUpdateMechanism();
        }
        catch (InvalidSPDXAnalysisException e9) {
            retval.add("Error getting datasetUpdateMechanism for DatasetPackage: " + e9.getMessage());
        }
        for (DictionaryEntry sensor : this.sensors) {
            retval.addAll(sensor.verify(verifiedIds, specVersionForVerify, profiles));
        }
        return retval;
    }

    public static class DatasetPackageBuilder
    extends SpdxPackage.SpdxPackageBuilder {
        protected Collection<DictionaryEntry> sensors = new ArrayList<DictionaryEntry>();
        protected Collection<DatasetType> datasetTypes = new ArrayList<DatasetType>();
        protected Collection<String> anonymizationMethodUseds = new ArrayList<String>();
        protected Collection<String> knownBiass = new ArrayList<String>();
        protected Collection<String> dataPreprocessings = new ArrayList<String>();
        protected DatasetAvailabilityType datasetAvailability = null;
        protected ConfidentialityLevelType confidentialityLevel = null;
        protected PresenceType hasSensitivePersonalInformation = null;
        protected Integer datasetSize = null;
        protected String datasetNoise = null;
        protected String intendedUse = null;
        protected String dataCollectionProcess = null;
        protected String datasetUpdateMechanism = null;

        public DatasetPackageBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public DatasetPackageBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public DatasetPackageBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public DatasetPackageBuilder addContentIdentifier(ContentIdentifier contentIdentifier) {
            if (Objects.nonNull((Object)contentIdentifier)) {
                this.contentIdentifiers.add(contentIdentifier);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addAllContentIdentifier(Collection<ContentIdentifier> contentIdentifierCollection) {
            if (Objects.nonNull(contentIdentifierCollection)) {
                this.contentIdentifiers.addAll(contentIdentifierCollection);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        public DatasetPackageBuilder addSensor(DictionaryEntry sensor) {
            if (Objects.nonNull((Object)sensor)) {
                this.sensors.add(sensor);
            }
            return this;
        }

        public DatasetPackageBuilder addAllSensor(Collection<DictionaryEntry> sensorCollection) {
            if (Objects.nonNull(sensorCollection)) {
                this.sensors.addAll(sensorCollection);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addOriginatedBy(Agent originatedBy) {
            if (Objects.nonNull((Object)originatedBy)) {
                this.originatedBys.add(originatedBy);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addAllOriginatedBy(Collection<Agent> originatedByCollection) {
            if (Objects.nonNull(originatedByCollection)) {
                this.originatedBys.addAll(originatedByCollection);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addSupportLevel(SupportType supportLevel) {
            if (Objects.nonNull((Object)supportLevel)) {
                this.supportLevels.add(supportLevel);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addAllSupportLevel(Collection<SupportType> supportLevelCollection) {
            if (Objects.nonNull(supportLevelCollection)) {
                this.supportLevels.addAll(supportLevelCollection);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addAdditionalPurpose(SoftwarePurpose additionalPurpose) {
            if (Objects.nonNull((Object)additionalPurpose)) {
                this.additionalPurposes.add(additionalPurpose);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addAllAdditionalPurpose(Collection<SoftwarePurpose> additionalPurposeCollection) {
            if (Objects.nonNull(additionalPurposeCollection)) {
                this.additionalPurposes.addAll(additionalPurposeCollection);
            }
            return this;
        }

        public DatasetPackageBuilder addDatasetType(DatasetType datasetType) {
            if (Objects.nonNull((Object)datasetType)) {
                this.datasetTypes.add(datasetType);
            }
            return this;
        }

        public DatasetPackageBuilder addAllDatasetType(Collection<DatasetType> datasetTypeCollection) {
            if (Objects.nonNull(datasetTypeCollection)) {
                this.datasetTypes.addAll(datasetTypeCollection);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addAttributionText(String attributionText) {
            if (Objects.nonNull(attributionText)) {
                this.attributionTexts.add(attributionText);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addAllAttributionText(Collection<String> attributionTextCollection) {
            if (Objects.nonNull(attributionTextCollection)) {
                this.attributionTexts.addAll(attributionTextCollection);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addStandardName(String standardName) {
            if (Objects.nonNull(standardName)) {
                this.standardNames.add(standardName);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder addAllStandardName(Collection<String> standardNameCollection) {
            if (Objects.nonNull(standardNameCollection)) {
                this.standardNames.addAll(standardNameCollection);
            }
            return this;
        }

        public DatasetPackageBuilder addAnonymizationMethodUsed(String anonymizationMethodUsed) {
            if (Objects.nonNull(anonymizationMethodUsed)) {
                this.anonymizationMethodUseds.add(anonymizationMethodUsed);
            }
            return this;
        }

        public DatasetPackageBuilder addAllAnonymizationMethodUsed(Collection<String> anonymizationMethodUsedCollection) {
            if (Objects.nonNull(anonymizationMethodUsedCollection)) {
                this.anonymizationMethodUseds.addAll(anonymizationMethodUsedCollection);
            }
            return this;
        }

        public DatasetPackageBuilder addKnownBias(String knownBias) {
            if (Objects.nonNull(knownBias)) {
                this.knownBiass.add(knownBias);
            }
            return this;
        }

        public DatasetPackageBuilder addAllKnownBias(Collection<String> knownBiasCollection) {
            if (Objects.nonNull(knownBiasCollection)) {
                this.knownBiass.addAll(knownBiasCollection);
            }
            return this;
        }

        public DatasetPackageBuilder addDataPreprocessing(String dataPreprocessing) {
            if (Objects.nonNull(dataPreprocessing)) {
                this.dataPreprocessings.add(dataPreprocessing);
            }
            return this;
        }

        public DatasetPackageBuilder addAllDataPreprocessing(Collection<String> dataPreprocessingCollection) {
            if (Objects.nonNull(dataPreprocessingCollection)) {
                this.dataPreprocessings.addAll(dataPreprocessingCollection);
            }
            return this;
        }

        @Override
        public DatasetPackageBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public DatasetPackageBuilder setSuppliedBy(Agent suppliedBy) {
            this.suppliedBy = suppliedBy;
            return this;
        }

        public DatasetPackageBuilder setDatasetAvailability(DatasetAvailabilityType datasetAvailability) {
            this.datasetAvailability = datasetAvailability;
            return this;
        }

        public DatasetPackageBuilder setConfidentialityLevel(ConfidentialityLevelType confidentialityLevel) {
            this.confidentialityLevel = confidentialityLevel;
            return this;
        }

        public DatasetPackageBuilder setHasSensitivePersonalInformation(PresenceType hasSensitivePersonalInformation) {
            this.hasSensitivePersonalInformation = hasSensitivePersonalInformation;
            return this;
        }

        @Override
        public DatasetPackageBuilder setPrimaryPurpose(SoftwarePurpose primaryPurpose) {
            this.primaryPurpose = primaryPurpose;
            return this;
        }

        public DatasetPackageBuilder setDatasetSize(Integer datasetSize) {
            this.datasetSize = datasetSize;
            return this;
        }

        @Override
        public DatasetPackageBuilder setValidUntilTime(String validUntilTime) {
            this.validUntilTime = validUntilTime;
            return this;
        }

        @Override
        public DatasetPackageBuilder setDownloadLocation(String downloadLocation) {
            this.downloadLocation = downloadLocation;
            return this;
        }

        @Override
        public DatasetPackageBuilder setBuiltTime(String builtTime) {
            this.builtTime = builtTime;
            return this;
        }

        public DatasetPackageBuilder setDatasetNoise(String datasetNoise) {
            this.datasetNoise = datasetNoise;
            return this;
        }

        @Override
        public DatasetPackageBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public DatasetPackageBuilder setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        @Override
        public DatasetPackageBuilder setReleaseTime(String releaseTime) {
            this.releaseTime = releaseTime;
            return this;
        }

        @Override
        public DatasetPackageBuilder setCopyrightText(String copyrightText) {
            this.copyrightText = copyrightText;
            return this;
        }

        @Override
        public DatasetPackageBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public DatasetPackageBuilder setHomePage(String homePage) {
            this.homePage = homePage;
            return this;
        }

        @Override
        public DatasetPackageBuilder setSourceInfo(String sourceInfo) {
            this.sourceInfo = sourceInfo;
            return this;
        }

        public DatasetPackageBuilder setIntendedUse(String intendedUse) {
            this.intendedUse = intendedUse;
            return this;
        }

        @Override
        public DatasetPackageBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public DatasetPackageBuilder setDataCollectionProcess(String dataCollectionProcess) {
            this.dataCollectionProcess = dataCollectionProcess;
            return this;
        }

        public DatasetPackageBuilder setDatasetUpdateMechanism(String datasetUpdateMechanism) {
            this.datasetUpdateMechanism = datasetUpdateMechanism;
            return this;
        }

        @Override
        public DatasetPackageBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public DatasetPackageBuilder setPackageUrl(String packageUrl) {
            this.packageUrl = packageUrl;
            return this;
        }

        @Override
        public DatasetPackage build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                DatasetPackage datasetPackage = new DatasetPackage(this);
                return datasetPackage;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

