/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.expandedlicensing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.expandedlicensing.ExtendableLicense;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.storage.IModelStore;

public abstract class License
extends ExtendableLicense {
    Collection<String> seeAlsos = Collections.emptyList();

    public License() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public License(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public License(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.seeAlsos = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_SEE_ALSO, String.class);
        }
    }

    protected License(LicenseBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.seeAlsos = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_SEE_ALSO, String.class);
        this.getSeeAlsos().addAll(builder.seeAlsos);
        this.setIsFsfLibre(builder.isFsfLibre);
        this.setIsDeprecatedLicenseId(builder.isDeprecatedLicenseId);
        this.setIsOsiApproved(builder.isOsiApproved);
        if (Objects.nonNull(builder.licenseText)) {
            this.setLicenseText(builder.licenseText);
        }
        this.setStandardLicenseTemplate(builder.standardLicenseTemplate);
        this.setObsoletedBy(builder.obsoletedBy);
        this.setLicenseXml(builder.licenseXml);
        this.setStandardLicenseHeader(builder.standardLicenseHeader);
    }

    @Override
    public String getType() {
        return "ExpandedLicensing.License";
    }

    public Collection<String> getSeeAlsos() {
        return this.seeAlsos;
    }

    @Override
    public License setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    public Optional<Boolean> getIsFsfLibre() throws InvalidSPDXAnalysisException {
        return this.getBooleanPropertyValue(SpdxConstantsV3.PROP_IS_FSF_LIBRE);
    }

    public License setIsFsfLibre(@Nullable Boolean isFsfLibre) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_IS_FSF_LIBRE, isFsfLibre);
        return this;
    }

    public Optional<Boolean> getIsDeprecatedLicenseId() throws InvalidSPDXAnalysisException {
        return this.getBooleanPropertyValue(SpdxConstantsV3.PROP_IS_DEPRECATED_LICENSE_ID);
    }

    public License setIsDeprecatedLicenseId(@Nullable Boolean isDeprecatedLicenseId) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_IS_DEPRECATED_LICENSE_ID, isDeprecatedLicenseId);
        return this;
    }

    public Optional<Boolean> getIsOsiApproved() throws InvalidSPDXAnalysisException {
        return this.getBooleanPropertyValue(SpdxConstantsV3.PROP_IS_OSI_APPROVED);
    }

    public License setIsOsiApproved(@Nullable Boolean isOsiApproved) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_IS_OSI_APPROVED, isOsiApproved);
        return this;
    }

    @Nullable
    public String getLicenseText() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_LICENSE_TEXT);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public License setLicenseText(@Nullable String licenseText) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(licenseText)) {
            throw new InvalidSPDXAnalysisException("licenseText is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_LICENSE_TEXT, licenseText);
        return this;
    }

    @Override
    public License setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public License setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    public Optional<String> getStandardLicenseTemplate() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_STANDARD_LICENSE_TEMPLATE);
    }

    public License setStandardLicenseTemplate(@Nullable String standardLicenseTemplate) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_STANDARD_LICENSE_TEMPLATE, standardLicenseTemplate);
        return this;
    }

    public Optional<String> getObsoletedBy() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_OBSOLETED_BY);
    }

    public License setObsoletedBy(@Nullable String obsoletedBy) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_OBSOLETED_BY, obsoletedBy);
        return this;
    }

    public Optional<String> getLicenseXml() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_LICENSE_XML);
    }

    public License setLicenseXml(@Nullable String licenseXml) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_LICENSE_XML, licenseXml);
        return this;
    }

    @Override
    public License setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public License setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    public Optional<String> getStandardLicenseHeader() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_STANDARD_LICENSE_HEADER);
    }

    public License setStandardLicenseHeader(@Nullable String standardLicenseHeader) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_STANDARD_LICENSE_HEADER, standardLicenseHeader);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        Optional<Object> e2;
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Optional<Boolean> optional = this.getIsFsfLibre();
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval.add("Error getting isFsfLibre for License: " + e2.getMessage());
        }
        try {
            e2 = this.getIsDeprecatedLicenseId();
        }
        catch (InvalidSPDXAnalysisException e3) {
            retval.add("Error getting isDeprecatedLicenseId for License: " + e3.getMessage());
        }
        try {
            e2 = this.getIsOsiApproved();
        }
        catch (InvalidSPDXAnalysisException e4) {
            retval.add("Error getting isOsiApproved for License: " + e4.getMessage());
        }
        try {
            String licenseText = this.getLicenseText();
            if (Objects.isNull(licenseText) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.EXPANDED_LICENSING))) {
                retval.add("Missing licenseText in License");
            }
        }
        catch (InvalidSPDXAnalysisException e5) {
            retval.add("Error getting licenseText for License: " + e5.getMessage());
        }
        try {
            e2 = this.getStandardLicenseTemplate();
        }
        catch (InvalidSPDXAnalysisException e6) {
            retval.add("Error getting standardLicenseTemplate for License: " + e6.getMessage());
        }
        try {
            e2 = this.getObsoletedBy();
        }
        catch (InvalidSPDXAnalysisException e7) {
            retval.add("Error getting obsoletedBy for License: " + e7.getMessage());
        }
        try {
            e2 = this.getLicenseXml();
        }
        catch (InvalidSPDXAnalysisException e8) {
            retval.add("Error getting licenseXml for License: " + e8.getMessage());
        }
        try {
            e2 = this.getStandardLicenseHeader();
        }
        catch (InvalidSPDXAnalysisException e9) {
            retval.add("Error getting standardLicenseHeader for License: " + e9.getMessage());
        }
        return retval;
    }

    public static abstract class LicenseBuilder
    extends ExtendableLicense.ExtendableLicenseBuilder {
        protected Collection<String> seeAlsos = new ArrayList<String>();
        protected Boolean isFsfLibre = null;
        protected Boolean isDeprecatedLicenseId = null;
        protected Boolean isOsiApproved = null;
        protected String licenseText = null;
        protected String standardLicenseTemplate = null;
        protected String obsoletedBy = null;
        protected String licenseXml = null;
        protected String standardLicenseHeader = null;

        public LicenseBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public LicenseBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public LicenseBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public LicenseBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public LicenseBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public LicenseBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public LicenseBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public LicenseBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public LicenseBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public LicenseBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public LicenseBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        public LicenseBuilder addSeeAlso(String seeAlso) {
            if (Objects.nonNull(seeAlso)) {
                this.seeAlsos.add(seeAlso);
            }
            return this;
        }

        public LicenseBuilder addAllSeeAlso(Collection<String> seeAlsoCollection) {
            if (Objects.nonNull(seeAlsoCollection)) {
                this.seeAlsos.addAll(seeAlsoCollection);
            }
            return this;
        }

        @Override
        public LicenseBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        public LicenseBuilder setIsFsfLibre(Boolean isFsfLibre) {
            this.isFsfLibre = isFsfLibre;
            return this;
        }

        public LicenseBuilder setIsDeprecatedLicenseId(Boolean isDeprecatedLicenseId) {
            this.isDeprecatedLicenseId = isDeprecatedLicenseId;
            return this;
        }

        public LicenseBuilder setIsOsiApproved(Boolean isOsiApproved) {
            this.isOsiApproved = isOsiApproved;
            return this;
        }

        public LicenseBuilder setLicenseText(String licenseText) {
            this.licenseText = licenseText;
            return this;
        }

        @Override
        public LicenseBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public LicenseBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public LicenseBuilder setStandardLicenseTemplate(String standardLicenseTemplate) {
            this.standardLicenseTemplate = standardLicenseTemplate;
            return this;
        }

        public LicenseBuilder setObsoletedBy(String obsoletedBy) {
            this.obsoletedBy = obsoletedBy;
            return this;
        }

        public LicenseBuilder setLicenseXml(String licenseXml) {
            this.licenseXml = licenseXml;
            return this;
        }

        @Override
        public LicenseBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public LicenseBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public LicenseBuilder setStandardLicenseHeader(String standardLicenseHeader) {
            this.standardLicenseHeader = standardLicenseHeader;
            return this;
        }

        @Override
        public abstract License build() throws InvalidSPDXAnalysisException;
    }
}

