/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.storage.IModelStore;

public class CdxPropertyEntry
extends ModelObjectV3 {
    public CdxPropertyEntry() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public CdxPropertyEntry(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public CdxPropertyEntry(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected CdxPropertyEntry(CdxPropertyEntryBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        if (Objects.nonNull(builder.cdxPropName)) {
            this.setCdxPropName(builder.cdxPropName);
        }
        this.setCdxPropValue(builder.cdxPropValue);
    }

    public String getType() {
        return "Extension.CdxPropertyEntry";
    }

    @Nullable
    public String getCdxPropName() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_CDX_PROP_NAME);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public CdxPropertyEntry setCdxPropName(@Nullable String cdxPropName) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(cdxPropName)) {
            throw new InvalidSPDXAnalysisException("cdxPropName is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_CDX_PROP_NAME, cdxPropName);
        return this;
    }

    public Optional<String> getCdxPropValue() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_CDX_PROP_VALUE);
    }

    public CdxPropertyEntry setCdxPropValue(@Nullable String cdxPropValue) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_CDX_PROP_VALUE, cdxPropValue);
        return this;
    }

    public String toString() {
        return "CdxPropertyEntry: " + this.getObjectUri();
    }

    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            String cdxPropName = this.getCdxPropName();
            if (Objects.isNull(cdxPropName) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.EXTENSION))) {
                retval.add("Missing cdxPropName in CdxPropertyEntry");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting cdxPropName for CdxPropertyEntry: " + e.getMessage());
        }
        try {
            Optional<String> e = this.getCdxPropValue();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting cdxPropValue for CdxPropertyEntry: " + e.getMessage());
        }
        return retval;
    }

    public static class CdxPropertyEntryBuilder
    extends ModelObjectV3.ModelObjectV3Builder {
        protected String cdxPropName = null;
        protected String cdxPropValue = null;

        public CdxPropertyEntryBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public CdxPropertyEntryBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
        }

        public CdxPropertyEntryBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        public CdxPropertyEntryBuilder setCdxPropName(String cdxPropName) {
            this.cdxPropName = cdxPropName;
            return this;
        }

        public CdxPropertyEntryBuilder setCdxPropValue(String cdxPropValue) {
            this.cdxPropValue = cdxPropValue;
            return this;
        }

        public CdxPropertyEntry build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                CdxPropertyEntry cdxPropertyEntry = new CdxPropertyEntry(this);
                return cdxPropertyEntry;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

