/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.RelationshipCompleteness;
import org.spdx.library.model.v3_0_1.core.RelationshipType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.security.VexJustificationType;
import org.spdx.library.model.v3_0_1.security.VexVulnAssessmentRelationship;
import org.spdx.library.model.v3_0_1.software.SoftwareArtifact;
import org.spdx.storage.IModelStore;

public class VexNotAffectedVulnAssessmentRelationship
extends VexVulnAssessmentRelationship {
    public VexNotAffectedVulnAssessmentRelationship() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public VexNotAffectedVulnAssessmentRelationship(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public VexNotAffectedVulnAssessmentRelationship(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected VexNotAffectedVulnAssessmentRelationship(VexNotAffectedVulnAssessmentRelationshipBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.setJustificationType(builder.justificationType);
        this.setImpactStatementTime(builder.impactStatementTime);
        this.setImpactStatement(builder.impactStatement);
    }

    @Override
    public String getType() {
        return "Security.VexNotAffectedVulnAssessmentRelationship";
    }

    @Override
    public VexNotAffectedVulnAssessmentRelationship setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public VexNotAffectedVulnAssessmentRelationship setSuppliedBy(@Nullable Agent suppliedBy) throws InvalidSPDXAnalysisException {
        super.setSuppliedBy(suppliedBy);
        return this;
    }

    @Override
    public VexNotAffectedVulnAssessmentRelationship setFrom(@Nullable Element from) throws InvalidSPDXAnalysisException {
        super.setFrom(from);
        return this;
    }

    @Override
    public VexNotAffectedVulnAssessmentRelationship setAssessedElement(@Nullable SoftwareArtifact assessedElement) throws InvalidSPDXAnalysisException {
        super.setAssessedElement(assessedElement);
        return this;
    }

    @Override
    public VexNotAffectedVulnAssessmentRelationship setRelationshipType(@Nullable RelationshipType relationshipType) throws InvalidSPDXAnalysisException {
        super.setRelationshipType(relationshipType);
        return this;
    }

    @Override
    public VexNotAffectedVulnAssessmentRelationship setCompleteness(@Nullable RelationshipCompleteness completeness) throws InvalidSPDXAnalysisException {
        super.setCompleteness(completeness);
        return this;
    }

    public Optional<VexJustificationType> getJustificationType() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_JUSTIFICATION_TYPE);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof VexJustificationType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for justificationType");
            }
            return retval;
        }
        return Optional.empty();
    }

    public VexNotAffectedVulnAssessmentRelationship setJustificationType(@Nullable VexJustificationType justificationType) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_JUSTIFICATION_TYPE, (Object)justificationType);
        return this;
    }

    @Override
    public VexNotAffectedVulnAssessmentRelationship setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public VexNotAffectedVulnAssessmentRelationship setWithdrawnTime(@Nullable String withdrawnTime) throws InvalidSPDXAnalysisException {
        super.setWithdrawnTime(withdrawnTime);
        return this;
    }

    @Override
    public VexNotAffectedVulnAssessmentRelationship setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public VexNotAffectedVulnAssessmentRelationship setModifiedTime(@Nullable String modifiedTime) throws InvalidSPDXAnalysisException {
        super.setModifiedTime(modifiedTime);
        return this;
    }

    @Override
    public VexNotAffectedVulnAssessmentRelationship setPublishedTime(@Nullable String publishedTime) throws InvalidSPDXAnalysisException {
        super.setPublishedTime(publishedTime);
        return this;
    }

    @Override
    public VexNotAffectedVulnAssessmentRelationship setVexVersion(@Nullable String vexVersion) throws InvalidSPDXAnalysisException {
        super.setVexVersion(vexVersion);
        return this;
    }

    public Optional<String> getImpactStatementTime() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_IMPACT_STATEMENT_TIME);
    }

    public VexNotAffectedVulnAssessmentRelationship setImpactStatementTime(@Nullable String impactStatementTime) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.nonNull(impactStatementTime) && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", impactStatementTime)) {
            throw new InvalidSPDXAnalysisException("impactStatementTime value '" + impactStatementTime + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_IMPACT_STATEMENT_TIME, impactStatementTime);
        return this;
    }

    @Override
    public VexNotAffectedVulnAssessmentRelationship setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public VexNotAffectedVulnAssessmentRelationship setEndTime(@Nullable String endTime) throws InvalidSPDXAnalysisException {
        super.setEndTime(endTime);
        return this;
    }

    @Override
    public VexNotAffectedVulnAssessmentRelationship setStatusNotes(@Nullable String statusNotes) throws InvalidSPDXAnalysisException {
        super.setStatusNotes(statusNotes);
        return this;
    }

    @Override
    public VexNotAffectedVulnAssessmentRelationship setStartTime(@Nullable String startTime) throws InvalidSPDXAnalysisException {
        super.setStartTime(startTime);
        return this;
    }

    @Override
    public VexNotAffectedVulnAssessmentRelationship setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    public Optional<String> getImpactStatement() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_IMPACT_STATEMENT);
    }

    public VexNotAffectedVulnAssessmentRelationship setImpactStatement(@Nullable String impactStatement) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_IMPACT_STATEMENT, impactStatement);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Optional<VexJustificationType> optional = this.getJustificationType();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting justificationType for VexNotAffectedVulnAssessmentRelationship: " + e.getMessage());
        }
        try {
            Optional<String> impactStatementTime = this.getImpactStatementTime();
            if (impactStatementTime.isPresent() && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", impactStatementTime.get())) {
                retval.add("impactStatementTime value '" + impactStatementTime.get() + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting impactStatementTime for VexNotAffectedVulnAssessmentRelationship: " + e.getMessage());
        }
        try {
            Optional<String> e = this.getImpactStatement();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting impactStatement for VexNotAffectedVulnAssessmentRelationship: " + e.getMessage());
        }
        return retval;
    }

    public static class VexNotAffectedVulnAssessmentRelationshipBuilder
    extends VexVulnAssessmentRelationship.VexVulnAssessmentRelationshipBuilder {
        protected VexJustificationType justificationType = null;
        protected String impactStatementTime = null;
        protected String impactStatement = null;

        public VexNotAffectedVulnAssessmentRelationshipBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public VexNotAffectedVulnAssessmentRelationshipBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public VexNotAffectedVulnAssessmentRelationshipBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder addTo(Element to) {
            if (Objects.nonNull((Object)to)) {
                this.tos.add(to);
            }
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder addAllTo(Collection<Element> toCollection) {
            if (Objects.nonNull(toCollection)) {
                this.tos.addAll(toCollection);
            }
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder setSuppliedBy(Agent suppliedBy) {
            this.suppliedBy = suppliedBy;
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder setFrom(Element from) {
            this.from = from;
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder setAssessedElement(SoftwareArtifact assessedElement) {
            this.assessedElement = assessedElement;
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder setRelationshipType(RelationshipType relationshipType) {
            this.relationshipType = relationshipType;
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder setCompleteness(RelationshipCompleteness completeness) {
            this.completeness = completeness;
            return this;
        }

        public VexNotAffectedVulnAssessmentRelationshipBuilder setJustificationType(VexJustificationType justificationType) {
            this.justificationType = justificationType;
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder setWithdrawnTime(String withdrawnTime) {
            this.withdrawnTime = withdrawnTime;
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder setModifiedTime(String modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder setPublishedTime(String publishedTime) {
            this.publishedTime = publishedTime;
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder setVexVersion(String vexVersion) {
            this.vexVersion = vexVersion;
            return this;
        }

        public VexNotAffectedVulnAssessmentRelationshipBuilder setImpactStatementTime(String impactStatementTime) {
            this.impactStatementTime = impactStatementTime;
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder setEndTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder setStatusNotes(String statusNotes) {
            this.statusNotes = statusNotes;
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder setStartTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationshipBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public VexNotAffectedVulnAssessmentRelationshipBuilder setImpactStatement(String impactStatement) {
            this.impactStatement = impactStatement;
            return this;
        }

        @Override
        public VexNotAffectedVulnAssessmentRelationship build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                VexNotAffectedVulnAssessmentRelationship vexNotAffectedVulnAssessmentRelationship = new VexNotAffectedVulnAssessmentRelationship(this);
                return vexNotAffectedVulnAssessmentRelationship;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

