/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.simplelicensing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.storage.IModelStore;

public class SimpleLicensingText
extends Element {
    public SimpleLicensingText() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public SimpleLicensingText(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public SimpleLicensingText(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected SimpleLicensingText(SimpleLicensingTextBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        if (Objects.nonNull(builder.licenseText)) {
            this.setLicenseText(builder.licenseText);
        }
    }

    @Override
    public String getType() {
        return "SimpleLicensing.SimpleLicensingText";
    }

    @Override
    public SimpleLicensingText setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Nullable
    public String getLicenseText() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_LICENSE_TEXT);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public SimpleLicensingText setLicenseText(@Nullable String licenseText) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(licenseText)) {
            throw new InvalidSPDXAnalysisException("licenseText is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_LICENSE_TEXT, licenseText);
        return this;
    }

    @Override
    public SimpleLicensingText setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public SimpleLicensingText setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public SimpleLicensingText setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public SimpleLicensingText setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            String licenseText = this.getLicenseText();
            if (Objects.isNull(licenseText) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.SIMPLE_LICENSING))) {
                retval.add("Missing licenseText in SimpleLicensingText");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting licenseText for SimpleLicensingText: " + e.getMessage());
        }
        return retval;
    }

    public static class SimpleLicensingTextBuilder
    extends Element.ElementBuilder {
        protected String licenseText = null;

        public SimpleLicensingTextBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public SimpleLicensingTextBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public SimpleLicensingTextBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public SimpleLicensingTextBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public SimpleLicensingTextBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public SimpleLicensingTextBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public SimpleLicensingTextBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public SimpleLicensingTextBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public SimpleLicensingTextBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public SimpleLicensingTextBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public SimpleLicensingTextBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public SimpleLicensingTextBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        public SimpleLicensingTextBuilder setLicenseText(String licenseText) {
            this.licenseText = licenseText;
            return this;
        }

        @Override
        public SimpleLicensingTextBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public SimpleLicensingTextBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public SimpleLicensingTextBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public SimpleLicensingTextBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public SimpleLicensingText build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                SimpleLicensingText simpleLicensingText = new SimpleLicensingText(this);
                return simpleLicensingText;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

