/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.software;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.Artifact;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.SupportType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.software.ContentIdentifier;
import org.spdx.library.model.v3_0_1.software.SoftwarePurpose;
import org.spdx.storage.IModelStore;

public abstract class SoftwareArtifact
extends Artifact {
    Collection<ContentIdentifier> contentIdentifiers = Collections.emptyList();
    Collection<String> attributionTexts = Collections.emptyList();
    Collection<SoftwarePurpose> additionalPurposes = Collections.emptyList();

    public SoftwareArtifact() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public SoftwareArtifact(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public SoftwareArtifact(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.contentIdentifiers = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CONTENT_IDENTIFIER, ContentIdentifier.class);
        }
        if (!this.isExternal()) {
            this.additionalPurposes = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ADDITIONAL_PURPOSE, SoftwarePurpose.class);
        }
        if (!this.isExternal()) {
            this.attributionTexts = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ATTRIBUTION_TEXT, String.class);
        }
    }

    protected SoftwareArtifact(SoftwareArtifactBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.contentIdentifiers = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CONTENT_IDENTIFIER, ContentIdentifier.class);
        this.additionalPurposes = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ADDITIONAL_PURPOSE, SoftwarePurpose.class);
        this.attributionTexts = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ATTRIBUTION_TEXT, String.class);
        this.getContentIdentifiers().addAll(builder.contentIdentifiers);
        this.getAdditionalPurposes().addAll(builder.additionalPurposes);
        this.getAttributionTexts().addAll(builder.attributionTexts);
        this.setPrimaryPurpose(builder.primaryPurpose);
        this.setCopyrightText(builder.copyrightText);
    }

    @Override
    public String getType() {
        return "Software.SoftwareArtifact";
    }

    public Collection<ContentIdentifier> getContentIdentifiers() {
        return this.contentIdentifiers;
    }

    public Collection<SoftwarePurpose> getAdditionalPurposes() {
        return this.additionalPurposes;
    }

    public Collection<String> getAttributionTexts() {
        return this.attributionTexts;
    }

    @Override
    public SoftwareArtifact setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public SoftwareArtifact setSuppliedBy(@Nullable Agent suppliedBy) throws InvalidSPDXAnalysisException {
        super.setSuppliedBy(suppliedBy);
        return this;
    }

    public Optional<SoftwarePurpose> getPrimaryPurpose() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_PRIMARY_PURPOSE);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof SoftwarePurpose)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for primaryPurpose");
            }
            return retval;
        }
        return Optional.empty();
    }

    public SoftwareArtifact setPrimaryPurpose(@Nullable SoftwarePurpose primaryPurpose) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_PRIMARY_PURPOSE, (Object)primaryPurpose);
        return this;
    }

    @Override
    public SoftwareArtifact setValidUntilTime(@Nullable String validUntilTime) throws InvalidSPDXAnalysisException {
        super.setValidUntilTime(validUntilTime);
        return this;
    }

    @Override
    public SoftwareArtifact setBuiltTime(@Nullable String builtTime) throws InvalidSPDXAnalysisException {
        super.setBuiltTime(builtTime);
        return this;
    }

    @Override
    public SoftwareArtifact setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public SoftwareArtifact setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public SoftwareArtifact setReleaseTime(@Nullable String releaseTime) throws InvalidSPDXAnalysisException {
        super.setReleaseTime(releaseTime);
        return this;
    }

    public Optional<String> getCopyrightText() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_COPYRIGHT_TEXT);
    }

    public SoftwareArtifact setCopyrightText(@Nullable String copyrightText) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_COPYRIGHT_TEXT, copyrightText);
        return this;
    }

    @Override
    public SoftwareArtifact setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public SoftwareArtifact setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Optional<SoftwarePurpose> optional = this.getPrimaryPurpose();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting primaryPurpose for SoftwareArtifact: " + e.getMessage());
        }
        try {
            Optional<String> e = this.getCopyrightText();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting copyrightText for SoftwareArtifact: " + e.getMessage());
        }
        for (ContentIdentifier contentIdentifier : this.contentIdentifiers) {
            retval.addAll(contentIdentifier.verify(verifiedIds, specVersionForVerify, profiles));
        }
        return retval;
    }

    public static abstract class SoftwareArtifactBuilder
    extends Artifact.ArtifactBuilder {
        protected Collection<ContentIdentifier> contentIdentifiers = new ArrayList<ContentIdentifier>();
        protected Collection<SoftwarePurpose> additionalPurposes = new ArrayList<SoftwarePurpose>();
        protected Collection<String> attributionTexts = new ArrayList<String>();
        protected SoftwarePurpose primaryPurpose = null;
        protected String copyrightText = null;

        public SoftwareArtifactBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public SoftwareArtifactBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public SoftwareArtifactBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        public SoftwareArtifactBuilder addContentIdentifier(ContentIdentifier contentIdentifier) {
            if (Objects.nonNull((Object)contentIdentifier)) {
                this.contentIdentifiers.add(contentIdentifier);
            }
            return this;
        }

        public SoftwareArtifactBuilder addAllContentIdentifier(Collection<ContentIdentifier> contentIdentifierCollection) {
            if (Objects.nonNull(contentIdentifierCollection)) {
                this.contentIdentifiers.addAll(contentIdentifierCollection);
            }
            return this;
        }

        @Override
        public SoftwareArtifactBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public SoftwareArtifactBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public SoftwareArtifactBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public SoftwareArtifactBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public SoftwareArtifactBuilder addOriginatedBy(Agent originatedBy) {
            if (Objects.nonNull((Object)originatedBy)) {
                this.originatedBys.add(originatedBy);
            }
            return this;
        }

        @Override
        public SoftwareArtifactBuilder addAllOriginatedBy(Collection<Agent> originatedByCollection) {
            if (Objects.nonNull(originatedByCollection)) {
                this.originatedBys.addAll(originatedByCollection);
            }
            return this;
        }

        @Override
        public SoftwareArtifactBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public SoftwareArtifactBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public SoftwareArtifactBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public SoftwareArtifactBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public SoftwareArtifactBuilder addSupportLevel(SupportType supportLevel) {
            if (Objects.nonNull((Object)supportLevel)) {
                this.supportLevels.add(supportLevel);
            }
            return this;
        }

        @Override
        public SoftwareArtifactBuilder addAllSupportLevel(Collection<SupportType> supportLevelCollection) {
            if (Objects.nonNull(supportLevelCollection)) {
                this.supportLevels.addAll(supportLevelCollection);
            }
            return this;
        }

        public SoftwareArtifactBuilder addAdditionalPurpose(SoftwarePurpose additionalPurpose) {
            if (Objects.nonNull((Object)additionalPurpose)) {
                this.additionalPurposes.add(additionalPurpose);
            }
            return this;
        }

        public SoftwareArtifactBuilder addAllAdditionalPurpose(Collection<SoftwarePurpose> additionalPurposeCollection) {
            if (Objects.nonNull(additionalPurposeCollection)) {
                this.additionalPurposes.addAll(additionalPurposeCollection);
            }
            return this;
        }

        public SoftwareArtifactBuilder addAttributionText(String attributionText) {
            if (Objects.nonNull(attributionText)) {
                this.attributionTexts.add(attributionText);
            }
            return this;
        }

        public SoftwareArtifactBuilder addAllAttributionText(Collection<String> attributionTextCollection) {
            if (Objects.nonNull(attributionTextCollection)) {
                this.attributionTexts.addAll(attributionTextCollection);
            }
            return this;
        }

        @Override
        public SoftwareArtifactBuilder addStandardName(String standardName) {
            if (Objects.nonNull(standardName)) {
                this.standardNames.add(standardName);
            }
            return this;
        }

        @Override
        public SoftwareArtifactBuilder addAllStandardName(Collection<String> standardNameCollection) {
            if (Objects.nonNull(standardNameCollection)) {
                this.standardNames.addAll(standardNameCollection);
            }
            return this;
        }

        @Override
        public SoftwareArtifactBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public SoftwareArtifactBuilder setSuppliedBy(Agent suppliedBy) {
            this.suppliedBy = suppliedBy;
            return this;
        }

        public SoftwareArtifactBuilder setPrimaryPurpose(SoftwarePurpose primaryPurpose) {
            this.primaryPurpose = primaryPurpose;
            return this;
        }

        @Override
        public SoftwareArtifactBuilder setValidUntilTime(String validUntilTime) {
            this.validUntilTime = validUntilTime;
            return this;
        }

        @Override
        public SoftwareArtifactBuilder setBuiltTime(String builtTime) {
            this.builtTime = builtTime;
            return this;
        }

        @Override
        public SoftwareArtifactBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public SoftwareArtifactBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public SoftwareArtifactBuilder setReleaseTime(String releaseTime) {
            this.releaseTime = releaseTime;
            return this;
        }

        public SoftwareArtifactBuilder setCopyrightText(String copyrightText) {
            this.copyrightText = copyrightText;
            return this;
        }

        @Override
        public SoftwareArtifactBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public SoftwareArtifactBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public abstract SoftwareArtifact build() throws InvalidSPDXAnalysisException;
    }
}

