/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.v2.enumerations.FileType;
import org.spdx.maven.Checksum;
import org.spdx.maven.utils.SpdxCollectionException;
import org.spdx.maven.utils.SpdxV2FileCollector;

public abstract class AbstractFileCollector {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractFileCollector.class);
    static final String SPDX_FILE_TYPE_CONSTANTS_PROP_PATH = "resources/SpdxFileTypeConstants.prop";
    public static final Map<String, FileType> EXT_TO_FILE_TYPE = new HashMap<String, FileType>();
    public static final Map<String, String> CHECKSUM_ALGORITHMS;

    private static void loadFileExtensionConstants() {
        Properties prop = new Properties();
        try (InputStream is = SpdxV2FileCollector.class.getClassLoader().getResourceAsStream(SPDX_FILE_TYPE_CONSTANTS_PROP_PATH);){
            if (is == null) {
                LOG.error("Unable to load properties file resources/SpdxFileTypeConstants.prop");
                return;
            }
            prop.load(is);
            for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                String[] extensions;
                String fileTypeStr = (String)entry.getKey();
                FileType fileType = FileType.valueOf((String)fileTypeStr);
                for (String extension : extensions = ((String)entry.getValue()).split(",")) {
                    try {
                        String trimmedExtension = extension.toUpperCase().trim();
                        if (EXT_TO_FILE_TYPE.containsKey(trimmedExtension)) {
                            LOG.warn("Duplicate file extension: {}", (Object)trimmedExtension);
                        }
                        EXT_TO_FILE_TYPE.put(trimmedExtension, fileType);
                    }
                    catch (Exception ex) {
                        LOG.error("Error adding file extensions to filetype map", (Throwable)ex);
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.warn("WARNING: Error reading SpdxFileTypeConstants properties file.  All file types will be mapped to Other.");
        }
    }

    public String getExtension(File file) {
        String fileName = file.getName();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot < 1) {
            return "";
        }
        return fileName.substring(lastDot + 1);
    }

    protected boolean isSourceFile(Collection<FileType> fileTypes) {
        for (FileType ft : fileTypes) {
            if (ft != FileType.SOURCE) continue;
            return true;
        }
        return false;
    }

    public String convertFilePathToSpdxFileName(String filePath) {
        Object result = filePath.replace('\\', '/');
        if (!((String)result).startsWith("./")) {
            result = "./" + (String)result;
        }
        return result;
    }

    protected static FileType extensionToFileType(String fileExtension) {
        return EXT_TO_FILE_TYPE.getOrDefault(fileExtension.trim().toUpperCase(), FileType.OTHER);
    }

    public static String convertChecksumToString(byte[] digestBytes) {
        StringBuilder sb = new StringBuilder();
        for (byte digestByte : digestBytes) {
            String hex = Integer.toHexString(0xFF & digestByte);
            if (hex.length() < 2) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static Checksum generateSha1(File file) throws SpdxCollectionException, InvalidSPDXAnalysisException {
        HashSet<String> sha1 = new HashSet<String>();
        sha1.add("SHA-1");
        return AbstractFileCollector.generateChecksum(file, sha1).iterator().next();
    }

    public static Set<Checksum> generateChecksum(File file, Set<String> algorithms) throws SpdxCollectionException, InvalidSPDXAnalysisException {
        byte[] buffer;
        HashSet<Checksum> checksums = new HashSet<Checksum>();
        try {
            buffer = Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            throw new SpdxCollectionException("IO error while calculating checksums.", e);
        }
        for (String algorithm : algorithms) {
            MessageDigest digest;
            String checksumAlgorithm = CHECKSUM_ALGORITHMS.get(algorithm);
            try {
                digest = MessageDigest.getInstance(checksumAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SpdxCollectionException(e);
            }
            digest.update(buffer);
            String checksum = AbstractFileCollector.convertChecksumToString(digest.digest());
            checksums.add(new Checksum(algorithm, checksum));
        }
        return checksums;
    }

    static {
        AbstractFileCollector.loadFileExtensionConstants();
        CHECKSUM_ALGORITHMS = new HashMap<String, String>();
        CHECKSUM_ALGORITHMS.put(ChecksumAlgorithm.SHA1.toString(), "SHA-1");
        CHECKSUM_ALGORITHMS.put(ChecksumAlgorithm.SHA224.toString(), "SHA-224");
        CHECKSUM_ALGORITHMS.put(ChecksumAlgorithm.SHA256.toString(), "SHA-256");
        CHECKSUM_ALGORITHMS.put(ChecksumAlgorithm.SHA384.toString(), "SHA-384");
        CHECKSUM_ALGORITHMS.put(ChecksumAlgorithm.SHA3_384.toString(), "SHA-512");
        CHECKSUM_ALGORITHMS.put(ChecksumAlgorithm.MD2.toString(), "MD2");
        CHECKSUM_ALGORITHMS.put(ChecksumAlgorithm.MD4.toString(), "MD4");
        CHECKSUM_ALGORITHMS.put(ChecksumAlgorithm.MD5.toString(), "MD5");
        CHECKSUM_ALGORITHMS.put(ChecksumAlgorithm.MD6.toString(), "MD6");
    }
}

