/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.License;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.spdx.core.CoreModelObject;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.SpdxCoreConstants;
import org.spdx.core.SpdxInvalidIdException;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.library.model.v2.Annotation;
import org.spdx.library.model.v2.ExternalDocumentRef;
import org.spdx.library.model.v2.ExternalSpdxElement;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.library.model.v2.SpdxElement;
import org.spdx.library.model.v2.SpdxPackage;
import org.spdx.library.model.v2.enumerations.AnnotationType;
import org.spdx.library.model.v2.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.v2.enumerations.Purpose;
import org.spdx.library.model.v2.enumerations.RelationshipType;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.model.v2.license.SpdxNoAssertionLicense;
import org.spdx.maven.Checksum;
import org.spdx.maven.LicenseOverwrite;
import org.spdx.maven.OutputFormat;
import org.spdx.maven.utils.AbstractDependencyBuilder;
import org.spdx.maven.utils.AbstractFileCollector;
import org.spdx.maven.utils.IdGenerator;
import org.spdx.maven.utils.LicenseManagerException;
import org.spdx.maven.utils.LicenseMapperException;
import org.spdx.maven.utils.MavenToSpdxLicenseMapper;
import org.spdx.maven.utils.SpdxCollectionException;
import org.spdx.maven.utils.SpdxDefaultFileInformation;
import org.spdx.maven.utils.SpdxExternalRefBuilder;
import org.spdx.maven.utils.SpdxV2DocumentBuilder;
import org.spdx.maven.utils.SpdxV2LicenseManager;
import org.spdx.spdxRdfStore.RdfStore;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.InMemSpdxStore;

public class SpdxV2DependencyBuilder
extends AbstractDependencyBuilder {
    private final Map<String, ExternalDocumentRef> externalDocuments = new HashMap<String, ExternalDocumentRef>();
    private final SpdxDocument spdxDoc;
    private final SpdxV2LicenseManager licenseManager;
    private final Map<LicenseOverwrite, AnyLicenseInfo> licenseOverwrites = new HashMap<LicenseOverwrite, AnyLicenseInfo>();

    protected static SpdxDocument spdxDocumentFromFile(String path) throws FileNotFoundException, IOException, InvalidSPDXAnalysisException {
        OutputFormat of = OutputFormat.getOutputFormat(null, new File(path));
        if (!SpdxCoreConstants.SpdxMajorVersion.VERSION_2.equals((Object)of.getSpecVersion())) {
            throw new InvalidSPDXAnalysisException(String.format("Unsupported file type for SPDX Version 2 SPDX documents: %s", of.getSpecVersion().toString()));
        }
        Object modelStore = of.getArtifactType().equals("spdx.json") ? new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.JSON_PRETTY, MultiFormatStore.Verbose.COMPACT) : new RdfStore();
        try {
            SpdxDocument spdxDocument;
            try (FileInputStream inputStream = new FileInputStream(path);){
                spdxDocument = (SpdxDocument)modelStore.deSerialize((InputStream)inputStream, false);
            }
            return spdxDocument;
        }
        finally {
            try {
                modelStore.close();
            }
            catch (Exception e) {
                LOG.error("Error closing SPDX model store", (Throwable)e);
            }
        }
    }

    protected static SpdxPackage findMatchingDescribedPackage(SpdxDocument externalSpdxDoc, String artifactId) throws InvalidSPDXAnalysisException {
        SpdxElement itemDescribed = null;
        for (SpdxElement item : externalSpdxDoc.getDocumentDescribes()) {
            Optional name = item.getName();
            if (!(item instanceof SpdxPackage) || !name.isPresent() || !item.getName().orElse("").equals(artifactId)) continue;
            itemDescribed = item;
            break;
        }
        if (itemDescribed == null) {
            LOG.warn("Could not find matching artifact ID in SPDX file for {}.  Using the first package found in SPDX file.", (Object)artifactId);
            for (SpdxElement item : externalSpdxDoc.getDocumentDescribes()) {
                if (!(item instanceof SpdxPackage)) continue;
                itemDescribed = item;
                break;
            }
        }
        if (itemDescribed == null) {
            throw new InvalidSPDXAnalysisException("SPDX document does not contain any described items.");
        }
        return (SpdxPackage)itemDescribed;
    }

    public SpdxV2DependencyBuilder(SpdxV2DocumentBuilder builder, boolean createExternalRefs, boolean generatePurls, boolean useArtifactID, boolean includeTransitiveDependencies) {
        super(createExternalRefs, generatePurls, useArtifactID, includeTransitiveDependencies);
        this.spdxDoc = builder.getSpdxDoc();
        this.licenseManager = builder.getLicenseManager();
    }

    @Override
    protected void addMavenDependency(CoreModelObject parentPackage, DependencyNode dependencyNode, ProjectBuilder mavenProjectBuilder, MavenSession session, MavenProject mavenProject) throws LicenseMapperException, InvalidSPDXAnalysisException {
        if (!(parentPackage instanceof SpdxPackage)) {
            LOG.error("Invalid type for parent package.  Expected 'SpdxPackage', found {}", (Object)parentPackage.getClass().getName());
            return;
        }
        Artifact dependency = dependencyNode.getArtifact();
        String scope = dependency.getScope();
        RelationshipType relType = this.scopeToRelationshipType(scope, dependency.isOptional());
        if (relType == RelationshipType.OTHER) {
            LOG.warn("Could not determine the SPDX relationship type for dependency artifact ID {} scope {}", (Object)dependency.getArtifactId(), (Object)scope);
        }
        SpdxElement dependencyPackage = this.createSpdxPackage(dependency, mavenProjectBuilder, session, mavenProject, this.useArtifactID);
        if (relType.toString().endsWith("_OF")) {
            if (dependencyPackage instanceof SpdxPackage) {
                ((SpdxPackage)parentPackage).addRelationship(this.spdxDoc.createRelationship(dependencyPackage, relType, "Relationship created based on Maven POM information"));
                LOG.debug("Added relationship of type {} for {}", (Object)relType, (Object)dependencyPackage.getName());
            } else {
                ((SpdxPackage)parentPackage).addRelationship(this.spdxDoc.createRelationship((SpdxElement)((SpdxPackage)parentPackage), RelationshipType.OTHER, "This relationship is the inverse of " + relType + " to an external document reference."));
                LOG.debug("Could not create proper to relationships for external element {}", (Object)dependencyPackage.getId());
            }
        } else {
            ((SpdxPackage)parentPackage).addRelationship(this.spdxDoc.createRelationship(dependencyPackage, relType, "Relationship based on Maven POM file dependency information"));
        }
        if (this.includeTransitiveDependencies) {
            this.addMavenDependencies(mavenProjectBuilder, session, mavenProject, dependencyNode, (CoreModelObject)dependencyPackage);
        }
    }

    private RelationshipType scopeToRelationshipType(String scope, boolean optional) {
        if (scope == null) {
            return RelationshipType.OTHER;
        }
        if (optional) {
            return RelationshipType.OPTIONAL_COMPONENT_OF;
        }
        if (scope.equals("compile") || scope.equals("runtime")) {
            return RelationshipType.DYNAMIC_LINK;
        }
        if (scope.equals("test")) {
            return RelationshipType.TEST_DEPENDENCY_OF;
        }
        return RelationshipType.OTHER;
    }

    private SpdxPackage createSpdxPackage(MavenProject project, boolean useArtifactID) throws SpdxCollectionException, NoSuchAlgorithmException, LicenseMapperException, InvalidSPDXAnalysisException {
        SpdxDefaultFileInformation fileInfo = new SpdxDefaultFileInformation();
        Object packageName = project.getName();
        if (packageName == null || ((String)packageName).isEmpty() || useArtifactID) {
            packageName = project.getGroupId() + ":" + project.getArtifactId();
        }
        List contributors = project.getContributors();
        ArrayList<String> fileContributorList = new ArrayList<String>();
        if (contributors != null) {
            for (Contributor contributor : contributors) {
                fileContributorList.add(contributor.getName());
            }
        }
        String copyright = "UNSPECIFIED";
        String notice = "UNSPECIFIED";
        String downloadLocation = "NOASSERTION";
        Optional<AnyLicenseInfo> declaredLicenseOverwrite = this.applyLicenseOverwrites(project, "declared");
        AnyLicenseInfo originalDeclaredLicense = this.mavenLicensesToSpdxLicense(project.getLicenses());
        AnyLicenseInfo declaredLicense = declaredLicenseOverwrite.orElse(originalDeclaredLicense);
        fileInfo.setComment("");
        Optional<AnyLicenseInfo> concludedLicenseOverwrite = this.applyLicenseOverwrites(project, "concluded");
        SpdxNoAssertionLicense originalConcludedLicense = new SpdxNoAssertionLicense();
        AnyLicenseInfo concludedLicense = concludedLicenseOverwrite.orElse((AnyLicenseInfo)originalConcludedLicense);
        fileInfo.setConcludedLicense(concludedLicense.toString());
        fileInfo.setContributors(fileContributorList.toArray(new String[0]));
        fileInfo.setCopyright(copyright);
        fileInfo.setDeclaredLicense(declaredLicense.toString());
        ArrayList<CallSite> comment = new ArrayList<CallSite>();
        if (declaredLicenseOverwrite.isPresent()) {
            comment.add((CallSite)((Object)("Declared license has been overwritten, original value: " + originalDeclaredLicense)));
        }
        if (concludedLicenseOverwrite.isPresent()) {
            comment.add((CallSite)((Object)("Concluded license has been overwritten, original value: " + (AnyLicenseInfo)originalConcludedLicense)));
        }
        fileInfo.setLicenseComment(String.join((CharSequence)"\n", comment));
        fileInfo.setNotice(notice);
        SpdxPackage retval = this.spdxDoc.createPackage(IdGenerator.getIdGenerator().generateId(project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion()), (String)packageName, (AnyLicenseInfo)new SpdxNoAssertionLicense(), copyright, declaredLicense).setDownloadLocation(downloadLocation).setFilesAnalyzed(false).setExternalRefs(SpdxExternalRefBuilder.getDefaultExternalRefs(this.spdxDoc, this.generatePurls, project)).build();
        retval.setLicenseConcluded(concludedLicense);
        if (project.getVersion() != null) {
            retval.setVersionInfo(project.getVersion());
        }
        if (project.getDescription() != null) {
            retval.setDescription(project.getDescription());
            retval.setSummary(project.getDescription());
        }
        if (project.getOrganization() != null) {
            retval.setOriginator("Organization:" + project.getOrganization().getName());
        }
        if (project.getUrl() != null) {
            try {
                retval.setHomepage(project.getUrl());
            }
            catch (InvalidSPDXAnalysisException e) {
                LOG.warn("Invalid homepage for dependency {}: {}", (Object)project.getArtifactId(), (Object)project.getUrl());
            }
        }
        return retval;
    }

    private SpdxElement createSpdxPackage(Artifact artifact, ProjectBuilder mavenProjectBuilder, MavenSession session, MavenProject mavenProject, boolean useArtifactID) throws LicenseMapperException, InvalidSPDXAnalysisException {
        LOG.debug("Creating SPDX package for artifact {}", (Object)artifact.getArtifactId());
        if (artifact.getFile() == null) {
            LOG.debug("Artifact file is null");
        } else {
            LOG.debug("Artifact file name = {}", (Object)artifact.getFile().getName());
        }
        File spdxFile = null;
        if (artifact.getFile() != null) {
            spdxFile = this.artifactFileToSpdxFile(artifact.getFile(), SpdxCoreConstants.SpdxMajorVersion.VERSION_2);
        }
        if (spdxFile != null && spdxFile.exists()) {
            LOG.debug("Dependency {}Looking for SPDX file {}", (Object)artifact.getArtifactId(), (Object)spdxFile.getAbsolutePath());
            try {
                LOG.debug("Dependency {}Dependency information collected from SPDX file {}", (Object)artifact.getArtifactId(), (Object)spdxFile.getAbsolutePath());
                SpdxDocument externalSpdxDoc = SpdxV2DependencyBuilder.spdxDocumentFromFile(spdxFile.getPath());
                if (this.createExternalRefs) {
                    return this.createExternalSpdxPackageReference(externalSpdxDoc, spdxFile, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                }
                return this.copyPackageInfoFromExternalDoc(externalSpdxDoc, artifact.getArtifactId());
            }
            catch (IOException e) {
                LOG.warn("IO error reading SPDX document for dependency artifact ID {}:{}.  Using POM file information for creating SPDX package data.", (Object)artifact.getArtifactId(), (Object)e.getMessage());
            }
            catch (SpdxInvalidIdException e) {
                LOG.warn("Invalid SPDX ID exception reading SPDX document for dependency artifact ID {}:{}.  Using POM file information for creating SPDX package data.", (Object)artifact.getArtifactId(), (Object)e.getMessage());
            }
            catch (InvalidSPDXAnalysisException e) {
                LOG.warn("Invalid SPDX analysis exception reading SPDX document for dependency artifact ID {}:{}.  Using POM file information for creating SPDX package data.", (Object)artifact.getArtifactId(), (Object)e.getMessage());
            }
            catch (SpdxCollectionException e) {
                LOG.warn("Unable to create file checksum for external SPDX document for dependency artifact ID {}:{}.  Using POM file information for creating SPDX package data.", (Object)artifact.getArtifactId(), (Object)e.getMessage());
            }
            catch (Exception e) {
                LOG.warn("Unknown error processing SPDX document for dependency artifact ID {}:{}.  Using POM file information for creating SPDX package data.", (Object)artifact.getArtifactId(), (Object)e.getMessage());
            }
        }
        try {
            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
            request.setProcessPlugins(false);
            request.setRemoteRepositories(mavenProject.getRemoteArtifactRepositories());
            for (ArtifactRepository ar : request.getRemoteRepositories()) {
                LOG.debug("request Remote repository ID: {}", (Object)ar.getId());
            }
            for (ArtifactRepository ar : mavenProject.getRemoteArtifactRepositories()) {
                LOG.debug("Project Remote repository ID: {}", (Object)ar.getId());
            }
            ProjectBuildingResult build = mavenProjectBuilder.build(artifact, (ProjectBuildingRequest)request);
            MavenProject depProject = build.getProject();
            LOG.debug("Dependency {}Collecting information from project metadata for {}", (Object)artifact.getArtifactId(), (Object)depProject.getArtifactId());
            return this.createSpdxPackage(depProject, useArtifactID);
        }
        catch (SpdxCollectionException e) {
            LOG.error("SPDX File Collection Error creating SPDX package for dependency artifact ID {}:{}", (Object)artifact.getArtifactId(), (Object)e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Verification Code Error creating SPDX package for dependency artifact ID {}:{}", (Object)artifact.getArtifactId(), (Object)e.getMessage());
        }
        catch (ProjectBuildingException e) {
            LOG.error("Maven Project Build Error creating SPDX package for dependency artifact ID {}:{}", (Object)artifact.getArtifactId(), (Object)e.getMessage());
        }
        LOG.warn("Error creating SPDX package for dependency artifact ID {}.  A minimal SPDX package will be created.", (Object)artifact.getArtifactId());
        LOG.debug("Dependency {}Using only artifact information to create dependent package", (Object)artifact.getArtifactId());
        return this.spdxDoc.createPackage(IdGenerator.getIdGenerator().generateId(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion()), artifact.getArtifactId(), (AnyLicenseInfo)new SpdxNoAssertionLicense(), "NOASSERTION", (AnyLicenseInfo)new SpdxNoAssertionLicense()).setComment("This package was created for a Maven dependency.  No SPDX or license information could be found in the Maven POM file.").setVersionInfo(artifact.getBaseVersion()).setFilesAnalyzed(false).setDownloadLocation("NOASSERTION").setExternalRefs(SpdxExternalRefBuilder.getDefaultExternalRefs(this.spdxDoc, this.generatePurls, mavenProject)).build();
    }

    private SpdxElement createExternalSpdxPackageReference(SpdxDocument externalSpdxDoc, File spdxFile, String groupId, String artifactId, @Nullable String version) throws SpdxCollectionException, InvalidSPDXAnalysisException {
        String externalDocNamespace = externalSpdxDoc.getDocumentUri();
        ExternalDocumentRef externalRef = this.externalDocuments.get(externalDocNamespace);
        StringBuilder sb = new StringBuilder(groupId).append(artifactId);
        if (Objects.nonNull(version)) {
            sb.append(version);
        }
        String fullArtifactId = sb.toString();
        if (externalRef == null) {
            String externalRefDocId = SpdxConstantsCompatV2.EXTERNAL_DOC_REF_PRENUM + this.fixExternalRefId(fullArtifactId);
            LOG.debug("Creating external document ref {}", (Object)externalDocNamespace);
            Checksum mavenChecksum = AbstractFileCollector.generateSha1(spdxFile);
            org.spdx.library.model.v2.Checksum cksum = this.spdxDoc.createChecksum(ChecksumAlgorithm.valueOf((String)mavenChecksum.getAlgorithm()), mavenChecksum.getValue());
            externalRef = this.spdxDoc.createExternalDocumentRef(externalRefDocId, externalSpdxDoc.getDocumentUri(), cksum);
            this.spdxDoc.getExternalDocumentRefs().add(externalRef);
            Annotation docRefAddedAnnotation = this.spdxDoc.createAnnotation("Tool: spdx-maven-plugin", AnnotationType.OTHER, this.format.format(new Date()), "External document ref '" + externalRefDocId + "' created for artifact " + fullArtifactId);
            this.spdxDoc.getAnnotations().add(docRefAddedAnnotation);
            this.externalDocuments.put(externalDocNamespace, externalRef);
            LOG.debug("Created external document ref {}", (Object)externalRefDocId);
        }
        SpdxPackage pkg = SpdxV2DependencyBuilder.findMatchingDescribedPackage(externalSpdxDoc, artifactId);
        return new ExternalSpdxElement(this.spdxDoc.getModelStore(), this.spdxDoc.getDocumentUri(), externalRef.getId() + ":" + pkg.getId(), this.spdxDoc.getCopyManager(), true);
    }

    private SpdxPackage copyPackageInfoFromExternalDoc(SpdxDocument externalSpdxDoc, String artifactId) throws InvalidSPDXAnalysisException {
        Optional versionInfo;
        Optional validUntil;
        Optional supplier;
        Optional summary;
        Optional sourceInfo;
        Optional releaseDate;
        Optional primaryPurpose;
        Optional pkgFileName;
        Optional originator;
        Optional licenseComments;
        Optional homePage;
        Optional desc;
        Optional comment;
        SpdxPackage source = SpdxV2DependencyBuilder.findMatchingDescribedPackage(externalSpdxDoc, artifactId);
        Optional downloadLocation = source.getDownloadLocation();
        Optional name = source.getName();
        SpdxPackage dest = this.spdxDoc.createPackage(IdGenerator.getIdGenerator().generateId(externalSpdxDoc.getId() + source.getName()), name.orElse("NONE"), source.getLicenseConcluded(), source.getCopyrightText(), source.getLicenseDeclared()).setFilesAnalyzed(false).setAnnotations(source.getAnnotations()).setChecksums(source.getChecksums()).setDownloadLocation(downloadLocation.orElse("NOASSERTION")).setExternalRefs(source.getExternalRefs()).build();
        Optional builtDate = source.getBuiltDate();
        if (builtDate.isPresent()) {
            dest.setBuiltDate((String)builtDate.get());
        }
        if ((comment = source.getComment()).isPresent()) {
            dest.setComment((String)comment.get());
        }
        if ((desc = source.getDescription()).isPresent()) {
            dest.setDescription((String)desc.get());
        }
        if ((homePage = source.getHomepage()).isPresent()) {
            dest.setHomepage((String)homePage.get());
        }
        if ((licenseComments = source.getLicenseComments()).isPresent()) {
            dest.setLicenseComments((String)licenseComments.get());
        }
        if ((originator = source.getOriginator()).isPresent()) {
            dest.setOriginator((String)originator.get());
        }
        if ((pkgFileName = source.getPackageFileName()).isPresent()) {
            dest.setPackageFileName((String)pkgFileName.get());
        }
        if ((primaryPurpose = source.getPrimaryPurpose()).isPresent()) {
            dest.setPrimaryPurpose((Purpose)primaryPurpose.get());
        }
        if ((releaseDate = source.getReleaseDate()).isPresent()) {
            dest.setReleaseDate((String)releaseDate.get());
        }
        if ((sourceInfo = source.getSourceInfo()).isPresent()) {
            dest.setSourceInfo((String)sourceInfo.get());
        }
        if ((summary = source.getSummary()).isPresent()) {
            dest.setSummary((String)summary.get());
        }
        if ((supplier = source.getSupplier()).isPresent()) {
            dest.setSupplier((String)supplier.get());
        }
        if ((validUntil = source.getValidUntilDate()).isPresent()) {
            dest.setValidUntilDate((String)validUntil.get());
        }
        if ((versionInfo = source.getVersionInfo()).isPresent()) {
            dest.setVersionInfo((String)versionInfo.get());
        }
        return dest;
    }

    private AnyLicenseInfo mavenLicensesToSpdxLicense(List<License> mavenLicenses) throws LicenseMapperException, InvalidSPDXAnalysisException {
        try {
            return this.licenseManager.mavenLicenseListToSpdxLicense(mavenLicenses);
        }
        catch (LicenseManagerException ex) {
            return MavenToSpdxLicenseMapper.getInstance().mavenLicenseListToSpdxV2License(mavenLicenses, this.spdxDoc);
        }
    }

    public void addLicenseOverwrite(LicenseOverwrite licenseOverwrite, AnyLicenseInfo parsedLicense) {
        this.licenseOverwrites.put(licenseOverwrite, parsedLicense);
    }

    Optional<AnyLicenseInfo> applyLicenseOverwrites(MavenProject mavenProject, String target) {
        return this.licenseOverwrites.entrySet().stream().filter(overwrite -> ((LicenseOverwrite)overwrite.getKey()).appliesTo(mavenProject, target)).reduce((a, b) -> {
            throw new IllegalStateException("multiple matching license overwrites: " + a.getKey() + " vs. " + b.getKey());
        }).map(Map.Entry::getValue);
    }
}

