/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.NameAndSourceAttributes;

public class ClassAttributes
extends NameAndSourceAttributes {
    public static final String INTERFACE = "interface";
    public static final String ABSTRACT_CLASS = "abstract class";
    public static final String CLASS = "class";
    public static final String UNKNOWN = "unknown external class";
    private final String _type;
    private final boolean _innerClass;
    private final int _size;

    public ClassAttributes(String name, String source, String type, int size) {
        super(name);
        if (source != null) {
            this.addSource(source);
        }
        this._type = type;
        this._innerClass = name != null && name.indexOf(36) > 0;
        this._size = size;
    }

    public static ClassAttributes createInterface(String name, String source, int size) {
        return new ClassAttributes(name, source, INTERFACE, size);
    }

    public static ClassAttributes createAbstractClass(String name, String source, int size) {
        return new ClassAttributes(name, source, ABSTRACT_CLASS, size);
    }

    public static ClassAttributes createClass(String name, String source, int size) {
        return new ClassAttributes(name, source, CLASS, size);
    }

    public static ClassAttributes createUnknownClass(String name, int size) {
        return new ClassAttributes(name, null, UNKNOWN, size);
    }

    public String getType() {
        return this._type;
    }

    public boolean isInnerClass() {
        return this._innerClass;
    }

    public int getSize() {
        return this._size;
    }

    public String toString() {
        String sources;
        StringBuffer buffer = new StringBuffer(this._innerClass ? "inner " : "");
        buffer.append(this._type).append(' ').append(this.getName());
        if (this._size > 0) {
            buffer.append(" (").append(this._size).append(" bytes)");
        }
        if ((sources = this.getSources()).length() > 0) {
            buffer.append(" sources: ").append(sources);
        }
        return new String(buffer);
    }
}

