/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.matchers.ArrayEquals;
import org.mockito.internal.matchers.Equals;
import org.mockito.internal.matchers.EqualsFunction0;
import org.mockito.internal.matchers.EqualsFunction1;
import org.mockito.internal.progress.ThreadSafeMockingProgress2$;
import org.specs2.matcher.Matcher;
import org.specs2.mock.ArgumentMatcherAdapter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ArgumentsProcessor$ {
    public static final ArgumentsProcessor$ MODULE$ = new ArgumentsProcessor$();

    public Object[] expandArgs(MockitoMethod method, Object[] args) {
        int nParams = method.getParameterTypes().length;
        if (args != null && args.length > nParams) {
            return this.expandVarArgs(method.isVarArgs(), Arrays.copyOf(args, nParams));
        }
        return args;
    }

    public Object[] expandVarArgs(boolean isVarArgs, Object[] args) {
        if (!isVarArgs || ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps(args)) || args[args.length - 1] != null && !args[args.length - 1].getClass().isArray()) {
            if (args == null) {
                return (Object[])Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.Object());
            }
            return args;
        }
        int nonVarArgsCount = args.length - 1;
        Object[] varArgs = null;
        varArgs = args[nonVarArgsCount] == null ? new Object[]{null} : ArrayEquals.createObjectArray((Object)args[nonVarArgsCount]);
        int varArgsCount = varArgs.length;
        Object[] newArgs = (Object[])Array$.MODULE$.ofDim(nonVarArgsCount + varArgsCount, ClassTag$.MODULE$.Object());
        System.arraycopy(args, 0, newArgs, 0, nonVarArgsCount);
        System.arraycopy(varArgs, 0, newArgs, nonVarArgsCount, varArgsCount);
        return newArgs;
    }

    public List<ArgumentMatcher<?>> argumentsToMatchers(Object[] arguments) {
        ArrayList matchers = new ArrayList(arguments.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(arguments), (Function1 & Serializable)arg -> {
            if (arg != null && arg.getClass().isArray()) {
                return BoxesRunTime.boxToBoolean((boolean)matchers.add((ArgumentMatcher<?>)new ArrayEquals(arg)));
            }
            if (arg != null && arg.getClass().getName().startsWith("scala.collection.mutable.WrappedArray")) {
                return BoxesRunTime.boxToBoolean((boolean)matchers.add((ArgumentMatcher<?>)new Equals(arg)));
            }
            if (arg instanceof Function0) {
                Function0 function0 = (Function0)arg;
                if (!MODULE$.isCallRealMethod()) {
                    Object object;
                    try {
                        object = function0.apply();
                    }
                    catch (Throwable e) {
                        object = e;
                    }
                    Object value = object;
                    Buffer after = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(ThreadSafeMockingProgress2$.MODULE$.pullLocalizedMatchers()).asScala();
                    List argumentsMatchers = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)after.map((Function1 & Serializable)m -> MODULE$.adaptFunction0((ArgumentMatcher<?>)m))).asJava();
                    if (argumentsMatchers.isEmpty()) {
                        return BoxesRunTime.boxToBoolean((boolean)matchers.add((ArgumentMatcher<?>)new EqualsFunction0(value)));
                    }
                    matchers.addAll(argumentsMatchers);
                    ThreadSafeMockingProgress2$.MODULE$.reportMatchers(argumentsMatchers);
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            if (arg instanceof Matcher) {
                return BoxesRunTime.boxToBoolean((boolean)matchers.add(new ArgumentMatcherAdapter((Matcher)arg)));
            }
            if (arg instanceof Seq || arg instanceof Set) {
                return BoxesRunTime.boxToBoolean((boolean)matchers.add((ArgumentMatcher<?>)new Equals(arg)));
            }
            if (arg instanceof AbstractFunction1) {
                return BoxesRunTime.boxToBoolean((boolean)matchers.add((ArgumentMatcher<?>)new EqualsFunction1(arg)));
            }
            return BoxesRunTime.boxToBoolean((boolean)matchers.add((ArgumentMatcher<?>)new Equals(arg)));
        });
        return matchers;
    }

    public boolean isCallRealMethod() {
        return Predef$.MODULE$.wrapRefArray((Object[])new Exception().getStackTrace()).toList().exists((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ArgumentsProcessor$.$anonfun$isCallRealMethod$1(t)));
    }

    public ArgumentMatcher<?> adaptFunction0(ArgumentMatcher<?> m) {
        return new ArgumentMatcher<Object>(m){
            private final ArgumentMatcher m$1;

            public Class<?> type() {
                return super.type();
            }

            public boolean matches(Object a) {
                if (a instanceof Function0) {
                    Object value = ((Function0)a).apply();
                    return this.m$1.matches(value);
                }
                return this.m$1.matches(a);
            }
            {
                this.m$1 = m$1;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isCallRealMethod$1(StackTraceElement t) {
        String string = t.getClassName();
        String string2 = "org.mockito.internal.invocation.InterceptedInvocation";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = t.getMethodName();
        String string4 = "callRealMethod";
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    private ArgumentsProcessor$() {
    }
}

