/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.mockito.internal.matchers.ArrayEquals;
import org.mockito.internal.matchers.Equals;
import org.mockito.internal.matchers.EqualsFunction0;
import org.mockito.internal.matchers.EqualsFunction1;
import org.mockito.internal.matchers.LocalizedMatcher;
import org.mockito.internal.progress.ThreadSafeMockingProgress2$;
import org.mockito.internal.util.collections.ArrayUtils;
import org.specs2.mock.HamcrestMatcherAdapter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenSeqLike;
import scala.collection.GenSetLike;
import scala.collection.JavaConversions$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ArgumentsProcessor$ {
    public static final ArgumentsProcessor$ MODULE$;

    static {
        new ArgumentsProcessor$();
    }

    public Object[] expandVarArgs(boolean isVarArgs, Object[] args) {
        Object[] objectArray;
        if (isVarArgs && !new ArrayUtils().isEmpty(args) && (args[args.length - 1] == null || args[args.length - 1].getClass().isArray())) {
            int nonVarArgsCount = args.length - 1;
            Object[] varArgs = null;
            varArgs = args[nonVarArgsCount] == null ? new Object[]{null} : ArrayEquals.createObjectArray((Object)args[nonVarArgsCount]);
            int varArgsCount = varArgs.length;
            Object[] newArgs = (Object[])Array$.MODULE$.ofDim(nonVarArgsCount + varArgsCount, ClassTag$.MODULE$.Object());
            System.arraycopy(args, 0, newArgs, 0, nonVarArgsCount);
            System.arraycopy(varArgs, 0, newArgs, nonVarArgsCount, varArgsCount);
            objectArray = newArgs;
        } else {
            objectArray = args == null ? (Object[])Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.Object()) : args;
        }
        return objectArray;
    }

    public List<Matcher<?>> argumentsToMatchers(Object[] arguments2) {
        ObjectRef matchers = ObjectRef.create(new ArrayList(arguments2.length));
        Predef$.MODULE$.refArrayOps(arguments2).foreach((Function1)new Serializable(matchers){
            public static final long serialVersionUID = 0L;
            private final ObjectRef matchers$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object apply(Object arg) {
                Object object;
                Boolean bl;
                if (arg != null && arg.getClass().isArray()) {
                    bl = BoxesRunTime.boxToBoolean((boolean)((List)this.matchers$1.elem).add(new ArrayEquals(arg)));
                    return bl;
                }
                if (arg != null && arg.getClass().getName().startsWith("scala.collection.mutable.WrappedArray")) {
                    bl = BoxesRunTime.boxToBoolean((boolean)((List)this.matchers$1.elem).add(new Equals(arg)));
                    return bl;
                }
                if (arg instanceof Function0) {
                    try {
                        object = ((Function0)arg).apply();
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                    }
                } else {
                    if (arg instanceof org.specs2.matcher.Matcher) {
                        bl = BoxesRunTime.boxToBoolean((boolean)((List)this.matchers$1.elem).add(new HamcrestMatcherAdapter<T>((org.specs2.matcher.Matcher)arg)));
                        return bl;
                    }
                    if (arg instanceof GenSeqLike || arg instanceof GenSetLike) {
                        bl = BoxesRunTime.boxToBoolean((boolean)((List)this.matchers$1.elem).add(new Equals(arg)));
                        return bl;
                    }
                    if (arg instanceof Function1) {
                        bl = BoxesRunTime.boxToBoolean((boolean)((List)this.matchers$1.elem).add(new EqualsFunction1(arg)));
                        return bl;
                    }
                    bl = BoxesRunTime.boxToBoolean((boolean)((List)this.matchers$1.elem).add(new Equals(arg)));
                    return bl;
                }
                Object value2 = object;
                List<LocalizedMatcher> argumentsMatchers = ThreadSafeMockingProgress2$.MODULE$.pullLocalizedMatchers();
                if (argumentsMatchers.isEmpty()) {
                    bl = BoxesRunTime.boxToBoolean((boolean)((List)this.matchers$1.elem).add(new EqualsFunction0(value2)));
                    return bl;
                }
                ((List)this.matchers$1.elem).addAll(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(argumentsMatchers).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Matcher<?> apply(LocalizedMatcher x$1) {
                        return x$1.getActualMatcher();
                    }
                }, Buffer$.MODULE$.canBuildFrom())));
                ThreadSafeMockingProgress2$.MODULE$.reportMatchers(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(argumentsMatchers).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Matcher<?> apply(LocalizedMatcher x$2) {
                        return x$2.getActualMatcher();
                    }
                }, Buffer$.MODULE$.canBuildFrom())));
                bl = BoxedUnit.UNIT;
                return bl;
            }
            {
                this.matchers$1 = matchers$1;
            }
        });
        return (List)matchers.elem;
    }

    private ArgumentsProcessor$() {
        MODULE$ = this;
    }
}

