/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.aspects;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.annotations.PerformanceMonitor;
import org.spf4j.annotations.RecorderSourceInstance;
import org.spf4j.base.TimeSource;
import org.spf4j.concurrent.UnboundedLoadingCache;
import org.spf4j.perf.MeasurementRecorderSource;

@Aspect
public final class PerformanceMonitorAspect {
    private static final Logger LOG = LoggerFactory.getLogger(PerformanceMonitorAspect.class);
    private static final LoadingCache<Class<? extends RecorderSourceInstance>, MeasurementRecorderSource> REC_SOURCES = new UnboundedLoadingCache(32, (CacheLoader)new CacheLoader<Class<? extends RecorderSourceInstance>, MeasurementRecorderSource>(){

        public MeasurementRecorderSource load(Class<? extends RecorderSourceInstance> key) throws Exception {
            return (MeasurementRecorderSource)key.getField("INSTANCE").get(null);
        }
    });

    @Around(value="@annotation(annot) && execution(@org.spf4j.annotations.PerformanceMonitor * *(..))", argNames="pjp,annot")
    public Object performanceMonitoredMethod(ProceedingJoinPoint pjp, PerformanceMonitor annot) throws Throwable {
        long start = TimeSource.nanoTime();
        Object result = pjp.proceed();
        long elapsedNanos = TimeSource.nanoTime() - start;
        long elapsed = TimeUnit.NANOSECONDS.toMillis(elapsedNanos);
        MeasurementRecorderSource mrs = (MeasurementRecorderSource)REC_SOURCES.getUnchecked(annot.recorderSource());
        mrs.getRecorder((Object)pjp.toLongString()).record(elapsed);
        long warnThresholdMillis = annot.warnThresholdMillis();
        if (elapsed > warnThresholdMillis) {
            long errorThresholdMillis = annot.errorThresholdMillis();
            if (elapsed > errorThresholdMillis) {
                LOG.error("Execution time  {} ms for {} exceeds error threshold of {} ms, arguments {}", new Object[]{elapsed, pjp.toShortString(), errorThresholdMillis, pjp.getArgs()});
            } else {
                LOG.warn("Execution time  {} ms for {} exceeds warning threshold of {} ms, arguments {}", new Object[]{elapsed, pjp.toShortString(), warnThresholdMillis, pjp.getArgs()});
            }
        } else if (annot.defaultInfoLog()) {
            LOG.info("Execution time {} ms for {}, arguments {}", new Object[]{elapsed, pjp.toShortString(), pjp.getArgs()});
        } else {
            LOG.debug("Execution time {} ms for {}, arguments {}", new Object[]{elapsed, pjp.toShortString(), pjp.getArgs()});
        }
        return result;
    }
}

