/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.aspects;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.spf4j.base.InstrumentationHelper;
import org.spf4j.base.MutableInteger;
import org.spf4j.perf.MeasurementRecorderSource;
import org.spf4j.perf.aspects.AllocationMonitorAspect;
import org.spf4j.perf.aspects.ThreadLocalCounter;
import org.spf4j.perf.impl.RecorderFactory;
import org.spf4j.stackmonitor.StackTrace;

@Aspect
public final class SamplingAllocationMonitorAspect {
    private static final MeasurementRecorderSource RECORDER;
    private static final int SAMPLE_COUNT;

    @AfterReturning(pointcut="call(*.new(..))", returning="obj", argNames="jp,obj")
    public void afterAllocation(JoinPoint jp, Object obj) {
        MutableInteger counter = ThreadLocalCounter.get();
        int value = counter.getValue();
        if (value < SAMPLE_COUNT) {
            counter.setValue(value + 1);
        } else {
            counter.setValue(0);
            StackTrace st = StackTrace.from((StackTraceElement[])Thread.currentThread().getStackTrace(), (int)2);
            RECORDER.getRecorder((Object)st).record(InstrumentationHelper.getObjectSize((Object)obj));
        }
    }

    static {
        SAMPLE_COUNT = Integer.getInteger("spf4j.perf.allocations.sampleCount", 100);
        RECORDER = RecorderFactory.createScalableCountingRecorderSource((Object)"allocations.sampling", (String)"bytes", (int)AllocationMonitorAspect.SAMPLE_TIME_MILLIS);
    }
}

