/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.spf4j.base.ArrayWriter;

@ThreadSafe
public final class AvroArrayWriter<T>
implements ArrayWriter<T> {
    private final Object[] buffer;
    private final Encoder encoder;
    private final DatumWriter<T> writer;
    private int at;
    private boolean start;
    private boolean isClosed;

    @Deprecated
    public AvroArrayWriter(Encoder encoder, DatumWriter<T> elementWriter, Class<T> type, int bufferSize) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Invalid buffer size " + bufferSize);
        }
        this.encoder = encoder;
        this.writer = elementWriter;
        this.buffer = (Object[])Array.newInstance(type, bufferSize);
        this.at = 0;
        this.start = true;
        this.isClosed = false;
    }

    public AvroArrayWriter(Encoder encoder, DatumWriter<T> elementWriter, int bufferSize) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Invalid buffer size " + bufferSize);
        }
        this.encoder = encoder;
        this.writer = elementWriter;
        this.buffer = new Object[bufferSize];
        this.at = 0;
        this.start = true;
        this.isClosed = false;
    }

    public synchronized void write(T t) throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("writer " + this + " already closed");
        }
        this.buffer[this.at++] = t;
        if (this.at >= this.buffer.length) {
            this.writeBuffer();
        }
    }

    private void writeBuffer() throws IOException {
        if (this.start) {
            this.encoder.writeArrayStart();
            this.start = false;
        }
        this.encoder.setItemCount((long)this.at);
        for (int i = 0; i < this.at; ++i) {
            this.encoder.startItem();
            this.writer.write(this.buffer[i], this.encoder);
            this.buffer[i] = null;
        }
        this.at = 0;
    }

    public synchronized void flush() throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("writer " + this + " already closed");
        }
        this.writeBuffer();
        this.encoder.flush();
    }

    public synchronized void close() throws IOException {
        if (!this.isClosed) {
            this.writeBuffer();
            this.encoder.writeArrayEnd();
            this.encoder.flush();
            this.isClosed = true;
        }
    }

    public String toString() {
        return "AvroArrayWriter{buffer=" + Arrays.toString(this.buffer) + ", encoder=" + this.encoder + ", writer=" + this.writer + ", at=" + this.at + ", start=" + this.start + ", isClosed=" + this.isClosed + '}';
    }
}

