/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.spf4j.base.Pair;

public final class MapIterator<T>
implements Iterator<Map.Entry<String, T>> {
    private final Decoder decoder;
    private final DatumReader<T> reader;
    private long l;

    public MapIterator(Decoder decoder, DatumReader<T> valueReader) {
        this.decoder = decoder;
        this.reader = valueReader;
        try {
            this.l = decoder.readMapStart();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public boolean hasNext() {
        return this.l > 0L;
    }

    @Override
    public Map.Entry<String, T> next() {
        try {
            if (this.l <= 0L) {
                throw new NoSuchElementException();
            }
            String key = this.decoder.readString();
            Object read = this.reader.read(null, this.decoder);
            --this.l;
            if (this.l <= 0L) {
                this.l = this.decoder.mapNext();
            }
            return Pair.of((Object)key, (Object)read);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String toString() {
        return "ArrayIterator{decoder=" + this.decoder + ", reader=" + this.reader + ", l=" + this.l + '}';
    }
}

