/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.avro.AvroTypeException;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.data.Json;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.reflect.AvroDefault;
import org.apache.avro.reflect.AvroDoc;
import org.apache.avro.reflect.AvroIgnore;
import org.apache.avro.reflect.AvroMeta;
import org.apache.avro.reflect.AvroMetas;
import org.apache.avro.reflect.AvroName;
import org.apache.avro.reflect.AvroSchema;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.Union;
import org.apache.avro.specific.FixedSize;
import org.apache.avro.specific.SpecificRecordBase;

public final class ExtendedReflectData
extends ReflectData {
    private static final ExtendedReflectData INSTANCE = new ExtendedReflectData();
    private static final Schema NONE = Schema.create((Schema.Type)Schema.Type.NULL);
    private final ConcurrentMap<Type, Schema> type2SchemaMap = new ConcurrentHashMap<Type, Schema>();

    public static ExtendedReflectData get() {
        return INSTANCE;
    }

    @Nullable
    public Schema getSchema(Type type) {
        Schema result = this.type2SchemaMap.computeIfAbsent(type, t -> {
            try {
                return this.createSchema((Type)t, new HashMap());
            }
            catch (RuntimeException ex) {
                Logger.getLogger(ExtendedReflectData.class.getName()).log(Level.FINE, "Unable to create schema for " + type, ex);
                return NONE;
            }
        });
        return result == NONE ? null : result;
    }

    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX"})
    public Schema createSchema(Type type, Object object, Map<String, Schema> names) {
        if (type instanceof TypeVariable) {
            String name = ((TypeVariable)type).getName();
            Schema schema = names.get(name);
            if (schema == null) {
                throw new IllegalArgumentException("Undefined type variable " + type);
            }
            return schema;
        }
        if (type instanceof GenericArrayType) {
            Schema result;
            Type component = ((GenericArrayType)type).getGenericComponentType();
            if (component == Byte.TYPE) {
                return Schema.create((Schema.Type)Schema.Type.BYTES);
            }
            if (Array.getLength(object) > 0) {
                result = Schema.createArray((Schema)this.createSchema(component, Array.get(object, 0), names));
                this.setElement(result, component);
            } else {
                result = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.NULL));
                this.setElement(result, component);
            }
            return result;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Class raw = (Class)ptype.getRawType();
            Type[] params = ptype.getActualTypeArguments();
            if (Map.class.isAssignableFrom(raw)) {
                Map map = (Map)object;
                Class key = (Class)params[0];
                if (this.isStringable(key)) {
                    Schema schema = map.isEmpty() ? Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.NULL)) : Schema.createMap((Schema)this.createSchema(params[1], map.values().iterator().next(), names));
                    schema.addProp("java-class", key.getName());
                    return schema;
                }
                if (key != String.class) {
                    Schema schema;
                    if (map.isEmpty()) {
                        schema = Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.NULL));
                    } else {
                        Map.Entry next = map.entrySet().iterator().next();
                        schema = this.createNonStringMapSchema(next.getKey().getClass(), next.getKey().getClass(), names);
                    }
                    schema.addProp("java-class", raw.getName());
                    return schema;
                }
            } else if (Collection.class.isAssignableFrom(raw)) {
                Iterable col = (Iterable)object;
                Iterator iterator = col.iterator();
                if (iterator.hasNext()) {
                    Schema schema = Schema.createArray((Schema)this.createSchema(params[0], iterator.next(), names));
                    schema.addProp("java-class", raw.getName());
                    return schema;
                }
                Schema schema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.NULL));
                schema.addProp("java-class", raw.getName());
                return schema;
            }
        } else {
            if (type == Byte.class || type == Byte.TYPE) {
                Schema result = Schema.create((Schema.Type)Schema.Type.INT);
                result.addProp("java-class", Byte.class.getName());
                return result;
            }
            if (type == Short.class || type == Short.TYPE) {
                Schema result = Schema.create((Schema.Type)Schema.Type.INT);
                result.addProp("java-class", Short.class.getName());
                return result;
            }
            if (type == Character.class || type == Character.TYPE) {
                Schema result = Schema.create((Schema.Type)Schema.Type.INT);
                result.addProp("java-class", Character.class.getName());
                return result;
            }
            if (type instanceof Class) {
                return this.createSchemaFromClass((Class)type, object, names);
            }
        }
        return super.createSchema(type, names);
    }

    private Schema createSchemaFromClass(Class<?> c, Object object, Map<String, Schema> names) {
        String fullName;
        Schema schema;
        if (c == Void.class || c == Boolean.class || c == Integer.class || c == Long.class || c == Float.class || c == Double.class || c == Byte.class || c == Short.class || c == Character.class || c.isPrimitive()) {
            return super.createSchema(c, names);
        }
        if (c.isArray()) {
            Class<?> component = c.getComponentType();
            if (component == Byte.TYPE) {
                Schema result = Schema.create((Schema.Type)Schema.Type.BYTES);
                result.addProp("java-class", c.getName());
                return result;
            }
            Schema result = Schema.createArray((Schema)this.createSchema(component, names));
            result.addProp("java-class", c.getName());
            this.setElement(result, component);
            return result;
        }
        AvroSchema explicit = c.getAnnotation(AvroSchema.class);
        if (explicit != null) {
            return new Schema.Parser().parse(explicit.value());
        }
        if (CharSequence.class.isAssignableFrom(c)) {
            return Schema.create((Schema.Type)Schema.Type.STRING);
        }
        if (ByteBuffer.class.isAssignableFrom(c)) {
            return Schema.create((Schema.Type)Schema.Type.BYTES);
        }
        if (Iterable.class.isAssignableFrom(c)) {
            Iterable col = (Iterable)object;
            Iterator iterator = col.iterator();
            if (iterator.hasNext()) {
                Object next = iterator.next();
                return Schema.createArray((Schema)this.createSchema(next.getClass(), next, names));
            }
            return Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.NULL));
        }
        if (Map.class.isAssignableFrom(c)) {
            Map map = (Map)object;
            if (map.isEmpty()) {
                return Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.NULL));
            }
            Map.Entry elem = map.entrySet().iterator().next();
            Class<?> key = elem.getKey().getClass();
            if (this.isStringable(key) || CharSequence.class.isAssignableFrom(key)) {
                Schema schema2 = Schema.createMap((Schema)this.createSchema(elem.getValue().getClass(), elem.getValue(), names));
                if (key != String.class) {
                    schema2.addProp("java-class", key.getName());
                }
                return schema2;
            }
            if (key != String.class) {
                return this.createNonStringMapSchema(elem.getKey().getClass(), elem.getValue().getClass(), names);
            }
        }
        if ((schema = names.get(fullName = c.getName())) == null) {
            Union union;
            AvroDoc annotatedDoc = c.getAnnotation(AvroDoc.class);
            String doc = annotatedDoc != null ? annotatedDoc.value() : null;
            String name = c.getSimpleName();
            String space = c.getPackage() == null ? "" : c.getPackage().getName();
            Class<?> enclosingClass = c.getEnclosingClass();
            if (enclosingClass != null) {
                space = enclosingClass.getName();
            }
            if ((union = c.getAnnotation(Union.class)) != null) {
                return this.getAnnotatedUnion(union, names);
            }
            if (this.isStringable(c)) {
                Schema result = Schema.create((Schema.Type)Schema.Type.STRING);
                result.addProp("java-class", c.getName());
                return result;
            }
            if (c.isEnum()) {
                Enum[] constants = (Enum[])c.getEnumConstants();
                ArrayList<String> symbols = new ArrayList<String>(constants.length);
                for (int i = 0; i < constants.length; ++i) {
                    symbols.add(constants[i].name());
                }
                schema = Schema.createEnum((String)name, (String)doc, (String)space, symbols);
                this.consumeAvroAliasAnnotation(c, schema);
            } else if (GenericFixed.class.isAssignableFrom(c)) {
                int size = c.getAnnotation(FixedSize.class).value();
                schema = Schema.createFixed((String)name, (String)doc, (String)space, (int)size);
                this.consumeAvroAliasAnnotation(c, schema);
            } else {
                if (IndexedRecord.class.isAssignableFrom(c)) {
                    if (SpecificRecordBase.class.isAssignableFrom(c)) {
                        return super.createSchema(c, names);
                    }
                    return ((GenericRecord)object).getSchema();
                }
                schema = this.createRecordSchema(c, name, space, doc, names);
            }
            names.put(fullName, schema);
        }
        return schema;
    }

    private Schema createRecordSchema(Class<?> c, String name, String space, String doc, Map<String, Schema> names) {
        AvroMeta meta;
        boolean error = Throwable.class.isAssignableFrom(c);
        Schema schema = Schema.createRecord((String)name, (String)doc, (String)space, (boolean)error);
        this.consumeAvroAliasAnnotation(c, schema);
        names.put(c.getName(), schema);
        Field[] cachedFields = ExtendedReflectData.getCachedFields(c);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>(cachedFields.length);
        for (Field field : cachedFields) {
            AvroMeta meta2;
            AvroName annotatedName;
            Schema defaultType;
            String fdoc;
            if ((field.getModifiers() & 0x88) != 0 || field.isAnnotationPresent(AvroIgnore.class)) continue;
            Schema fieldSchema = this.createFieldSchema(field, names);
            AvroDefault defaultAnnotation = field.getAnnotation(AvroDefault.class);
            Object defaultValue = defaultAnnotation == null ? null : Json.parseJson((String)defaultAnnotation.value());
            AvroDoc annotatedDoc = field.getAnnotation(AvroDoc.class);
            String string = fdoc = annotatedDoc != null ? annotatedDoc.value() : null;
            if (defaultValue == null && fieldSchema.getType() == Schema.Type.UNION && (defaultType = (Schema)fieldSchema.getTypes().get(0)).getType() == Schema.Type.NULL) {
                defaultValue = JsonProperties.NULL_VALUE;
            }
            String fieldName = (annotatedName = field.getAnnotation(AvroName.class)) != null ? annotatedName.value() : field.getName();
            Schema.Field recordField = new Schema.Field(fieldName, fieldSchema, fdoc, defaultValue);
            AvroMetas metas = field.getAnnotation(AvroMetas.class);
            if (metas != null) {
                for (AvroMeta meta3 : metas.value()) {
                    recordField.addProp(meta3.key(), meta3.value());
                }
            }
            if ((meta2 = field.getAnnotation(AvroMeta.class)) != null) {
                recordField.addProp(meta2.key(), meta2.value());
            }
            for (Schema.Field f : fields) {
                if (!f.name().equals(fieldName)) continue;
                throw new AvroTypeException("double field entry: " + fieldName);
            }
            this.consumeFieldAlias(field, recordField);
            fields.add(recordField);
        }
        if (error) {
            fields.add(new Schema.Field("detailMessage", THROWABLE_MESSAGE, null, null));
        }
        schema.setFields(fields);
        AvroMetas metas = c.getAnnotation(AvroMetas.class);
        if (metas != null) {
            for (AvroMeta meta4 : metas.value()) {
                schema.addProp(meta4.key(), meta4.value());
            }
        }
        if ((meta = c.getAnnotation(AvroMeta.class)) != null) {
            schema.addProp(meta.key(), meta.value());
        }
        return schema;
    }

    public String getSchemaName(Object datum) {
        return super.getSchemaName(datum);
    }

    public String toString() {
        return "ExtendedReflectData{type2SchemaMap=" + this.type2SchemaMap + '}';
    }
}

