/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.calcite;

import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.avro.generic.IndexedRecord;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.spf4j.avro.calcite.IndexedRecords;
import org.spf4j.base.CloseableIterator;

class AvroEnumerable
extends AbstractEnumerable<Object[]> {
    private final Supplier<CloseableIterator<? extends IndexedRecord>> stream;
    private final Supplier<Boolean> cancelFlag;
    private final int rowLength;

    AvroEnumerable(int rowLen, DataContext root, Supplier<CloseableIterator<? extends IndexedRecord>> stream) {
        this.rowLength = rowLen;
        this.stream = stream;
        AtomicBoolean contextFlag = (AtomicBoolean)DataContext.Variable.CANCEL_FLAG.get(root);
        this.cancelFlag = contextFlag == null ? () -> Boolean.FALSE : contextFlag::get;
    }

    public Enumerator<Object[]> enumerator() {
        return new Enumerator<Object[]>(){
            private Object[] current = null;
            private CloseableIterator<? extends IndexedRecord> iterator = (CloseableIterator)AvroEnumerable.access$000(AvroEnumerable.this).get();

            public Object[] current() {
                if (this.current == null) {
                    throw new IllegalStateException("Use moveNext on " + this);
                }
                return this.current;
            }

            public boolean moveNext() {
                if (((Boolean)AvroEnumerable.this.cancelFlag.get()).booleanValue()) {
                    throw new CancellationException("Operation cancelled on " + AvroEnumerable.this.stream + " at " + Arrays.toString(this.current));
                }
                if (this.iterator.hasNext()) {
                    IndexedRecord ir = (IndexedRecord)this.iterator.next();
                    this.current = new Object[AvroEnumerable.this.rowLength];
                    IndexedRecords.copyRecord(ir, this.current);
                    return true;
                }
                this.current = null;
                return false;
            }

            public void reset() {
                this.iterator.close();
                this.iterator = (CloseableIterator)AvroEnumerable.this.stream.get();
                this.current = null;
            }

            public void close() {
                this.iterator.close();
            }
        };
    }

    public String toString() {
        return "AvroEnumerable{stream=" + this.stream + ", rowLength=" + this.rowLength + '}';
    }
}

