/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.calcite;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.tools.Frameworks;
import org.spf4j.avro.schema.Schemas;
import org.spf4j.security.AbacSecurityContext;

@SuppressFBWarnings(value={"STT_TOSTRING_MAP_KEYING"})
public final class EmbededDataContext
implements DataContext {
    public static final String DEPRECATIONS = "deprecated-access";
    public static final String SECURITY_CONTEXT = "security-context";
    private final JavaTypeFactory typeFact;
    private final ConcurrentMap<String, Object> data;

    public static void addDeprecations(Schema schema, DataContext ctx) {
        HashMap<String, String> deprecations = new HashMap<String, String>(4);
        Schemas.deprecations(schema, deprecations::put);
        EmbededDataContext.addDeprecations(schema.getFullName(), deprecations, ctx);
    }

    public static void addDeprecations(String schemaName, Map<String, String> deprecations, DataContext ctx) {
        if (deprecations.isEmpty()) {
            return;
        }
        Map depr = (Map)ctx.get(DEPRECATIONS);
        if (depr == null) {
            return;
        }
        for (Map.Entry<String, String> entry : deprecations.entrySet()) {
            depr.put(schemaName + '.' + entry.getKey(), entry.getValue());
        }
    }

    public EmbededDataContext(JavaTypeFactory typeFact, @Nullable AbacSecurityContext ctx) {
        this.typeFact = typeFact;
        this.data = new ConcurrentHashMap<String, Object>();
        this.data.put(DEPRECATIONS, new HashMap(4));
        if (ctx != null) {
            this.data.put(SECURITY_CONTEXT, ctx);
        }
    }

    public SchemaPlus getRootSchema() {
        return Frameworks.createRootSchema((boolean)true);
    }

    public JavaTypeFactory getTypeFactory() {
        return this.typeFact;
    }

    public QueryProvider getQueryProvider() {
        return null;
    }

    public Object get(String name) {
        return this.data.get(name);
    }

    public Object put(String name, Object value) {
        return this.data.put(name, value);
    }

    public String toString() {
        return "EmbededDataContext{typeFact=" + this.typeFact + '}';
    }
}

