/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.calcite;

import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.Context;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.interpreter.Spf4jDataContext;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.spf4j.avro.calcite.IndexedRecords;
import org.spf4j.base.CloseableIterator;

@ParametersAreNonnullByDefault
class FilteringProjectingAvroEnumerable
extends AbstractEnumerable<Object[]> {
    private final Object[] rawRow;
    private final Spf4jDataContext spf4jDataContext;
    private final Scalar filterExpression;
    private final int[] projection;
    private final Supplier<CloseableIterator<? extends IndexedRecord>> stream;
    private final Supplier<Boolean> cancelFlag;

    FilteringProjectingAvroEnumerable(Schema componentType, DataContext root, @Nullable Scalar filters, @Nullable int[] projection, Supplier<CloseableIterator<? extends IndexedRecord>> stream) {
        this.rawRow = new Object[componentType.getFields().size()];
        this.spf4jDataContext = new Spf4jDataContext(root);
        this.filterExpression = filters;
        this.projection = projection;
        this.stream = stream;
        AtomicBoolean contextFlag = (AtomicBoolean)DataContext.Variable.CANCEL_FLAG.get(root);
        this.cancelFlag = contextFlag == null ? () -> Boolean.FALSE : contextFlag::get;
    }

    public Enumerator<Object[]> enumerator() {
        return new Enumerator<Object[]>(){
            private Object[] current = null;
            private CloseableIterator<? extends IndexedRecord> iterator = (CloseableIterator)FilteringProjectingAvroEnumerable.access$000(FilteringProjectingAvroEnumerable.this).get();

            public Object[] current() {
                if (this.current == null) {
                    throw new IllegalStateException("Use moveNext on " + this);
                }
                return this.current;
            }

            public boolean moveNext() {
                if (((Boolean)FilteringProjectingAvroEnumerable.this.cancelFlag.get()).booleanValue()) {
                    throw new CancellationException("Operation cancelled on " + FilteringProjectingAvroEnumerable.this.stream + " at " + Arrays.toString(this.current));
                }
                if (this.iterator.hasNext()) {
                    block6: {
                        do {
                            IndexedRecord ir = (IndexedRecord)this.iterator.next();
                            IndexedRecords.copyRecord(ir, FilteringProjectingAvroEnumerable.this.rawRow);
                            ((FilteringProjectingAvroEnumerable)FilteringProjectingAvroEnumerable.this).spf4jDataContext.values = FilteringProjectingAvroEnumerable.this.rawRow;
                            Boolean match = FilteringProjectingAvroEnumerable.this.filterExpression == null || (Boolean)FilteringProjectingAvroEnumerable.this.filterExpression.execute((Context)FilteringProjectingAvroEnumerable.this.spf4jDataContext) != false;
                            if (match.booleanValue()) break block6;
                        } while (this.iterator.hasNext());
                        this.current = null;
                        return false;
                    }
                    if (FilteringProjectingAvroEnumerable.this.projection == null) {
                        this.current = (Object[])FilteringProjectingAvroEnumerable.this.rawRow.clone();
                    } else {
                        this.current = new Object[FilteringProjectingAvroEnumerable.this.projection.length];
                        for (int i = 0; i < FilteringProjectingAvroEnumerable.this.projection.length; ++i) {
                            this.current[i] = FilteringProjectingAvroEnumerable.this.rawRow[FilteringProjectingAvroEnumerable.this.projection[i]];
                        }
                    }
                    return true;
                }
                this.current = null;
                return false;
            }

            public void reset() {
                this.iterator.close();
                this.iterator = (CloseableIterator)FilteringProjectingAvroEnumerable.this.stream.get();
                this.current = null;
            }

            public void close() {
                this.iterator.close();
            }
        };
    }

    public String toString() {
        return "FilteringProjectingAvroEnumerable{rawRow=" + Arrays.toString(this.rawRow) + ", spf4jDataContext=" + (Object)((Object)this.spf4jDataContext) + ", filterExpression=" + this.filterExpression + ", projection=" + Arrays.toString(this.projection) + ", stream=" + this.stream + ", cancelFlag=" + this.cancelFlag + '}';
    }
}

