/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.calcite;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.avro.Schema;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSqlConvertletTable;
import org.apache.calcite.rex.RexSqlStandardConvertletTable;
import org.apache.calcite.rex.RexToSqlNodeConverterImpl;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;

@ParametersAreNonnullByDefault
public final class SqlConverters {
    private static final RexSqlStandardConvertletTable TABLE = new RexSqlStandardConvertletTable();

    private SqlConverters() {
    }

    public static List<String> projectionToString(@Nullable int[] projection, RelDataType rowType) {
        if (projection == null) {
            return rowType.getFieldNames();
        }
        ArrayList<String> result = new ArrayList<String>(projection.length);
        List fieldNames = rowType.getFieldNames();
        for (int i = 0; i < projection.length; ++i) {
            result.add((String)fieldNames.get(projection[i]));
        }
        return result;
    }

    @Nullable
    public static SqlNode convert(RexNode node, final RelDataType rowType) {
        RexToSqlNodeConverterImpl conv = new RexToSqlNodeConverterImpl((RexSqlConvertletTable)TABLE){

            public SqlNode convertInputRef(RexInputRef ref) {
                return new SqlIdentifier((String)rowType.getFieldNames().get(ref.getIndex()), SqlParserPos.ZERO);
            }
        };
        return conv.convertNode(node);
    }

    public static List<SqlNode> convert(List<RexNode> filters, RelDataType rowType) {
        ArrayList<SqlNode> result = new ArrayList<SqlNode>(filters.size());
        for (RexNode node : filters) {
            result.add(SqlConverters.convert(node, rowType));
        }
        return result;
    }

    @Nullable
    public static SqlNode convert(RexNode node, final Schema rowSchema) {
        RexToSqlNodeConverterImpl conv = new RexToSqlNodeConverterImpl((RexSqlConvertletTable)TABLE){

            public SqlNode convertInputRef(RexInputRef ref) {
                return new SqlIdentifier(((Schema.Field)rowSchema.getFields().get(ref.getIndex())).name(), SqlParserPos.ZERO);
            }
        };
        return conv.convertNode(node);
    }

    public static List<SqlNode> convert(List<RexNode> filters, Schema rowSchema) {
        ArrayList<SqlNode> result = new ArrayList<SqlNode>(filters.size());
        for (RexNode node : filters) {
            result.add(SqlConverters.convert(node, rowSchema));
        }
        return result;
    }
}

