/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor.proto;

import gnu.trove.map.TMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.spf4j.base.StackSamples;
import org.spf4j.base.avro.Method;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.stackmonitor.proto.gen.ProtoSampleNodes;

public final class Converter {
    private Converter() {
    }

    public static void saveToFile(@Nonnull File file, @Nonnull SampleNode input) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            Converter.fromSampleNodeToProto((StackSamples)input).writeTo(bos);
        }
    }

    public static ProtoSampleNodes.Method fromMethodToProto(Method m) {
        return ProtoSampleNodes.Method.newBuilder().setMethodName(m.getName()).setDeclaringClass(m.getDeclaringClass()).build();
    }

    public static ProtoSampleNodes.SampleNode fromSampleNodeToProto(StackSamples node) {
        ProtoSampleNodes.SampleNode.Builder resultBuilder = ProtoSampleNodes.SampleNode.newBuilder().setCount(node.getSampleCount());
        TMap subNodes = node.getSubNodes();
        for (Map.Entry entry : subNodes.entrySet()) {
            resultBuilder.addSubNodes(ProtoSampleNodes.SamplePair.newBuilder().setMethod(Converter.fromMethodToProto((Method)entry.getKey())).setNode(Converter.fromSampleNodeToProto((StackSamples)entry.getValue())).build());
        }
        return resultBuilder.build();
    }

    public static SampleNode fromProtoToSampleNode(ProtoSampleNodes.SampleNodeOrBuilder node) {
        SampleNode result = new SampleNode(node.getCount());
        List<ProtoSampleNodes.SamplePair> sns = node.getSubNodesList();
        if (sns != null) {
            for (ProtoSampleNodes.SamplePair pair : sns) {
                ProtoSampleNodes.Method method = pair.getMethod();
                result.put((Object)new Method(method.getDeclaringClass(), method.getMethodName()), (Object)Converter.fromProtoToSampleNode(pair.getNode()));
            }
        }
        return result;
    }
}

