/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ui;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.spf4j.base.Methods;
import org.spf4j.base.Pair;
import org.spf4j.base.avro.Method;
import org.spf4j.ssdump2.Converter;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.ui.FlameStackPanel;
import org.spf4j.ui.HotFlameStackPanel;
import org.spf4j.ui.Spf4jFileFilter;
import org.spf4j.ui.StackPanelBase;

@SuppressFBWarnings(value={"FCBL_FIELD_COULD_BE_LOCAL", "SE_BAD_FIELD"})
public class StackDumpJInternalFrame
extends JInternalFrame {
    private SampleNode samples;
    private JButton exportButton;
    private JToggleButton graphToggle;
    private JToolBar samplesVisualizerToolbar;
    private JScrollPane ssScrollPanel;

    public StackDumpJInternalFrame(SampleNode samples, String title, boolean isgraph) {
        super(title);
        this.setName(title);
        this.initComponents();
        this.samples = samples == null ? SampleNode.createSampleNode((StackTraceElement[])new StackTraceElement[]{new StackTraceElement("NO SAMPLES", "", "", -1)}) : samples;
        this.setViewType(isgraph);
        this.ssScrollPanel.setVisible(true);
        this.pack();
    }

    private void setViewType(boolean isgraph) {
        StackPanelBase view = (StackPanelBase)this.ssScrollPanel.getViewport().getView();
        if (isgraph) {
            this.graphToggle.setSelected(true);
            if (view != null) {
                this.ssScrollPanel.setViewportView(new HotFlameStackPanel(view.getMethod(), view.getSamples(), view.getHistory()));
            } else {
                this.ssScrollPanel.setViewportView(new HotFlameStackPanel(Methods.ROOT, this.samples, new LinkedList<Pair<Method, SampleNode>>()));
            }
        } else {
            this.graphToggle.setSelected(false);
            if (view != null) {
                this.ssScrollPanel.setViewportView(new FlameStackPanel(view.getMethod(), view.getSamples(), view.getHistory()));
            } else {
                this.ssScrollPanel.setViewportView(new FlameStackPanel(Methods.ROOT, this.samples, new LinkedList<Pair<Method, SampleNode>>()));
            }
        }
    }

    @SuppressFBWarnings
    private void initComponents() {
        this.ssScrollPanel = new JScrollPane();
        this.samplesVisualizerToolbar = new JToolBar();
        this.graphToggle = new JToggleButton();
        this.exportButton = new JButton();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.ssScrollPanel.setAutoscrolls(true);
        this.samplesVisualizerToolbar.setRollover(true);
        this.graphToggle.setText("graph");
        this.graphToggle.setFocusable(false);
        this.graphToggle.setHorizontalTextPosition(0);
        this.graphToggle.setVerticalTextPosition(3);
        this.graphToggle.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StackDumpJInternalFrame.this.graphToggleItemStateChanged(evt);
            }
        });
        this.samplesVisualizerToolbar.add(this.graphToggle);
        this.exportButton.setText("export");
        this.exportButton.setFocusable(false);
        this.exportButton.setHorizontalTextPosition(0);
        this.exportButton.setVerticalTextPosition(3);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StackDumpJInternalFrame.this.exportButtonActionPerformed(evt);
            }
        });
        this.samplesVisualizerToolbar.add(this.exportButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.ssScrollPanel, -1, 412, Short.MAX_VALUE).add((Component)this.samplesVisualizerToolbar, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.samplesVisualizerToolbar, -2, 25, -2).addPreferredGap(0).add((Component)this.ssScrollPanel, -1, 339, Short.MAX_VALUE)));
        this.pack();
    }

    private void graphToggleItemStateChanged(ItemEvent evt) {
        this.setViewType(evt.getStateChange() == 1);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE", "UP_UNUSED_PARAMETER"})
    private void exportButtonActionPerformed(ActionEvent evt) {
        block38: {
            FileFilter[] xFF;
            JFileChooser fc = new JFileChooser();
            for (FileFilter ff : xFF = fc.getChoosableFileFilters()) {
                fc.removeChoosableFileFilter(ff);
            }
            fc.addChoosableFileFilter(Spf4jFileFilter.D3_JSON);
            fc.addChoosableFileFilter(Spf4jFileFilter.SPF4J_JSON);
            fc.addChoosableFileFilter(Spf4jFileFilter.SSDUMP2);
            fc.addChoosableFileFilter(Spf4jFileFilter.SSDUMP2_GZ);
            fc.setFileFilter(Spf4jFileFilter.D3_JSON);
            int retrival = fc.showSaveDialog(null);
            if (retrival == 0) {
                File selectedFile = fc.getSelectedFile();
                FileFilter fileFilter = fc.getFileFilter();
                if (!(fileFilter instanceof Spf4jFileFilter)) {
                    throw new IllegalArgumentException("Invalid file type selected " + fileFilter);
                }
                String suffix = ((Spf4jFileFilter)fileFilter).getSuffix();
                if (!selectedFile.getName().endsWith(suffix)) {
                    selectedFile = new File(selectedFile.getParentFile(), selectedFile.getName() + suffix);
                }
                if (Spf4jFileFilter.D3_JSON.accept(selectedFile)) {
                    try (BufferedWriter wr = Files.newBufferedWriter(selectedFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                        this.samples.writeD3JsonTo((Appendable)wr);
                        break block38;
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
                if (Spf4jFileFilter.SPF4J_JSON.accept(selectedFile)) {
                    try (BufferedWriter wr = Files.newBufferedWriter(selectedFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                        this.samples.writeJsonTo((Appendable)wr);
                        break block38;
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
                if (Spf4jFileFilter.SSDUMP2.accept(selectedFile) || Spf4jFileFilter.SSDUMP2_GZ.accept(selectedFile)) {
                    try {
                        Converter.save((File)selectedFile, (SampleNode)this.samples);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                } else {
                    throw new IllegalArgumentException("No ecognized extension for file " + selectedFile);
                }
            }
        }
    }
}

